/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.api.runtime.migration.ProcessInstanceSnapshot;
import org.camunda.bpm.engine.test.util.ExecutionTree;

public class ProcessInstanceSnapshotBuilder {
    protected ProcessEngine processEngine;
    protected String processInstanceId;
    protected ProcessInstanceSnapshot snapshot;

    public ProcessInstanceSnapshotBuilder(ProcessInstance processInstance, ProcessEngine processEngine) {
        this.processEngine = processEngine;
        this.processInstanceId = processInstance.getId();
        this.snapshot = new ProcessInstanceSnapshot(processInstance.getId(), processInstance.getProcessDefinitionId());
    }

    public ProcessInstanceSnapshotBuilder deploymentId() {
        String deploymentId = this.processEngine.getRepositoryService().getProcessDefinition(this.snapshot.getProcessDefinitionId()).getDeploymentId();
        this.snapshot.setDeploymentId(deploymentId);
        return this;
    }

    public ProcessInstanceSnapshotBuilder activityTree() {
        ActivityInstance activityInstance = this.processEngine.getRuntimeService().getActivityInstance(this.processInstanceId);
        this.snapshot.setActivityTree(activityInstance);
        return this;
    }

    public ProcessInstanceSnapshotBuilder executionTree() {
        ExecutionTree executionTree = ExecutionTree.forExecution(this.processInstanceId, this.processEngine);
        this.snapshot.setExecutionTree(executionTree);
        return this;
    }

    public ProcessInstanceSnapshotBuilder tasks() {
        List tasks = this.processEngine.getTaskService().createTaskQuery().processInstanceId(this.processInstanceId).list();
        this.snapshot.setTasks(tasks);
        return this;
    }

    public ProcessInstanceSnapshotBuilder eventSubscriptions() {
        List eventSubscriptions = this.processEngine.getRuntimeService().createEventSubscriptionQuery().processInstanceId(this.processInstanceId).list();
        this.snapshot.setEventSubscriptions(eventSubscriptions);
        return this;
    }

    public ProcessInstanceSnapshotBuilder jobs() {
        List jobs = this.processEngine.getManagementService().createJobQuery().processInstanceId(this.processInstanceId).list();
        this.snapshot.setJobs(jobs);
        String processDefinitionId = ((ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(this.processInstanceId).singleResult()).getProcessDefinitionId();
        List jobDefinitions = this.processEngine.getManagementService().createJobDefinitionQuery().processDefinitionId(processDefinitionId).list();
        this.snapshot.setJobDefinitions(jobDefinitions);
        return this;
    }

    public ProcessInstanceSnapshotBuilder variables() {
        List variables = this.processEngine.getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{this.processInstanceId}).list();
        this.snapshot.setVariables(variables);
        return this;
    }

    public ProcessInstanceSnapshot build() {
        return this.snapshot;
    }

    public ProcessInstanceSnapshot full() {
        this.deploymentId();
        this.activityTree();
        this.executionTree();
        this.tasks();
        this.eventSubscriptions();
        this.jobs();
        this.variables();
        return this.build();
    }
}

