/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cockroachdb;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineBootstrapCommand;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.ProcessEngines;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.impl.BootstrapEngineCommand;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.DeployCmd;
import org.camunda.bpm.engine.impl.cmd.HistoryCleanupCmd;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandInvocationContext;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.repository.DeploymentBuilderImpl;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.jobexecutor.ControllableJobExecutor;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredDatabase(includes={"cockroachdb"})
public class CockroachDbExclusiveLockDisabledTest
extends ConcurrencyTestHelper {
    protected static final String PROCESS_ENGINE_NAME = "retriableBootstrapProcessEngine";
    protected static final int COMMAND_RETRIES = 3;
    protected final BpmnModelInstance PROCESS_WITH_USERTASK = Bpmn.createExecutableProcess((String)"process").startEvent().userTask().endEvent().done();
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule(c -> c.setCommandRetries(3).setJobExecutor((JobExecutor)new ControllableJobExecutor()));
    protected ProvidedProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected HistoryService historyService;

    @Before
    public void setUp() throws Exception {
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        TestHelper.deleteInstallationId((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
        TestHelper.deleteTelemetryProperty((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
        TestHelper.deleteHistoryLevel((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @After
    public void tearDown() throws Exception {
        this.testRule.deleteHistoryCleanupJobs();
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute(commandContext -> {
            commandContext.getMeterLogManager().deleteAll();
            List jobs = this.managementService.createJobQuery().list();
            if (jobs.size() > 0) {
                String jobId = ((Job)jobs.get(0)).getId();
                commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
            }
            commandContext.getHistoricJobLogManager().deleteHistoricJobLogsByHandlerType("history-cleanup");
            return null;
        });
        for (Deployment deployment : this.repositoryService.createDeploymentQuery().list()) {
            this.repositoryService.deleteDeployment(deployment.getId(), true);
        }
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.closeDownProcessEngine();
    }

    @Test
    public void shouldRetryDeployCmdWithoutExclusiveLock() {
        DeploymentBuilder deploymentOne = this.createDeploymentBuilder();
        DeploymentBuilder deploymentTwo = this.createDeploymentBuilder();
        ControllableDeployCommand deployCommand1 = new ControllableDeployCommand(deploymentOne);
        ControllableDeployCommand deployCommand2 = new ControllableDeployCommand(deploymentTwo);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(deployCommand1);
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(deployCommand2);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        thread2.waitUntilDone(true);
        List processDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionVersion().asc()).list();
        Assert.assertThat((Object)processDefinitions.size(), (Matcher)CoreMatchers.is((Object)2));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(0)).getVersion(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((ProcessDefinition)processDefinitions.get(1)).getVersion(), (Matcher)CoreMatchers.is((Object)2));
        Assertions.assertThat((int)deployCommand1.getTries()).isEqualTo(1);
        Assertions.assertThat((int)deployCommand2.getTries()).isEqualTo(2);
    }

    @Test
    public void shouldEnableTelemetryWithoutExclusiveLock() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ControllableProcessEngineBootstrapCommand telemetrySetupCommand1 = new ControllableProcessEngineBootstrapCommand(ControllableUpdateTelemetrySetupCommand.class);
        ControllableProcessEngineBootstrapCommand telemetrySetupCommand2 = new ControllableProcessEngineBootstrapCommand(ControllableUpdateTelemetrySetupCommand.class);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(telemetrySetupCommand1);
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(telemetrySetupCommand2);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
        Assertions.assertThat((int)telemetrySetupCommand1.getTries()).isOne();
        Assertions.assertThat((int)telemetrySetupCommand2.getTries()).isEqualTo(2);
    }

    @Test
    public void shouldSetInstallationIdWithoutExclusiveLock() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        ControllableProcessEngineBootstrapCommand initializationCommand1 = new ControllableProcessEngineBootstrapCommand(ControllableInstallationIdInitializationCommand.class);
        ControllableProcessEngineBootstrapCommand initializationCommand2 = new ControllableProcessEngineBootstrapCommand(ControllableInstallationIdInitializationCommand.class);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(initializationCommand1);
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(initializationCommand2);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        String firstInstallationId = this.processEngineConfiguration.getInstallationId();
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
        Assertions.assertThat((int)initializationCommand1.getTries()).isOne();
        Assertions.assertThat((int)initializationCommand2.getTries()).isEqualTo(2);
        String secondInstallationId = this.processEngineConfiguration.getInstallationId();
        Assertions.assertThat((String)secondInstallationId).isNotEmpty();
        Assertions.assertThat((String)secondInstallationId).isEqualTo((Object)firstInstallationId);
        Assertions.assertThat((String)secondInstallationId).matches((CharSequence)"[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}");
    }

    @Test
    public void shouldReconfigureHistoryCleanupJobWithoutExclusiveLock() {
        ControllableHistoryCleanupCommand historyCleanupCommand1 = new ControllableHistoryCleanupCommand();
        ControllableHistoryCleanupCommand historyCleanupCommand2 = new ControllableHistoryCleanupCommand();
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(historyCleanupCommand1);
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(historyCleanupCommand2);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        List historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Job firstHistoryCleanupJob = (Job)historyCleanupJobs.get(0);
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread2.getException());
        Assert.assertEquals((long)2L, (long)((ControllableHistoryCleanupCommand)this.controllableCommands.get(1)).getTries());
        historyCleanupJobs = this.historyService.findHistoryCleanupJobs();
        Assert.assertEquals((long)1L, (long)historyCleanupJobs.size());
        Job secondHistoryCleanupJob = (Job)historyCleanupJobs.get(0);
        Assert.assertTrue((boolean)secondHistoryCleanupJob.getDuedate().after(firstHistoryCleanupJob.getDuedate()));
        Assertions.assertThat((int)historyCleanupCommand1.getTries()).isOne();
        Assertions.assertThat((int)historyCleanupCommand2.getTries()).isEqualTo(2);
    }

    @Test
    public void shouldRetryTxToBootstrapConcurrentProcessEngineWithoutExclusiveLock() throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException {
        this.historyService.cleanUpHistoryAsync(true);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableJobExecutionCommand());
        thread1.reportInterrupts();
        thread1.waitForSync();
        ControllableProcessEngineBootstrapCommand bootstrapCommand = new ControllableProcessEngineBootstrapCommand(ControllableHistoryCleanupBootstrapEngineCommand.class);
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(bootstrapCommand);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
        Assertions.assertThat((Throwable)bootstrapCommand.getContextSpy().getThrowable()).isNull();
        Assertions.assertThat((int)bootstrapCommand.getTries()).isEqualTo(2);
        Assert.assertNotNull(ProcessEngines.getProcessEngines().get(PROCESS_ENGINE_NAME));
    }

    @Test
    public void shouldUpdateHistoryLevelWithoutExclusiveLock() {
        ControllableUpdateHistoryLevelCommand historyLevelCommand1 = new ControllableUpdateHistoryLevelCommand();
        ControllableUpdateHistoryLevelCommand historyLevelCommand2 = new ControllableUpdateHistoryLevelCommand();
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(historyLevelCommand1);
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(historyLevelCommand2);
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        thread2.waitForSync();
        thread1.waitUntilDone();
        thread2.waitUntilDone(true);
        Assert.assertNull((Object)thread1.getException());
        Assert.assertNull((Object)thread2.getException());
        Assertions.assertThat((int)historyLevelCommand1.getTries()).isOne();
        Assertions.assertThat((int)historyLevelCommand2.getTries()).isEqualTo(2);
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        Assert.assertEquals((Object)"full", (Object)historyLevel.getName());
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return new DeploymentBuilderImpl(null).name("some-deployment-name").addModelInstance("foo.bpmn", this.PROCESS_WITH_USERTASK);
    }

    protected void closeDownProcessEngine() {
        ProcessEngine otherProcessEngine = ProcessEngines.getProcessEngine((String)PROCESS_ENGINE_NAME);
        if (otherProcessEngine != null) {
            ((ProcessEngineConfigurationImpl)otherProcessEngine.getProcessEngineConfiguration()).getCommandExecutorTxRequired().execute(commandContext -> {
                List jobs = otherProcessEngine.getManagementService().createJobQuery().list();
                if (jobs.size() > 0) {
                    Assert.assertEquals((long)1L, (long)jobs.size());
                    String jobId = ((Job)jobs.get(0)).getId();
                    commandContext.getJobManager().deleteJob((JobEntity)jobs.get(0));
                    commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                }
                return null;
            });
            otherProcessEngine.close();
            ProcessEngines.unregister((ProcessEngine)otherProcessEngine);
        }
    }

    protected static class ControllableDeployCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected final DeploymentBuilder deploymentBuilder;
        protected DeployCmd deployCmd;
        protected int tries;

        public ControllableDeployCommand(DeploymentBuilder deploymentBuilder) {
            this.deploymentBuilder = deploymentBuilder;
            this.deployCmd = new DeployCmd((DeploymentBuilderImpl)deploymentBuilder);
            this.tries = 0;
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            ++this.tries;
            this.deployCmd.execute(commandContext);
            this.monitor.sync();
            return null;
        }

        public int getTries() {
            return this.tries;
        }

        public boolean isRetryable() {
            return this.deployCmd.isRetryable();
        }
    }

    protected static class ControllableProcessEngineBootstrapCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableBootstrapEngineCommand bootstrapCommand;

        public ControllableProcessEngineBootstrapCommand(Class<? extends ControllableBootstrapEngineCommand> bootstrapCommandClass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
            Constructor<? extends ControllableBootstrapEngineCommand> cons = bootstrapCommandClass.getConstructor(ConcurrencyTestHelper.ThreadControl.class);
            this.bootstrapCommand = cons.newInstance(this.monitor);
        }

        public Void execute(CommandContext commandContext) {
            ProcessEngineConfigurationImpl processEngineConfiguration = ((ProcessEngineConfigurationImpl)ProcessEngineConfiguration.createProcessEngineConfigurationFromResource((String)"camunda.cfg.xml")).setCommandRetries(3).setProcessEngineName(CockroachDbExclusiveLockDisabledTest.PROCESS_ENGINE_NAME).setInitializeTelemetry(false);
            processEngineConfiguration.setProcessEngineBootstrapCommand((ProcessEngineBootstrapCommand)this.bootstrapCommand);
            processEngineConfiguration.buildProcessEngine();
            return null;
        }

        public int getTries() {
            return this.bootstrapCommand.getTries();
        }

        public CommandInvocationContext getContextSpy() {
            return this.bootstrapCommand.getSpy();
        }
    }

    protected static class ControllableUpdateTelemetrySetupCommand
    extends ControllableBootstrapEngineCommand {
        public ControllableUpdateTelemetrySetupCommand(ConcurrencyTestHelper.ThreadControl threadControl) {
            super(threadControl);
        }

        public void initializeTelemetryProperty(CommandContext commandContext) {
            this.monitor.sync();
            ++this.tries;
            super.initializeTelemetryProperty(commandContext);
            this.monitor.sync();
        }
    }

    protected static class ControllableInstallationIdInitializationCommand
    extends ControllableBootstrapEngineCommand {
        public ControllableInstallationIdInitializationCommand(ConcurrencyTestHelper.ThreadControl threadControl) {
            super(threadControl);
        }

        public void initializeInstallationId(CommandContext commandContext) {
            this.monitor.sync();
            ++this.tries;
            super.initializeInstallationId(commandContext);
            this.monitor.sync();
        }
    }

    protected static class ControllableHistoryCleanupCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected int tries = 0;
        protected HistoryCleanupCmd historyCleanupCmd = new HistoryCleanupCmd(true);

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            this.historyCleanupCmd.execute(commandContext);
            ++this.tries;
            this.monitor.sync();
            return null;
        }

        public boolean isRetryable() {
            return this.historyCleanupCmd.isRetryable();
        }

        public int getTries() {
            return this.tries;
        }
    }

    protected static class ControllableJobExecutionCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableJobExecutionCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            List historyCleanupJobs = commandContext.getProcessEngineConfiguration().getHistoryService().findHistoryCleanupJobs();
            for (Job job : historyCleanupJobs) {
                commandContext.getProcessEngineConfiguration().getManagementService().executeJob(job.getId());
            }
            this.monitor.sync();
            return null;
        }
    }

    protected static class ControllableHistoryCleanupBootstrapEngineCommand
    extends ControllableBootstrapEngineCommand {
        public ControllableHistoryCleanupBootstrapEngineCommand(ConcurrencyTestHelper.ThreadControl threadControl) {
            super(threadControl);
        }

        protected void createHistoryCleanupJob(CommandContext commandContext) {
            this.monitor.sync();
            ++this.tries;
            super.createHistoryCleanupJob(commandContext);
            this.spy = Context.getCommandInvocationContext();
            this.monitor.sync();
        }
    }

    protected static class ControllableUpdateHistoryLevelCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected HistoryLevelSetupCommand historyLevelSetupCommand = new HistoryLevelSetupCommand();
        protected int tries = 0;

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            ++this.tries;
            this.historyLevelSetupCommand.execute(commandContext);
            this.monitor.sync();
            return null;
        }

        public boolean isRetryable() {
            return this.historyLevelSetupCommand.isRetryable();
        }

        public int getTries() {
            return this.tries;
        }
    }

    protected static class ControllableBootstrapEngineCommand
    extends BootstrapEngineCommand {
        protected final ConcurrencyTestHelper.ThreadControl monitor;
        protected CommandInvocationContext spy;
        protected int tries;

        public ControllableBootstrapEngineCommand(ConcurrencyTestHelper.ThreadControl threadControl) {
            this.monitor = threadControl;
            this.tries = 0;
        }

        public int getTries() {
            return this.tries;
        }

        public boolean isRetryable() {
            return super.isRetryable();
        }

        public CommandInvocationContext getSpy() {
            return this.spy;
        }
    }
}

