/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.event.HistoryEventTypes;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.test.api.history.removaltime.cleanup.CustomHistoryLevelRemovalTime;
import org.junit.After;
import org.junit.AfterClass;

public abstract class AbstractHistoryCleanupSchedulerTest {
    protected Class<?> thisClass = this.getClass();
    protected static HistoryLevel customHistoryLevel = new CustomHistoryLevelRemovalTime();
    protected static ProcessEngineConfigurationImpl engineConfiguration;
    protected Set<String> jobIds = new HashSet<String>();
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected final Date END_DATE = new Date(1363608000000L);

    public void initEngineConfiguration(ProcessEngineConfigurationImpl engineConfiguration) {
        engineConfiguration.setHistoryRemovalTimeStrategy("end").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        engineConfiguration.setHistoryCleanupBatchSize(500);
        engineConfiguration.setHistoryCleanupBatchWindowStartTime("13:00");
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
        engineConfiguration.initHistoryCleanup();
    }

    @After
    public void tearDown() {
        this.clearMeterLog();
        for (String jobId : this.jobIds) {
            this.clearJobLog(jobId);
            this.clearJob(jobId);
        }
    }

    @AfterClass
    public static void tearDownAfterAll() {
        if (engineConfiguration != null) {
            engineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
            engineConfiguration.setHistoryCleanupStrategy("endTimeBased");
            engineConfiguration.setHistoryCleanupBatchSize(500);
            engineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
            engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
            engineConfiguration.initHistoryCleanup();
        }
        ClockUtil.reset();
    }

    protected List<HistoryLevel> setCustomHistoryLevel(HistoryEventTypes eventType) {
        ((CustomHistoryLevelRemovalTime)customHistoryLevel).setEventTypes(eventType);
        return Collections.singletonList(customHistoryLevel);
    }

    protected List<Job> runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : jobs) {
            this.jobIds.add(job.getId());
            this.managementService.executeJob(job.getId());
        }
        return jobs;
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = engineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearJob(final String jobId) {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    commandContext.getJobManager().delete((DbEntity)job);
                }
                return null;
            }
        });
    }

    protected void clearMeterLog() {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    protected static List<HistoryLevel> setCustomHistoryLevel(HistoryEventTypes ... eventType) {
        ((CustomHistoryLevelRemovalTime)customHistoryLevel).setEventTypes(eventType);
        return Collections.singletonList(customHistoryLevel);
    }

    public static ProcessEngineConfiguration configure(ProcessEngineConfigurationImpl configuration, HistoryEventTypes ... historyEventTypes) {
        configuration.setJdbcUrl("jdbc:h2:mem:" + AbstractHistoryCleanupSchedulerTest.class.getSimpleName());
        configuration.setCustomHistoryLevels(AbstractHistoryCleanupSchedulerTest.setCustomHistoryLevel(historyEventTypes));
        configuration.setHistory(customHistoryLevel.getName());
        configuration.setDatabaseSchemaUpdate("create-drop");
        return configuration;
    }
}

