/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceModificationInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ProcessInstanceModificationBoundaryEventTest
extends PluggableProcessEngineTest {
    protected static final String INTERRUPTING_BOUNDARY_EVENT = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEvent.bpmn20.xml";
    protected static final String NON_INTERRUPTING_BOUNDARY_EVENT = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEvent.bpmn20.xml";
    protected static final String INTERRUPTING_BOUNDARY_EVENT_INSIDE_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventInsideSubProcess.bpmn20.xml";
    protected static final String NON_INTERRUPTING_BOUNDARY_EVENT_INSIDE_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventInsideSubProcess.bpmn20.xml";
    protected static final String INTERRUPTING_BOUNDARY_EVENT_ON_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventOnSubProcess.bpmn20.xml";
    protected static final String NON_INTERRUPTING_BOUNDARY_EVENT_ON_SUBPROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventOnSubProcess.bpmn20.xml";
    protected static final String INTERRUPTING_BOUNDARY_EVENT_WITH_PARALLEL_GATEWAY = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventWithParallelGateway.bpmn20.xml";
    protected static final String NON_INTERRUPTING_BOUNDARY_EVENT_WITH_PARALLEL_GATEWAY = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventWithParallelGateway.bpmn20.xml";
    protected static final String INTERRUPTING_BOUNDARY_EVENT_WITH_PARALLEL_GATEWAY_INSIDE_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventWithParallelGatewayInsideSubProcess.bpmn20.xml";
    protected static final String NON_INTERRUPTING_BOUNDARY_EVENT_WITH_PARALLEL_GATEWAY_INSIDE_SUB_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventWithParallelGatewayInsideSubProcess.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeTaskAfterBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("task1").scope().done());
        this.completeTasksInOrder("task1", "task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("taskAfterBoundaryEvent").scope().done());
        this.completeTasksInOrder("taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeTaskAfterBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeTaskAfterNonInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("task1").scope().done());
        this.completeTasksInOrder("task1", "taskAfterBoundaryEvent", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeNonInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("task1").scope().done());
        this.completeTasksInOrder("task1", "taskAfterBoundaryEvent", "task2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeTaskAfterNonInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEvent.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeNonInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task2").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child("task2").concurrent().noScope().done());
        this.completeTasksInOrder("task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeTaskAfterBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerTaskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask1").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask1").scope().done());
        this.completeTasksInOrder("innerTask1", "innerTaskAfterBoundaryEvent", "innerTask2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("innerTaskAfterBoundaryEvent").scope().done());
        this.completeTasksInOrder("innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeTaskAfterNonInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerTaskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask1").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask1").scope().done());
        this.completeTasksInOrder("innerTask1", "innerTaskAfterBoundaryEvent", "innerTask2");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask1AndStartBeforeNonInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask1").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask1").scope().done());
        this.completeTasksInOrder("innerTask1", "innerTask2", "innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeTaskAfterBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerTaskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask2").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child("innerTask2").concurrent().noScope().done());
        this.completeTasksInOrder("innerTask2", "innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask2").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child("innerTask2").concurrent().noScope().done());
        this.completeTasksInOrder("innerTask2", "innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeTaskAfterNonInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerTaskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask2").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child("innerTask2").concurrent().noScope().done());
        this.completeTasksInOrder("innerTask2", "innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventInsideSubProcess.bpmn20.xml"})
    @Test
    public void testTask2AndStartBeforeNonInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("innerBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask2").activity("innerTaskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("innerTaskAfterBoundaryEvent").concurrent().noScope().up().child("innerTask2").concurrent().noScope().done());
        this.completeTasksInOrder("innerTask2", "innerTaskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventOnSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeTaskAfterBoundaryEventOnSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").endScope().activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        this.completeTasksInOrder("innerTask", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventOnSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeBoundaryEventOnSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree("taskAfterBoundaryEvent").scope().done());
        this.completeTasksInOrder("taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventOnSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeTaskAfterNonInterruptingBoundaryEventOnSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").endScope().activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        this.completeTasksInOrder("innerTask", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventOnSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeNonInterruptingBoundaryEventOnSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("taskAfterBoundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").endScope().activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("taskAfterBoundaryEvent").concurrent().noScope().up().child(null).concurrent().noScope().child("innerTask").scope().done());
        this.completeTasksInOrder("innerTask", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventWithParallelGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child("taskAfterBoundaryEvent").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventWithParallelGateway.bpmn20.xml"})
    @Test
    public void testStartBeforeNonInterruptingBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("task1").activity("task2").activity("taskAfterBoundaryEvent").done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("task2").scope().up().up().child("taskAfterBoundaryEvent").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.interruptingBoundaryEventWithParallelGatewayInsideSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task1").activity("taskAfterBoundaryEvent").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").concurrent().noScope().up().child("taskAfterBoundaryEvent").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.nonInterruptingBoundaryEventWithParallelGatewayInsideSubProcess.bpmn20.xml"})
    @Test
    public void testStartBeforeNonInterruptingBoundaryEventInsideSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = processInstance.getId();
        ((ProcessInstanceModificationInstantiationBuilder)this.runtimeService.createProcessInstanceModification(processInstanceId).startBeforeActivity("boundaryEvent")).execute();
        ActivityInstance updatedTree = this.runtimeService.getActivityInstance(processInstanceId);
        Assert.assertNotNull((Object)updatedTree);
        Assert.assertEquals((Object)processInstanceId, (Object)updatedTree.getProcessInstanceId());
        ActivityInstanceAssert.assertThat(updatedTree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("task1").activity("task2").activity("taskAfterBoundaryEvent").endScope().done());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("task1").concurrent().noScope().up().child(null).concurrent().noScope().child("task2").scope().up().up().child("taskAfterBoundaryEvent").concurrent().noScope().done());
        this.completeTasksInOrder("task1", "task2", "taskAfterBoundaryEvent");
        this.testRule.assertProcessEnded(processInstanceId);
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

