/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import java.util.List;
import org.camunda.bpm.engine.history.HistoricActivityInstance;
import org.camunda.bpm.engine.history.HistoricDetail;
import org.camunda.bpm.engine.history.HistoricProcessInstance;
import org.camunda.bpm.engine.history.HistoricVariableInstance;
import org.camunda.bpm.engine.history.HistoricVariableUpdate;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

@RequiredHistoryLevel(value="full")
public class ProcessInstantiationAtActivitiesHistoryTest
extends PluggableProcessEngineTest {
    protected static final String PARALLEL_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.parallelGateway.bpmn20.xml";
    protected static final String EXCLUSIVE_GATEWAY_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml";
    protected static final String SUBPROCESS_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml";
    protected static final String ASYNC_PROCESS = "org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml";

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceForSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicInstance);
        Assert.assertEquals((Object)instance.getId(), (Object)historicInstance.getId());
        Assert.assertNotNull((Object)historicInstance.getStartTime());
        Assert.assertNull((Object)historicInstance.getEndTime());
        Assert.assertEquals((Object)"task1", (Object)historicInstance.getStartActivityId());
        HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicActivityInstance);
        Assert.assertEquals((Object)"task1", (Object)historicActivityInstance.getActivityId());
        Assert.assertNotNull((Object)historicActivityInstance.getId());
        Assert.assertFalse((boolean)instance.getId().equals(historicActivityInstance.getId()));
        Assert.assertNotNull((Object)historicActivityInstance.getStartTime());
        Assert.assertNull((Object)historicActivityInstance.getEndTime());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.subprocess.bpmn20.xml"})
    @Test
    public void testHistoricActivityInstancesForSubprocess() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("subprocess").startBeforeActivity("innerTask")).startBeforeActivity("theSubProcessStart")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicInstance);
        Assert.assertEquals((Object)instance.getId(), (Object)historicInstance.getId());
        Assert.assertNotNull((Object)historicInstance.getStartTime());
        Assert.assertNull((Object)historicInstance.getEndTime());
        Assert.assertEquals((Object)"innerTask", (Object)historicInstance.getStartActivityId());
        Assert.assertEquals((long)4L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        HistoricActivityInstance subProcessInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").singleResult();
        Assert.assertNotNull((Object)subProcessInstance);
        Assert.assertEquals((Object)"subProcess", (Object)subProcessInstance.getActivityId());
        Assert.assertNotNull((Object)subProcessInstance.getId());
        Assert.assertFalse((boolean)instance.getId().equals(subProcessInstance.getId()));
        Assert.assertNotNull((Object)subProcessInstance.getStartTime());
        Assert.assertNull((Object)subProcessInstance.getEndTime());
        HistoricActivityInstance startEventInstance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("theSubProcessStart").singleResult();
        Assert.assertNotNull((Object)startEventInstance);
        Assert.assertEquals((Object)"theSubProcessStart", (Object)startEventInstance.getActivityId());
        Assert.assertNotNull((Object)startEventInstance.getId());
        Assert.assertFalse((boolean)instance.getId().equals(startEventInstance.getId()));
        Assert.assertNotNull((Object)startEventInstance.getStartTime());
        Assert.assertNotNull((Object)startEventInstance.getEndTime());
        List innerTaskInstances = this.historyService.createHistoricActivityInstanceQuery().activityId("innerTask").list();
        Assert.assertEquals((long)2L, (long)innerTaskInstances.size());
        for (HistoricActivityInstance innerTaskInstance : innerTaskInstances) {
            Assert.assertNotNull((Object)innerTaskInstance);
            Assert.assertEquals((Object)"innerTask", (Object)innerTaskInstance.getActivityId());
            Assert.assertNotNull((Object)innerTaskInstance.getId());
            Assert.assertFalse((boolean)instance.getId().equals(innerTaskInstance.getId()));
            Assert.assertNotNull((Object)innerTaskInstance.getStartTime());
            Assert.assertNull((Object)innerTaskInstance.getEndTime());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGatewayAsyncTask.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceAsyncStartEvent() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task2")).setVariable("aVar", (Object)"aValue")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicInstance);
        Assert.assertEquals((Object)instance.getId(), (Object)historicInstance.getId());
        Assert.assertNotNull((Object)historicInstance.getStartTime());
        Assert.assertNull((Object)historicInstance.getEndTime());
        Assert.assertEquals((Object)"task2", (Object)historicInstance.getStartActivityId());
        Assert.assertEquals((long)0L, (long)this.historyService.createHistoricActivityInstanceQuery().count());
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)instance.getId(), (Object)historicVariable.getProcessInstanceId());
        Assert.assertEquals((Object)activityInstance.getId(), (Object)historicVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"aVar", (Object)historicVariable.getName());
        Assert.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        Assert.assertEquals((Object)instance.getId(), (Object)historicDetail.getProcessInstanceId());
        Assert.assertNotNull((Object)historicDetail);
        Assert.assertNull((Object)historicDetail.getActivityInstanceId());
        Assert.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        Assert.assertEquals((Object)"aVar", (Object)((HistoricVariableUpdate)historicDetail).getVariableName());
        Assert.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceForSingleActivityInstantiation() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task1")).setVariable("aVar", (Object)"aValue")).execute();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)instance.getId(), (Object)historicVariable.getProcessInstanceId());
        Assert.assertEquals((Object)activityInstance.getId(), (Object)historicVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"aVar", (Object)historicVariable.getName());
        Assert.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        Assert.assertEquals((Object)instance.getId(), (Object)historicDetail.getProcessInstanceId());
        Assert.assertNotNull((Object)historicDetail);
        Assert.assertNull((Object)historicDetail.getActivityInstanceId());
        Assert.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        Assert.assertEquals((Object)"aVar", (Object)((HistoricVariableUpdate)historicDetail).getVariableName());
        Assert.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testHistoricVariableInstanceSetOnProcessInstance() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").setVariable("aVar", (Object)"aValue")).startBeforeActivity("task1")).execute();
        ActivityInstance activityInstance = this.runtimeService.getActivityInstance(instance.getId());
        HistoricVariableInstance historicVariable = (HistoricVariableInstance)this.historyService.createHistoricVariableInstanceQuery().variableName("aVar").singleResult();
        Assert.assertNotNull((Object)historicVariable);
        Assert.assertEquals((Object)instance.getId(), (Object)historicVariable.getProcessInstanceId());
        Assert.assertEquals((Object)activityInstance.getId(), (Object)historicVariable.getActivityInstanceId());
        Assert.assertEquals((Object)"aVar", (Object)historicVariable.getName());
        Assert.assertEquals((Object)"aValue", (Object)historicVariable.getValue());
        HistoricDetail historicDetail = (HistoricDetail)this.historyService.createHistoricDetailQuery().variableInstanceId(historicVariable.getId()).singleResult();
        Assert.assertEquals((Object)instance.getId(), (Object)historicDetail.getProcessInstanceId());
        Assert.assertNotNull((Object)historicDetail);
        Assert.assertEquals((Object)instance.getId(), (Object)historicDetail.getActivityInstanceId());
        Assert.assertTrue((boolean)(historicDetail instanceof HistoricVariableUpdate));
        Assert.assertEquals((Object)"aVar", (Object)((HistoricVariableUpdate)historicDetail).getVariableName());
        Assert.assertEquals((Object)"aValue", (Object)((HistoricVariableUpdate)historicDetail).getValue());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testHistoricProcessInstanceForSynchronousCompletion() {
        ProcessInstance instance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startAfterActivity("task1")).execute();
        HistoricProcessInstance historicInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().singleResult();
        Assert.assertNotNull((Object)historicInstance);
        Assert.assertEquals((Object)instance.getId(), (Object)historicInstance.getId());
        Assert.assertNotNull((Object)historicInstance.getStartTime());
        Assert.assertNotNull((Object)historicInstance.getEndTime());
        Assert.assertEquals((Object)"join", (Object)historicInstance.getStartActivityId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/ProcessInstanceModificationTest.exclusiveGateway.bpmn20.xml"})
    @Test
    public void testSkipCustomListenerEnsureHistoryWritten() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("exclusiveGateway").startBeforeActivity("task2")).execute(true, false);
        Task task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task2").singleResult();
        HistoricActivityInstance instance = (HistoricActivityInstance)this.historyService.createHistoricActivityInstanceQuery().activityId("task2").singleResult();
        Assert.assertNotNull((Object)instance);
        Assert.assertEquals((Object)task.getId(), (Object)instance.getTaskId());
        Assert.assertEquals((Object)"kermit", (Object)instance.getAssignee());
    }

    protected void completeTasksInOrder(String ... taskNames) {
        for (String taskName : taskNames) {
            List tasks = this.taskService.createTaskQuery().taskDefinitionKey(taskName).listPage(0, 1);
            Assert.assertTrue((String)("task for activity " + taskName + " does not exist"), (!tasks.isEmpty() ? 1 : 0) != 0);
            this.taskService.complete(((Task)tasks.get(0)).getId());
        }
    }
}

