/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime.migration;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.MigrationTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class MigrateSuspendedInstanceTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected MigrationTestRule testHelper = new MigrationTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected RuntimeService runtimeService;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;

    @Before
    public void setup() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
    }

    @Test
    public void shouldNotExecuteTimerJobAfterMigrateSuspendedInstance() {
        BpmnModelInstance modelInstanceVersion1 = Bpmn.createExecutableProcess((String)"processId").startEvent().userTask("userTask").endEvent().done();
        ProcessDefinition definition1 = this.testHelper.deployAndGetDefinition(modelInstanceVersion1);
        ProcessInstance processInstance1 = this.runtimeService.startProcessInstanceById(definition1.getId());
        this.runtimeService.suspendProcessInstanceById(processInstance1.getId());
        BpmnModelInstance modelInstanceVersion2 = ((BoundaryEventBuilder)((BoundaryEventBuilder)Bpmn.createExecutableProcess((String)"processId").startEvent().userTask("userTask").endEvent().moveToActivity("userTask").boundaryEvent().cancelActivity(Boolean.valueOf(false))).timerWithCycle("R3/PT5S")).endEvent().done();
        ProcessDefinition definition2 = this.testHelper.deployAndGetDefinition(modelInstanceVersion2);
        MigrationPlan migrationPlan = this.runtimeService.createMigrationPlan(definition1.getId(), definition2.getId()).mapEqualActivities().build();
        this.testHelper.migrateProcessInstance(migrationPlan, processInstance1);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((boolean)job.isSuspended()).isTrue();
        List incidents = this.runtimeService.createIncidentQuery().list();
        Assertions.assertThat((List)incidents).isEmpty();
    }
}

