/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.AssertionFailedError;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.delegate.Expression;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmmn.behavior.CaseControlRuleImpl;
import org.camunda.bpm.engine.impl.el.FixedValue;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentWithDefinitions;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseInstance;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class ProcessEngineTestRule
extends TestWatcher {
    public static final String DEFAULT_BPMN_RESOURCE_NAME = "process.bpmn20.xml";
    protected ProcessEngineRule processEngineRule;
    protected ProcessEngine processEngine;

    public ProcessEngineTestRule(ProcessEngineRule processEngineRule) {
        this.processEngineRule = processEngineRule;
    }

    protected void starting(Description description) {
        this.processEngine = this.processEngineRule.getProcessEngine();
    }

    protected void finished(Description description) {
        this.processEngine = null;
    }

    public void assertProcessEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        ((AbstractObjectAssert)Assertions.assertThat((Object)processInstance).describedAs("Process instance with id " + processInstanceId + " is not finished", new Object[0])).isNull();
    }

    public void assertProcessNotEnded(String processInstanceId) {
        ProcessInstance processInstance = (ProcessInstance)this.processEngine.getRuntimeService().createProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
        if (processInstance == null) {
            throw new AssertionFailedError("Expected process instance '" + processInstanceId + "' to be still active but it was not in the db");
        }
    }

    public void assertCaseEnded(String caseInstanceId) {
        CaseInstance caseInstance = (CaseInstance)this.processEngine.getCaseService().createCaseInstanceQuery().caseInstanceId(caseInstanceId).singleResult();
        ((AbstractObjectAssert)Assertions.assertThat((Object)caseInstance).describedAs("Case instance with id " + caseInstanceId + " is not finished", new Object[0])).isNull();
    }

    public DeploymentWithDefinitions deploy(BpmnModelInstance ... bpmnModelInstances) {
        return this.deploy(this.createDeploymentBuilder(), Arrays.asList(bpmnModelInstances), Collections.emptyList());
    }

    public DeploymentWithDefinitions deploy(String ... resources) {
        return this.deploy(this.createDeploymentBuilder(), Collections.emptyList(), Arrays.asList(resources));
    }

    public <T extends DeploymentWithDefinitions> T deploy(DeploymentBuilder deploymentBuilder) {
        DeploymentWithDefinitions deployment = deploymentBuilder.deployWithResult();
        this.processEngineRule.manageDeployment((Deployment)deployment);
        return (T)deployment;
    }

    public Deployment deploy(BpmnModelInstance bpmnModelInstance, String resource) {
        return this.deploy(this.createDeploymentBuilder(), Collections.singletonList(bpmnModelInstance), Collections.singletonList(resource));
    }

    public Deployment deployForTenant(String tenantId, BpmnModelInstance ... bpmnModelInstances) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenantId), Arrays.asList(bpmnModelInstances), Collections.emptyList());
    }

    public Deployment deployForTenant(String tenantId, String ... resources) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenantId), Collections.emptyList(), Arrays.asList(resources));
    }

    public Deployment deployForTenant(String tenant, BpmnModelInstance bpmnModelInstance, String resource) {
        return this.deploy(this.createDeploymentBuilder().tenantId(tenant), Collections.singletonList(bpmnModelInstance), Collections.singletonList(resource));
    }

    public ProcessDefinition deployAndGetDefinition(BpmnModelInstance bpmnModel) {
        return this.deployForTenantAndGetDefinition(null, bpmnModel);
    }

    public ProcessDefinition deployAndGetDefinition(String classpathResource) {
        return this.deployForTenantAndGetDefinition(null, classpathResource);
    }

    public ProcessDefinition deployForTenantAndGetDefinition(String tenant, String classpathResource) {
        DeploymentWithDefinitions deployment = this.deploy(this.createDeploymentBuilder().tenantId(tenant), Collections.emptyList(), Collections.singletonList(classpathResource));
        return (ProcessDefinition)this.processEngineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    public ProcessDefinition deployForTenantAndGetDefinition(String tenant, BpmnModelInstance bpmnModel) {
        DeploymentWithDefinitions deployment = this.deploy(this.createDeploymentBuilder().tenantId(tenant), Collections.singletonList(bpmnModel), Collections.emptyList());
        return (ProcessDefinition)this.processEngineRule.getRepositoryService().createProcessDefinitionQuery().deploymentId(deployment.getId()).singleResult();
    }

    protected DeploymentWithDefinitions deploy(DeploymentBuilder deploymentBuilder, List<BpmnModelInstance> bpmnModelInstances, List<String> resources) {
        int i = 0;
        for (BpmnModelInstance bpmnModelInstance : bpmnModelInstances) {
            deploymentBuilder.addModelInstance(i + "_process.bpmn20.xml", bpmnModelInstance);
            ++i;
        }
        for (String resource : resources) {
            deploymentBuilder.addClasspathResource(resource);
        }
        return this.deploy(deploymentBuilder);
    }

    protected DeploymentBuilder createDeploymentBuilder() {
        return this.processEngine.getRepositoryService().createDeployment();
    }

    public void waitForJobExecutorToProcessAllJobs() {
        this.waitForJobExecutorToProcessAllJobs(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobExecutorToProcessAllJobs(long maxMillisToWait) {
        ProcessEngineConfigurationImpl processEngineConfiguration = (ProcessEngineConfigurationImpl)this.processEngine.getProcessEngineConfiguration();
        JobExecutor jobExecutor = processEngineConfiguration.getJobExecutor();
        jobExecutor.start();
        long intervalMillis = 1000L;
        int jobExecutorWaitTime = jobExecutor.getWaitTimeInMillis() * 2;
        if (maxMillisToWait < (long)jobExecutorWaitTime) {
            maxMillisToWait = jobExecutorWaitTime;
        }
        try {
            Timer timer = new Timer();
            InterruptTask task = new InterruptTask(Thread.currentThread());
            timer.schedule((TimerTask)task, maxMillisToWait);
            boolean areJobsAvailable = true;
            try {
                while (areJobsAvailable && !task.isTimeLimitExceeded()) {
                    Thread.sleep(intervalMillis);
                    try {
                        areJobsAvailable = this.areJobsAvailable();
                    }
                    catch (Throwable throwable) {}
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                timer.cancel();
            }
            if (areJobsAvailable) {
                throw new AssertionError((Object)("time limit of " + maxMillisToWait + " was exceeded"));
            }
        }
        finally {
            jobExecutor.shutdown();
        }
    }

    protected boolean areJobsAvailable() {
        List list = this.processEngine.getManagementService().createJobQuery().list();
        for (Job job : list) {
            if (job.isSuspended() || job.getRetries() <= 0 || job.getDuedate() != null && !ClockUtil.getCurrentTime().after(job.getDuedate())) continue;
            return true;
        }
        return false;
    }

    public void executeAvailableJobs() {
        this.executeAvailableJobs(0, Integer.MAX_VALUE, true);
    }

    public void executeAvailableJobs(Boolean recursive) {
        this.executeAvailableJobs(0, Integer.MAX_VALUE, recursive);
    }

    public void executeAvailableJobs(int expectedExecutions) {
        this.executeAvailableJobs(0, expectedExecutions, true);
    }

    public void executeAvailableJobs(int expectedExecutions, Boolean recursive) {
        this.executeAvailableJobs(0, expectedExecutions, recursive);
    }

    private void executeAvailableJobs(int jobsExecuted, int expectedExecutions, Boolean recursive) {
        List jobs = this.processEngine.getManagementService().createJobQuery().withRetriesLeft().list();
        if (jobs.isEmpty()) {
            if (expectedExecutions != Integer.MAX_VALUE) {
                ((AbstractIntegerAssert)Assertions.assertThat((int)jobsExecuted).describedAs("executed less jobs than expected.", new Object[0])).isEqualTo(expectedExecutions);
            }
            return;
        }
        for (Job job : jobs) {
            try {
                this.processEngine.getManagementService().executeJob(job.getId());
                ++jobsExecuted;
            }
            catch (Exception exception) {}
        }
        ((AbstractIntegerAssert)Assertions.assertThat((int)jobsExecuted).describedAs("executed more jobs than expected.", new Object[0])).isLessThanOrEqualTo(expectedExecutions);
        if (recursive.booleanValue()) {
            this.executeAvailableJobs(jobsExecuted, expectedExecutions, recursive);
        }
    }

    public void completeTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        Task task = (Task)taskService.createTaskQuery().taskDefinitionKey(taskKey).singleResult();
        Assert.assertNotNull((String)("Expected a task with key '" + taskKey + "' to exist"), (Object)task);
        taskService.complete(task.getId());
    }

    public void completeAnyTask(String taskKey) {
        TaskService taskService = this.processEngine.getTaskService();
        List tasks = taskService.createTaskQuery().taskDefinitionKey(taskKey).list();
        Assert.assertTrue((!tasks.isEmpty() ? 1 : 0) != 0);
        taskService.complete(((Task)tasks.get(0)).getId());
    }

    public void setAnyVariable(String executionId) {
        this.setVariable(executionId, "any", "any");
    }

    public void setVariable(String executionId, String varName, Object varValue) {
        this.processEngine.getRuntimeService().setVariable(executionId, varName, varValue);
    }

    public void correlateMessage(String messageName) {
        this.processEngine.getRuntimeService().createMessageCorrelation(messageName).correlate();
    }

    public void sendSignal(String signalName) {
        this.processEngine.getRuntimeService().signalEventReceived(signalName);
    }

    public boolean isHistoryLevelNone() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_NONE.equals(historyLevel);
    }

    public boolean isHistoryLevelActivity() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_ACTIVITY.equals(historyLevel);
    }

    public boolean isHistoryLevelAudit() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_AUDIT.equals(historyLevel);
    }

    public boolean isHistoryLevelFull() {
        HistoryLevel historyLevel = this.processEngineRule.getProcessEngineConfiguration().getHistoryLevel();
        return HistoryLevel.HISTORY_LEVEL_FULL.equals(historyLevel);
    }

    public void assertTextPresent(String expected, String actual) {
        if (actual == null || actual.indexOf(expected) == -1) {
            throw new AssertionFailedError("expected presence of [" + expected + "], but was [" + actual + "]");
        }
    }

    public void assertTextPresentIgnoreCase(String expected, String actual) {
        this.assertTextPresent(expected.toLowerCase(), actual.toLowerCase());
    }

    public Object defaultManualActivation() {
        FixedValue expression = new FixedValue((Object)true);
        CaseControlRuleImpl caseControlRule = new CaseControlRuleImpl((Expression)expression);
        return caseControlRule;
    }

    public void deleteHistoryCleanupJobs() {
        HistoryService historyService = this.processEngine.getHistoryService();
        List jobs = historyService.findHistoryCleanupJobs();
        for (Job job : jobs) {
            String jobId = job.getId();
            this.processEngineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute(commandContext -> {
                JobManager jobManager = commandContext.getJobManager();
                JobEntity jobEntity = jobManager.findJobById(jobId);
                jobEntity.delete();
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                return null;
            });
        }
    }

    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey) {
        return this.createCaseInstanceByKey(caseDefinitionKey, null, null);
    }

    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, String businessKey) {
        return this.createCaseInstanceByKey(caseDefinitionKey, businessKey, null);
    }

    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, VariableMap variables) {
        return this.createCaseInstanceByKey(caseDefinitionKey, null, variables);
    }

    public CaseInstance createCaseInstanceByKey(String caseDefinitionKey, String businessKey, VariableMap variables) {
        return this.processEngine.getCaseService().withCaseDefinitionByKey(caseDefinitionKey).businessKey(businessKey).setVariables((Map)variables).create();
    }

    public String getDatabaseType() {
        return this.processEngineRule.getProcessEngineConfiguration().getDbSqlSessionFactory().getDatabaseType();
    }

    public boolean isOptimisticLockingExceptionSuppressible() {
        return !"cockroachdb".equals(this.getDatabaseType());
    }

    public void deleteAllAuthorizations() {
        AuthorizationService authorizationService = this.processEngine.getAuthorizationService();
        authorizationService.createAuthorizationQuery().list().stream().map(Authorization::getId).forEach(arg_0 -> ((AuthorizationService)authorizationService).deleteAuthorization(arg_0));
    }

    public void deleteAllStandaloneTasks() {
        TaskService taskService = this.processEngine.getTaskService();
        taskService.createTaskQuery().list().stream().filter(t -> t.getProcessInstanceId() == null && t.getCaseInstanceId() == null).forEach(t -> taskService.deleteTask(t.getId(), true));
    }

    public void createGrantAuthorization(String userId, Resource resource, String resourceId, Permission ... permissions) {
        AuthorizationService authorizationService = this.processEngine.getAuthorizationService();
        Authorization processInstanceAuthorization = authorizationService.createNewAuthorization(1);
        processInstanceAuthorization.setResource(resource);
        processInstanceAuthorization.setResourceId(resourceId);
        processInstanceAuthorization.setPermissions(permissions);
        processInstanceAuthorization.setUserId(userId);
        authorizationService.saveAuthorization(processInstanceAuthorization);
    }

    protected static class InterruptTask
    extends TimerTask {
        protected boolean timeLimitExceeded = false;
        protected Thread thread;

        public InterruptTask(Thread thread) {
            this.thread = thread;
        }

        public boolean isTimeLimitExceeded() {
            return this.timeLimitExceeded;
        }

        @Override
        public void run() {
            this.timeLimitExceeded = true;
            this.thread.interrupt();
        }
    }
}

