/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import org.camunda.bpm.engine.impl.util.SingleConsumerCondition;
import org.junit.Assert;
import org.junit.Test;

public class SingleConsumerConditionTest {
    @Test(timeout=10000L)
    public void shouldNotBlockIfSignalAvailable() {
        SingleConsumerCondition condition = new SingleConsumerCondition(Thread.currentThread());
        condition.signal();
        condition.await(100000L);
    }

    @Test(timeout=10000L)
    public void shouldNotBlockIfSignalAvailableDifferentThread() throws InterruptedException {
        final SingleConsumerCondition condition = new SingleConsumerCondition(Thread.currentThread());
        Thread consumer = new Thread(){

            @Override
            public void run() {
                condition.signal();
            }
        };
        consumer.start();
        consumer.join();
        condition.await(100000L);
    }

    @Test
    public void cannotAwaitFromDifferentThread() {
        SingleConsumerCondition condition = new SingleConsumerCondition(new Thread());
        try {
            condition.await(0L);
            Assert.fail((String)"expected exception");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void cannotCreateWithNull() {
        try {
            new SingleConsumerCondition(null);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

