/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.batch;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.batch.BatchElementConfiguration;
import org.camunda.bpm.engine.impl.batch.DeploymentMapping;
import org.camunda.bpm.engine.impl.batch.DeploymentMappings;
import org.camunda.bpm.engine.impl.util.ImmutablePair;
import org.junit.Test;

public class BatchElementConfigurationTest {
    @Test
    public void shouldProduceListOfIdsSortedByKey() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"ABC", (Object)"bar"), new ImmutablePair((Object)"AAB", (Object)"baz")));
        List ids = configuration.getIds();
        Assertions.assertThat((List)ids).containsExactlyInAnyOrder((Object[])new String[]{"foo", "bar", "baz"});
        Assertions.assertThat((String)((String)ids.get(0))).isEqualTo((Object)"baz");
    }

    @Test
    public void shouldProduceListOfMappingsSortedByKey() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"ABC", (Object)"bar"), new ImmutablePair((Object)"AAB", (Object)"baz")));
        DeploymentMappings mappings = configuration.getMappings();
        Assertions.assertThat((List)mappings).containsExactly((Object[])new DeploymentMapping[]{new DeploymentMapping("AAB", 1), new DeploymentMapping("ABC", 2)});
    }

    @Test
    public void shouldIncludeNullMappings() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"AAB", (Object)"baz"), new ImmutablePair(null, (Object)"null")));
        List ids = configuration.getIds();
        DeploymentMappings mappings = configuration.getMappings();
        Assertions.assertThat((List)ids).containsExactly((Object[])new String[]{"baz", "foo", "null"});
        Assertions.assertThat((List)mappings).containsExactly((Object[])new DeploymentMapping[]{new DeploymentMapping("AAB", 1), new DeploymentMapping("ABC", 1), new DeploymentMapping(null, 1)});
    }

    @Test
    public void shouldRecalculateMappingsWhenNewElementsAdded() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"AAB", (Object)"baz")));
        configuration.getIds();
        configuration.getMappings();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"AAB", (Object)"bar")));
        List ids = configuration.getIds();
        DeploymentMappings mappings = configuration.getMappings();
        Assertions.assertThat((List)ids).containsExactlyInAnyOrder((Object[])new String[]{"baz", "foo", "bar"});
        Assertions.assertThat((String)((String)ids.get(ids.size() - 1))).isEqualTo((Object)"foo");
        Assertions.assertThat((List)mappings).containsExactly((Object[])new DeploymentMapping[]{new DeploymentMapping("AAB", 2), new DeploymentMapping("ABC", 1)});
    }

    @Test
    public void shouldIncludeNullMappingForUnmappedIds() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"AAB", (Object)"baz")), Arrays.asList("null"));
        List ids = configuration.getIds();
        DeploymentMappings mappings = configuration.getMappings();
        Assertions.assertThat((List)ids).containsExactly((Object[])new String[]{"baz", "foo", "null"});
        Assertions.assertThat((List)mappings).containsExactly((Object[])new DeploymentMapping[]{new DeploymentMapping("AAB", 1), new DeploymentMapping("ABC", 1), new DeploymentMapping(null, 1)});
    }

    @Test
    public void shouldAddToNullMappingsForUnmappedIds() {
        BatchElementConfiguration configuration = new BatchElementConfiguration();
        configuration.addDeploymentMappings(Arrays.asList(new ImmutablePair((Object)"ABC", (Object)"foo"), new ImmutablePair((Object)"AAB", (Object)"baz"), new ImmutablePair(null, (Object)"null")), Arrays.asList("bar"));
        List ids = configuration.getIds();
        DeploymentMappings mappings = configuration.getMappings();
        Assertions.assertThat((List)ids).startsWith((Object[])new String[]{"baz", "foo"}).containsExactlyInAnyOrder((Object[])new String[]{"baz", "foo", "bar", "null"});
        Assertions.assertThat((List)mappings).containsExactly((Object[])new DeploymentMapping[]{new DeploymentMapping("AAB", 1), new DeploymentMapping("ABC", 1), new DeploymentMapping(null, 2)});
    }
}

