/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExternalTaskQueryAuthorizationTest
extends AuthorizationTest {
    protected String deploymentId;
    protected String instance1Id;
    protected String instance2Id;

    @Override
    @Before
    public void setUp() throws Exception {
        this.deploymentId = this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml").getId();
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("twoExternalTaskProcess").getId();
        super.setUp();
    }

    @Test
    public void testQueryWithoutAuthorization() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 0);
    }

    @Test
    public void testQueryWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Assert.assertEquals((Object)this.instance1Id, (Object)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
        Assert.assertEquals((Object)this.instance1Id, (Object)((ExternalTask)query.list().get(0)).getProcessInstanceId());
    }

    @Test
    public void testQueryWithReadInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void testQueryWithReadInstanceWithMultiple() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 2);
    }

    @Test
    public void shouldNotFindTaskWithRevokedReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        this.verifyQueryResults((Query<?, ?>)query, 1);
    }
}

