/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.batch;

import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Java6Assertions;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.history.removaltime.batch.helper.BatchSetRemovalTimeRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class BatchSetRemovalTimeUserOperationLogTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule engineTestRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchSetRemovalTimeRule testRule = new BatchSetRemovalTimeRule(this.engineRule, this.engineTestRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.engineTestRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected DecisionService decisionService;
    protected HistoryService historyService;
    protected ManagementService managementService;
    protected IdentityService identityService;

    @Before
    public void assignServices() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.decisionService = this.engineRule.getDecisionService();
        this.historyService = this.engineRule.getHistoryService();
        this.managementService = this.engineRule.getManagementService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @After
    public void clearAuth() {
        this.identityService.clearAuthentication();
    }

    @After
    public void clearDatabase() {
        List batches = this.managementService.createBatchQuery().type("historic-instance-deletion").list();
        if (!batches.isEmpty()) {
            for (Batch batch : batches) {
                this.managementService.deleteBatch(batch.getId(), true);
            }
        }
        String batchId = ((Batch)this.managementService.createBatchQuery().singleResult()).getId();
        this.managementService.deleteBatch(batchId, true);
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().list();
        this.assertProperties(userOperationLogEntries, "mode", "removalTime", "hierarchical", "nrOfInstances", "async", "updateInChunks", "chunkSize");
        this.assertOperationType(userOperationLogEntries, "SetRemovalTime");
        this.assertCategory(userOperationLogEntries, "Operator");
        this.assertEntityType(userOperationLogEntries, "ProcessInstance");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_ModeCalculatedRemovalTime() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().calculatedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"CALCULATED_REMOVAL_TIME");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_ModeAbsoluteRemovalTime() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(new Date()).byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"ABSOLUTE_REMOVAL_TIME");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_RemovalTime() {
        Date removalTime = new Date();
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().absoluteRemovalTime(removalTime).byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((Date)this.fromMillis(userOperationLogEntry.getNewValue())).isEqualToIgnoringMillis(removalTime);
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_RemovalTimeNull() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isNull();
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_NrOfInstances() {
        this.testRule.process().serviceTask().deploy().start();
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("nrOfInstances").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"2");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_AsyncTrue() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("async").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_HierarchicalTrue() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).hierarchical().executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("hierarchical").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_HierarchicalFalse() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("hierarchical").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"false");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_UpdateInChunksTrue() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).updateInChunks().executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("updateInChunks").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_UpdateInChunksFalse() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("updateInChunks").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"false");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_ChunkSize() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).updateInChunks().chunkSize(12).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("chunkSize").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"12");
    }

    @Test
    public void shouldWriteUserOperationLogForProcessInstances_ChunkSizeNull() {
        this.testRule.process().serviceTask().deploy().start();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.historyService.setRemovalTimeToHistoricProcessInstances().clearedRemovalTime().byQuery(historicProcessInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("chunkSize").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().list();
        this.assertProperties(userOperationLogEntries, "mode", "removalTime", "hierarchical", "nrOfInstances", "async");
        this.assertOperationType(userOperationLogEntries, "SetRemovalTime");
        this.assertCategory(userOperationLogEntries, "Operator");
        this.assertEntityType(userOperationLogEntries, "DecisionInstance");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_ModeCalculatedRemovalTime() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().calculatedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"CALCULATED_REMOVAL_TIME");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_ModeAbsoluteRemovalTime() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(new Date()).byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"ABSOLUTE_REMOVAL_TIME");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_RemovalTime() {
        Date removalTime = new Date();
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().absoluteRemovalTime(removalTime).byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((Date)this.fromMillis(userOperationLogEntry.getNewValue())).isEqualToIgnoringMillis(removalTime);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_RemovalTimeNull() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_NrOfInstances() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("nrOfInstances").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"3");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_AsyncTrue() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("async").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_HierarchicalTrue() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).hierarchical().executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("hierarchical").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldWriteUserOperationLogForDecisionInstances_HierarchicalFalse() {
        this.evaluate();
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("hierarchical").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"false");
    }

    @Test
    public void shouldWriteUserOperationLogForBatches() {
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(historicBatchQuery).executeAsync();
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().list();
        this.assertProperties(userOperationLogEntries, "mode", "removalTime", "nrOfInstances", "async");
        this.assertOperationType(userOperationLogEntries, "SetRemovalTime");
        this.assertEntityType(userOperationLogEntries, "Batch");
        this.assertCategory(userOperationLogEntries, "Operator");
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_ModeCalculatedRemovalTime() {
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().calculatedRemovalTime().byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"CALCULATED_REMOVAL_TIME");
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_ModeAbsoluteRemovalTime() {
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(new Date()).byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("mode").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"ABSOLUTE_REMOVAL_TIME");
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_RemovalTime() {
        Date removalTime = new Date();
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().absoluteRemovalTime(removalTime).byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((Date)this.fromMillis(userOperationLogEntry.getNewValue())).isEqualToIgnoringMillis(removalTime);
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_RemovalTimeNull() {
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().clearedRemovalTime().byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("removalTime").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isNull();
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_NrOfInstances() {
        this.createBatch(2);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().clearedRemovalTime().byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("nrOfInstances").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"2");
    }

    @Test
    public void shouldWriteUserOperationLogForBatches_AsyncTrue() {
        this.createBatch(1);
        this.identityService.setAuthenticatedUserId("aUserId");
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.historyService.setRemovalTimeToHistoricBatches().clearedRemovalTime().byQuery(historicBatchQuery).executeAsync();
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("async").singleResult();
        Java6Assertions.assertThat((String)userOperationLogEntry.getOrgValue()).isNull();
        Java6Assertions.assertThat((String)userOperationLogEntry.getNewValue()).isEqualTo((Object)"true");
    }

    protected void assertProperties(List<UserOperationLogEntry> userOperationLogEntries, String ... expectedProperties) {
        Java6Assertions.assertThat((int)userOperationLogEntries.size()).isEqualTo(expectedProperties.length);
        Java6Assertions.assertThat(userOperationLogEntries).extracting("property", String.class).containsExactlyInAnyOrder((Object[])expectedProperties);
    }

    protected void assertEntityType(List<UserOperationLogEntry> userOperationLogEntries, String entityType) {
        for (UserOperationLogEntry userOperationLogEntry : userOperationLogEntries) {
            Java6Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)entityType);
        }
    }

    protected void assertOperationType(List<UserOperationLogEntry> userOperationLogEntries, String operationType) {
        for (UserOperationLogEntry userOperationLogEntry : userOperationLogEntries) {
            Java6Assertions.assertThat((String)userOperationLogEntry.getOperationType()).isEqualTo((Object)operationType);
        }
    }

    protected void assertCategory(List<UserOperationLogEntry> userOperationLogEntries, String category) {
        for (UserOperationLogEntry userOperationLogEntry : userOperationLogEntries) {
            Java6Assertions.assertThat((String)userOperationLogEntry.getCategory()).isEqualTo((Object)category);
        }
    }

    protected Date fromMillis(String milliseconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(Long.valueOf(milliseconds));
        return calendar.getTime();
    }

    protected void evaluate() {
        this.decisionService.evaluateDecisionByKey("dish-decision").variables((Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend")).evaluate();
    }

    protected void createBatch(int times) {
        for (int i = 0; i < times; ++i) {
            String processInstanceId = this.testRule.process().serviceTask().deploy().start();
            this.historyService.deleteHistoricProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        }
    }
}

