/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.history.removaltime.cleanup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.time.DateUtils;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.DecisionService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FormService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.AuthorizationQuery;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.batch.history.HistoricBatchQuery;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.history.CleanableHistoricBatchReportResult;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.CleanableHistoricProcessInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.HistoricDetailQuery;
import org.camunda.bpm.engine.history.HistoricExternalTaskLogQuery;
import org.camunda.bpm.engine.history.HistoricIdentityLinkLogQuery;
import org.camunda.bpm.engine.history.HistoricIncidentQuery;
import org.camunda.bpm.engine.history.HistoricJobLog;
import org.camunda.bpm.engine.history.HistoricJobLogQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.history.HistoricTaskInstance;
import org.camunda.bpm.engine.history.HistoricTaskInstanceQuery;
import org.camunda.bpm.engine.history.HistoricVariableInstanceQuery;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.history.DefaultHistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.history.HistoryRemovalTimeProvider;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.ByteArrayEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricJobLogEventEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.resources.GetByteArrayCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ScriptTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class HistoryCleanupRemovalTimeTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected RuntimeService runtimeService;
    protected FormService formService;
    protected HistoryService historyService;
    protected TaskService taskService;
    protected ManagementService managementService;
    protected RepositoryService repositoryService;
    protected IdentityService identityService;
    protected ExternalTaskService externalTaskService;
    protected DecisionService decisionService;
    protected AuthorizationService authorizationService;
    protected static ProcessEngineConfigurationImpl engineConfiguration;
    protected Set<String> jobIds;
    protected final String PROCESS_KEY = "process";
    protected final BpmnModelInstance PROCESS = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().userTask("userTask").name("userTask")).endEvent().done();
    protected final BpmnModelInstance CALLED_PROCESS_INCIDENT = ((ScriptTaskBuilder)((ScriptTaskBuilder)((ScriptTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(null)).startEvent().scriptTask().camundaAsyncBefore()).scriptFormat("groovy")).scriptText("if(execution.getIncidents().size() == 0) throw new RuntimeException(\"I'm supposed to fail!\")")).userTask("userTask").endEvent().done();
    protected final String CALLING_PROCESS_KEY = "callingProcess";
    protected final BpmnModelInstance CALLING_PROCESS = ((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("process")).endEvent().done();
    protected final BpmnModelInstance CALLING_PROCESS_WO_TTL = ((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(null)).startEvent().callActivity().calledElement("process")).endEvent().done();
    protected final String CALLING_PROCESS_CALLS_DMN_KEY = "callingProcessCallsDmn";
    protected final BpmnModelInstance CALLING_PROCESS_CALLS_DMN = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcessCallsDmn").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().businessRuleTask().camundaAsyncAfter()).camundaDecisionRef("dish-decision")).endEvent().done();
    protected final Date END_DATE = new Date(1363608000000L);

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
        this.formService = this.engineRule.getFormService();
        this.historyService = this.engineRule.getHistoryService();
        this.taskService = this.engineRule.getTaskService();
        this.managementService = this.engineRule.getManagementService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.identityService = this.engineRule.getIdentityService();
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.decisionService = this.engineRule.getDecisionService();
        this.authorizationService = this.engineRule.getAuthorizationService();
        engineConfiguration = this.engineRule.getProcessEngineConfiguration();
        engineConfiguration.setHistoryRemovalTimeStrategy("end").setHistoryRemovalTimeProvider((HistoryRemovalTimeProvider)new DefaultHistoryRemovalTimeProvider()).initHistoryRemovalTime();
        engineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
        engineConfiguration.setHistoryCleanupBatchSize(500);
        engineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
        engineConfiguration.setBatchOperationHistoryTimeToLive(null);
        engineConfiguration.setBatchOperationsForHistoryCleanup(null);
        engineConfiguration.setHistoryTimeToLive(null);
        engineConfiguration.setTaskMetricsEnabled(false);
        engineConfiguration.setTaskMetricsTimeToLive(null);
        engineConfiguration.initHistoryCleanup();
        this.jobIds = new HashSet<String>();
    }

    @After
    public void tearDown() {
        this.clearMeterLog();
        for (String jobId : this.jobIds) {
            this.clearJobLog(jobId);
            this.clearJob(jobId);
        }
    }

    @AfterClass
    public static void tearDownAfterAll() {
        if (engineConfiguration != null) {
            engineConfiguration.setHistoryRemovalTimeProvider(null).setHistoryRemovalTimeStrategy(null).initHistoryRemovalTime();
            engineConfiguration.setHistoryCleanupStrategy("removalTimeBased");
            engineConfiguration.setHistoryCleanupBatchSize(500);
            engineConfiguration.setHistoryCleanupBatchWindowStartTime(null);
            engineConfiguration.setHistoryCleanupDegreeOfParallelism(1);
            engineConfiguration.setBatchOperationHistoryTimeToLive(null);
            engineConfiguration.setBatchOperationsForHistoryCleanup(null);
            engineConfiguration.setHistoryCleanupJobLogTimeToLive(null);
            engineConfiguration.setTaskMetricsTimeToLive(null);
            engineConfiguration.initHistoryCleanup();
            engineConfiguration.setAuthorizationEnabled(false);
            engineConfiguration.setEnableHistoricInstancePermissions(false);
            engineConfiguration.setTaskMetricsEnabled(false);
        }
        ClockUtil.reset();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupStandaloneDecisionInstance() {
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey("dish-decision").singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(5));
        this.decisionService.evaluateDecisionTableByKey("dish-decision", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldReportMetricsForDecisionInstanceCleanup() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        long removedDecisionInstancesSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-decision-instances").sum();
        MatcherAssert.assertThat((Object)removedDecisionInstancesSum, (Matcher)Is.is((Object)3L));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionInputInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeInputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldCleanupDecisionOutputInstance() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)3));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().includeOutputs().list();
        MatcherAssert.assertThat((Object)historicDecisionInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupProcessInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)1));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldNotCleanupProcessInstanceWithoutTTL() {
        this.testRule.deploy(this.CALLING_PROCESS_WO_TTL);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)1));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCleanupProcessInstanceWithoutTTLWithConfigDefault() {
        engineConfiguration.setHistoryTimeToLive("5");
        this.testRule.deploy(this.CALLING_PROCESS_WO_TTL);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)1));
        Date removalTime = DateUtils.addDays((Date)this.END_DATE, (int)5);
        ClockUtil.setCurrentTime((Date)removalTime);
        this.runHistoryCleanup();
        historicProcessInstances = this.historyService.createHistoricProcessInstanceQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)historicProcessInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReportMetricsForProcessInstanceCleanup() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        long removedProcessInstancesSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-process-instances").sum();
        MatcherAssert.assertThat((Object)removedProcessInstancesSum, (Matcher)Is.is((Object)2L));
    }

    @Test
    public void shouldCleanupActivityInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicActivityInstances.size(), (Matcher)Is.is((Object)6));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicActivityInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupTaskInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicTaskInstances.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicTaskInstances = this.historyService.createHistoricTaskInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicTaskInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupTaskInstanceAuthorization() {
        engineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        engineConfiguration.setAuthorizationEnabled(true);
        this.taskService.setAssignee(taskId, "myUserId");
        engineConfiguration.setAuthorizationEnabled(false);
        this.taskService.complete(taskId);
        List authorizations = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).list();
        MatcherAssert.assertThat((Object)authorizations.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        authorizations = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK).list();
        MatcherAssert.assertThat((Object)authorizations.size(), (Matcher)Is.is((Object)0));
        this.clearAuthorization();
    }

    @Test
    public void shouldCleanupVariableInstance() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        List historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicVariableInstances.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicVariableInstances = this.historyService.createHistoricVariableInstanceQuery().list();
        MatcherAssert.assertThat((Object)historicVariableInstances.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupDetail() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess", (Map)Variables.createVariables().putValue("aVariableName", (Object)Variables.stringValue((String)"aVariableValue")));
        this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
        List historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)2));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((HistoricTaskInstance)this.historyService.createHistoricTaskInstanceQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicDetails = this.historyService.createHistoricDetailQuery().variableUpdates().list();
        MatcherAssert.assertThat((Object)historicDetails.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupIncident() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.setJobRetries(jobId, 0);
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        List historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)2));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicIncidents = this.historyService.createHistoricIncidentQuery().list();
        MatcherAssert.assertThat((Object)historicIncidents.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupExternalTaskLog() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 3000L).execute().get(0);
        List externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)externalTaskLogs.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        externalTaskLogs = this.historyService.createHistoricExternalTaskLogQuery().list();
        MatcherAssert.assertThat((Object)externalTaskLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupJobLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        List jobLogs = this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)jobLogs.size(), (Matcher)Is.is((Object)2));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        jobLogs = this.historyService.createHistoricJobLogQuery().processDefinitionKey("process").list();
        MatcherAssert.assertThat((Object)jobLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupHistoryCleanupJobsFromHistoricJobLog() {
        engineConfiguration.setHistoryCleanupJobLogTimeToLive("P5D");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runHistoryCleanup();
        List initialHistoryCleanupJobLog = this.historyService.createHistoricJobLogQuery().list().stream().map(HistoricJobLog::getId).collect(Collectors.toList());
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        List finalJobLog = this.historyService.createHistoricJobLogQuery().list();
        Assertions.assertThat((List)finalJobLog).hasSize(1);
        Assertions.assertThat((List)finalJobLog).extracting("id").doesNotContainAnyElementsOf(initialHistoryCleanupJobLog);
    }

    @Test
    public void shouldNotCleanupHistoryCleanupJobsFromHistoricJobLog() {
        engineConfiguration.setHistoryCleanupJobLogTimeToLive(null);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.runHistoryCleanup();
        List initialHistoryCleanupJobLog = this.historyService.createHistoricJobLogQuery().list().stream().map(HistoricJobLog::getId).collect(Collectors.toList());
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        List finalJobLog = this.historyService.createHistoricJobLogQuery().list();
        Assertions.assertThat((List)finalJobLog).hasSize(3);
        Assertions.assertThat((List)finalJobLog).extracting("id").containsAll(initialHistoryCleanupJobLog);
    }

    @Test
    public void shouldCleanupUserOperationLog() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.identityService.setAuthenticatedUserId("aUserId");
        this.managementService.setJobRetries(jobId, 65);
        this.identityService.clearAuthentication();
        List userOperationLogs = this.historyService.createUserOperationLogQuery().list();
        MatcherAssert.assertThat((Object)userOperationLogs.size(), (Matcher)Is.is((Object)1));
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        userOperationLogs = this.historyService.createUserOperationLogQuery().list();
        MatcherAssert.assertThat((Object)userOperationLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupIdentityLink() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "aUserId");
        List historicIdentityLinkLogs = this.historyService.createHistoricIdentityLinkLogQuery().list();
        MatcherAssert.assertThat((Object)historicIdentityLinkLogs.size(), (Matcher)Is.is((Object)1));
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicIdentityLinkLogs = this.historyService.createHistoricIdentityLinkLogQuery().list();
        MatcherAssert.assertThat((Object)historicIdentityLinkLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupComment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createComment(null, processInstanceId, "aMessage");
        List comments = this.taskService.getProcessInstanceComments(processInstanceId);
        MatcherAssert.assertThat((Object)comments.size(), (Matcher)Is.is((Object)1));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        comments = this.taskService.getProcessInstanceComments(processInstanceId);
        MatcherAssert.assertThat((Object)comments.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupAttachment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
        this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com").getId();
        List attachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        MatcherAssert.assertThat((Object)attachments.size(), (Matcher)Is.is((Object)1));
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        attachments = this.taskService.getProcessInstanceAttachments(processInstanceId);
        MatcherAssert.assertThat((Object)attachments.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCleanupByteArray() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        this.runtimeService.startProcessInstanceByKey("callingProcess");
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        try {
            this.managementService.executeJob(jobId);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HistoricJobLogEventEntity jobLog = (HistoricJobLogEventEntity)this.historyService.createHistoricJobLogQuery().failureLog().singleResult();
        ByteArrayEntity byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.notNullValue());
        this.managementService.setJobRetries(jobId, 0);
        this.managementService.executeJob(jobId);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        byteArray = this.findByteArrayById(jobLog.getExceptionByteArrayId());
        MatcherAssert.assertThat((Object)byteArray, (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldCleanupBatch() {
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        String batchId = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason").getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.jobIds.add(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
            this.jobIds.add(job.getId());
        }
        List historicBatches = this.historyService.createHistoricBatchQuery().list();
        MatcherAssert.assertThat((Object)historicBatches.size(), (Matcher)Is.is((Object)1));
        List historicJobLogs = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).list();
        MatcherAssert.assertThat((Object)historicJobLogs.size(), (Matcher)Is.is((Object)6));
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        this.runHistoryCleanup();
        historicBatches = this.historyService.createHistoricBatchQuery().list();
        historicJobLogs = this.historyService.createHistoricJobLogQuery().jobDefinitionConfiguration(batchId).list();
        MatcherAssert.assertThat((Object)historicBatches.size(), (Matcher)Is.is((Object)0));
        MatcherAssert.assertThat((Object)historicJobLogs.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReportMetricsForBatchCleanup() {
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
        this.managementService.executeJob(jobId);
        this.jobIds.add(jobId);
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            this.managementService.executeJob(job.getId());
            this.jobIds.add(job.getId());
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        List historicBatches = this.historyService.createHistoricBatchQuery().list();
        MatcherAssert.assertThat((Object)historicBatches.size(), (Matcher)Is.is((Object)1));
        this.runHistoryCleanup();
        long removedBatchesSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-batch-operations").sum();
        MatcherAssert.assertThat((Object)removedBatchesSum, (Matcher)Is.is((Object)1L));
    }

    @Test
    public void shouldCleanupTaskMetrics() {
        engineConfiguration.setTaskMetricsEnabled(true);
        engineConfiguration.setTaskMetricsTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.setAssignee(taskId, "kermit");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
        this.runHistoryCleanup();
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(0L);
    }

    @Test
    public void shouldReportMetricsForTaskMetricsCleanup() {
        engineConfiguration.setTaskMetricsEnabled(true);
        engineConfiguration.setTaskMetricsTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        this.taskService.setAssignee(taskId, "kermit");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        Assertions.assertThat((long)this.managementService.getUniqueTaskWorkerCount(null, null)).isEqualTo(1L);
        this.runHistoryCleanup();
        long removedMetricsSum = this.managementService.createMetricsQuery().name("history-cleanup-removed-task-metrics").sum();
        MatcherAssert.assertThat((Object)removedMetricsSum, (Matcher)Is.is((Object)1L));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldDistributeWorkForDecisions() {
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.executeJob(jobId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricDecisionInstanceQuery decisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricDecisionInstanceQuery)decisionInstanceQuery).count(), 45L);
    }

    @Test
    public void shouldDistributeWorkForProcessInstances() {
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("process");
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricProcessInstanceQuery processInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricProcessInstanceQuery)processInstanceQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForActivityInstances() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricActivityInstanceQuery activityInstanceQuery = this.historyService.createHistoricActivityInstanceQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricActivityInstanceQuery)activityInstanceQuery).count(), 90L);
    }

    @Test
    public void shouldDistributeWorkForTaskInstances() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricTaskInstanceQuery taskInstanceQuery = this.historyService.createHistoricTaskInstanceQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricTaskInstanceQuery)taskInstanceQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForAuthorizations() {
        engineConfiguration.setEnableHistoricInstancePermissions(true);
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            engineConfiguration.setAuthorizationEnabled(true);
            this.taskService.setAssignee(taskId, "myUserId");
            engineConfiguration.setAuthorizationEnabled(false);
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        AuthorizationQuery authorizationQuery = this.authorizationService.createAuthorizationQuery().resourceType((Resource)Resources.HISTORIC_TASK);
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((AuthorizationQuery)authorizationQuery).count(), 15L);
        this.clearAuthorization();
    }

    @Test
    public void shouldDistributeWorkForVariableInstances() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
            this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricVariableInstanceQuery variableInstanceQuery = this.historyService.createHistoricVariableInstanceQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricVariableInstanceQuery)variableInstanceQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForDetails() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingProcess");
            this.runtimeService.setVariable(processInstance.getId(), "aVariableName", (Object)Variables.stringValue((String)"anotherVariableValue"));
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricDetailQuery historicDetailQuery = this.historyService.createHistoricDetailQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricDetailQuery)historicDetailQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForIncidents() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.setJobRetries(jobId, 0);
            try {
                this.managementService.executeJob(jobId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricIncidentQuery historicIncidentQuery = this.historyService.createHistoricIncidentQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricIncidentQuery)historicIncidentQuery).count(), 30L);
    }

    @Test
    public void shouldDistributeWorkForExternalTaskLogs() {
        this.testRule.deploy(((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"calledProcess").startEvent().serviceTask().camundaExternalTask("anExternalTaskTopic")).endEvent().done());
        this.testRule.deploy(((CallActivityBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"callingProcess").camundaHistoryTimeToLive(Integer.valueOf(5))).startEvent().callActivity().calledElement("calledProcess")).endEvent().done());
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            LockedExternalTask externalTask = (LockedExternalTask)this.externalTaskService.fetchAndLock(1, "aWorkerId").topic("anExternalTaskTopic", 3000L).execute().get(0);
            this.externalTaskService.complete(externalTask.getId(), "aWorkerId");
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricExternalTaskLogQuery externalTaskLogQuery = this.historyService.createHistoricExternalTaskLogQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricExternalTaskLogQuery)externalTaskLogQuery).count(), 30L);
    }

    @Test
    public void shouldDistributeWorkForJobLogs() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.executeJob(jobId);
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricJobLogQuery jobLogQuery = this.historyService.createHistoricJobLogQuery().processDefinitionKey("process");
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricJobLogQuery)jobLogQuery).count(), 30L);
    }

    @Test
    public void shouldDistributeWorkForUserOperationLogs() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(((UserTaskBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().camundaAsyncBefore()).userTask("userTask").name("userTask")).endEvent().done());
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.identityService.setAuthenticatedUserId("aUserId");
            this.managementService.setJobRetries(jobId, 65);
            this.identityService.clearAuthentication();
            this.managementService.executeJob(jobId);
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        UserOperationLogQuery userOperationLogQuery = this.historyService.createUserOperationLogQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((UserOperationLogQuery)userOperationLogQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForIdentityLinkLogs() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.addCandidateUser(taskId, "aUserId");
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricIdentityLinkLogQuery identityLinkLogQuery = this.historyService.createHistoricIdentityLinkLogQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricIdentityLinkLogQuery)identityLinkLogQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForComment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
            processInstanceIds.add(processInstanceId);
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.taskService.createComment(null, processInstanceId, "aMessage");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> this.getCommentCountBy(processInstanceIds), 15L);
    }

    @Test
    public void shouldDistributeWorkForAttachment() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.PROCESS);
        ArrayList<String> processInstanceIds = new ArrayList<String>();
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String processInstanceId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().activityIdIn(new String[]{"userTask"}).singleResult()).getId();
            processInstanceIds.add(processInstanceId);
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.taskService.createAttachment(null, null, processInstanceId, null, null, "http://camunda.com").getId();
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> this.getAttachmentCountBy(processInstanceIds), 15L);
    }

    @Test
    public void shouldDistributeWorkForByteArray() {
        this.testRule.deploy(this.CALLING_PROCESS);
        this.testRule.deploy(this.CALLED_PROCESS_INCIDENT);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            this.runtimeService.startProcessInstanceByKey("callingProcess");
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            try {
                this.managementService.executeJob(jobId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.managementService.setJobRetries(jobId, 0);
            this.managementService.executeJob(jobId);
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        this.assumeWhenThenParallelizedCleanup(jobs, this::byteArrayCount, 15L);
    }

    @Test
    public void shouldDistributeWorkForBatches() {
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.testRule.deploy(this.CALLING_PROCESS);
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
            String jobId = ((Job)this.managementService.createJobQuery().singleResult()).getId();
            this.managementService.executeJob(jobId);
            this.jobIds.add(jobId);
            List jobs = this.managementService.createJobQuery().list();
            for (Job job : jobs) {
                this.managementService.executeJob(job.getId());
                this.jobIds.add(job.getId());
            }
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        HistoricBatchQuery historicBatchQuery = this.historyService.createHistoricBatchQuery();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> ((HistoricBatchQuery)historicBatchQuery).count(), 15L);
    }

    @Test
    public void shouldDistributeWorkForTaskMetrics() {
        engineConfiguration.setTaskMetricsEnabled(true);
        engineConfiguration.setTaskMetricsTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        this.runtimeService.startProcessInstanceByKey("process").getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        for (int i = 0; i < 60; ++i) {
            if (i % 4 != 0) continue;
            ClockUtil.setCurrentTime((Date)DateUtils.addMinutes((Date)this.END_DATE, (int)i));
            this.taskService.setAssignee(taskId, "kermit" + i);
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)6));
        engineConfiguration.setHistoryCleanupDegreeOfParallelism(3);
        engineConfiguration.initHistoryCleanup();
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        this.assumeWhenThenParallelizedCleanup(jobs, () -> this.managementService.getUniqueTaskWorkerCount(null, null), 15L);
    }

    @Test
    public void shouldSeeCleanableButNoFinishedProcessInstancesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricProcessInstanceReportResult report = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().compact().singleResult();
        MatcherAssert.assertThat((Object)report.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)5L));
        MatcherAssert.assertThat((Object)report.getFinishedProcessInstanceCount(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldSeeFinishedButNoCleanableProcessInstancesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.complete(taskId);
        }
        CleanableHistoricProcessInstanceReportResult report = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().compact().singleResult();
        MatcherAssert.assertThat((Object)report.getFinishedProcessInstanceCount(), (Matcher)Is.is((Object)5L));
        MatcherAssert.assertThat((Object)report.getCleanableProcessInstanceCount(), (Matcher)Is.is((Object)0L));
    }

    @Test
    public void shouldNotSeeCleanableProcessInstancesReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.deploy(this.PROCESS);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("process");
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricProcessInstanceReportResult report = (CleanableHistoricProcessInstanceReportResult)this.historyService.createCleanableHistoricProcessInstanceReport().compact().singleResult();
        MatcherAssert.assertThat((Object)report, (Matcher)IsNull.nullValue());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldSeeCleanableDecisionInstancesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricDecisionInstanceReportResult report = (CleanableHistoricDecisionInstanceReportResult)this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionKeyIn(new String[]{"dish-decision"}).compact().singleResult();
        MatcherAssert.assertThat((Object)report.getCleanableDecisionInstanceCount(), (Matcher)Is.is((Object)5L));
        MatcherAssert.assertThat((Object)report.getFinishedDecisionInstanceCount(), (Matcher)Is.is((Object)5L));
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/dmn/deployment/drdDish.dmn11.xml"})
    public void shouldNotSeeCleanableDecisionInstancesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        this.testRule.deploy(this.CALLING_PROCESS_CALLS_DMN);
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        for (int i = 0; i < 5; ++i) {
            this.runtimeService.startProcessInstanceByKey("callingProcessCallsDmn", (Map)Variables.createVariables().putValue("temperature", (Object)32).putValue("dayType", (Object)"Weekend"));
        }
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricDecisionInstanceReportResult report = (CleanableHistoricDecisionInstanceReportResult)this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionKeyIn(new String[]{"dish-decision"}).compact().singleResult();
        MatcherAssert.assertThat((Object)report.getCleanableDecisionInstanceCount(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)report.getFinishedDecisionInstanceCount(), (Matcher)Is.is((Object)5L));
    }

    @Test
    public void shouldSeeCleanableBatchesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("start").initHistoryRemovalTime();
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricBatchReportResult report = (CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult();
        MatcherAssert.assertThat((Object)report.getCleanableBatchesCount(), (Matcher)Is.is((Object)1L));
        MatcherAssert.assertThat((Object)report.getFinishedBatchesCount(), (Matcher)Is.is((Object)0L));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Test
    public void shouldNotSeeCleanableBatchesInReport() {
        engineConfiguration.setHistoryRemovalTimeStrategy("end").initHistoryRemovalTime();
        engineConfiguration.setBatchOperationHistoryTimeToLive("P5D");
        engineConfiguration.initHistoryCleanup();
        this.testRule.deploy(this.PROCESS);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        ClockUtil.setCurrentTime((Date)this.END_DATE);
        Batch batch = this.runtimeService.deleteProcessInstancesAsync(Collections.singletonList(processInstanceId), "aDeleteReason");
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)this.END_DATE, (int)5));
        CleanableHistoricBatchReportResult report = (CleanableHistoricBatchReportResult)this.historyService.createCleanableHistoricBatchReport().singleResult();
        MatcherAssert.assertThat((Object)report.getCleanableBatchesCount(), (Matcher)Is.is((Object)0L));
        MatcherAssert.assertThat((Object)report.getFinishedBatchesCount(), (Matcher)Is.is((Object)0L));
        this.managementService.deleteBatch(batch.getId(), true);
    }

    protected void assumeWhenThenParallelizedCleanup(List<Job> jobs, Supplier<Long> supplier, long initialInstanceCount) {
        MatcherAssert.assertThat((Object)jobs.size(), (Matcher)Is.is((Object)3));
        MatcherAssert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)initialInstanceCount));
        long expectedInstanceCount = initialInstanceCount - initialInstanceCount / 3L;
        for (Job job : jobs) {
            String jobId = job.getId();
            this.jobIds.add(jobId);
            this.managementService.executeJob(jobId);
            MatcherAssert.assertThat((Object)supplier.get(), (Matcher)Is.is((Object)expectedInstanceCount));
            expectedInstanceCount -= initialInstanceCount / 3L;
        }
    }

    protected List<Job> runHistoryCleanup() {
        this.historyService.cleanUpHistoryAsync(true);
        List jobs = this.historyService.findHistoryCleanupJobs();
        for (Job job : jobs) {
            this.jobIds.add(job.getId());
            this.managementService.executeJob(job.getId());
        }
        return jobs;
    }

    protected Long getAttachmentCountBy(List<String> processInstanceIds) {
        ArrayList attachments = new ArrayList();
        for (String processInstanceId : processInstanceIds) {
            attachments.addAll(this.taskService.getProcessInstanceAttachments(processInstanceId));
        }
        return attachments.size();
    }

    protected Long getCommentCountBy(List<String> processInstanceIds) {
        ArrayList comments = new ArrayList();
        for (String processInstanceId : processInstanceIds) {
            comments.addAll(this.taskService.getProcessInstanceComments(processInstanceId));
        }
        return comments.size();
    }

    protected ByteArrayEntity findByteArrayById(String byteArrayId) {
        return (ByteArrayEntity)engineConfiguration.getCommandExecutorTxRequired().execute((Command)new GetByteArrayCommand(byteArrayId));
    }

    protected Long byteArrayCount() {
        List jobLogs = this.historyService.createHistoricJobLogQuery().failureLog().list();
        ArrayList<ByteArrayEntity> byteArrays = new ArrayList<ByteArrayEntity>();
        for (HistoricJobLog jobLog : jobLogs) {
            byteArrays.add(this.findByteArrayById(((HistoricJobLogEventEntity)jobLog).getExceptionByteArrayId()));
        }
        return byteArrays.size();
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearJob(final String jobId) {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    commandContext.getJobManager().delete((DbEntity)job);
                }
                return null;
            }
        });
    }

    protected void clearMeterLog() {
        engineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    protected void clearAuthorization() {
        this.authorizationService.createAuthorizationQuery().list().forEach(authorization -> this.authorizationService.deleteAuthorization(authorization.getId()));
    }
}

