/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.identity.PasswordPolicy;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.identity.DefaultPasswordPolicyImpl;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class CustomPasswordPolicyTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    private ProcessEngineConfigurationImpl processEngineConfiguration;
    private IdentityService identityService;

    @Before
    public void init() {
        this.identityService = this.engineRule.getIdentityService();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.processEngineConfiguration.setPasswordPolicy((PasswordPolicy)new DefaultPasswordPolicyImpl());
        this.processEngineConfiguration.setEnablePasswordPolicy(true);
    }

    @After
    public void tearDown() {
        this.processEngineConfiguration.setPasswordPolicy(null);
        this.processEngineConfiguration.setEnablePasswordPolicy(false);
        this.identityService.deleteUser("user");
    }

    @Test
    public void testPasswordPolicyConfiguration() {
        PasswordPolicy policy = this.processEngineConfiguration.getPasswordPolicy();
        Assertions.assertThat((boolean)policy.getClass().isAssignableFrom(DefaultPasswordPolicyImpl.class)).isTrue();
        Assertions.assertThat((List)policy.getRules()).hasSize(6);
    }

    @Test
    public void testCustomPasswordPolicyWithCompliantPassword() {
        User user = this.identityService.newUser("user");
        user.setPassword("this-is-1-STRONG-password");
        this.identityService.saveUser(user);
        Assertions.assertThat((long)this.identityService.createUserQuery().userId(user.getId()).count()).isEqualTo(1L);
    }

    @Test
    public void testCustomPasswordPolicyWithNonCompliantPassword() {
        User user = this.identityService.newUser("user");
        user.setPassword("weakpassword");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.saveUser(user)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Password does not match policy");
        Assertions.assertThat((long)this.identityService.createUserQuery().userId(user.getId()).count()).isEqualTo(0L);
    }
}

