/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.identity;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineBootstrapRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class ReadOnlyIdentityServiceTest {
    protected static final String CONFIGURATION_RESOURCE = "org/camunda/bpm/engine/test/api/identity/read.only.identity.service.camunda.cfg.xml";
    @ClassRule
    public static ProcessEngineBootstrapRule bootstrapRule = new ProcessEngineBootstrapRule("org/camunda/bpm/engine/test/api/identity/read.only.identity.service.camunda.cfg.xml");
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule(bootstrapRule);
    protected IdentityService identityService;

    @Before
    public void setUp() {
        this.identityService = this.engineRule.getIdentityService();
        Assert.assertTrue((boolean)this.identityService.isReadOnly());
    }

    @Test
    public void newUser() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.newUser("user")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void saveUser() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.saveUser(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteUser() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteUser("user")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void newGroup() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.newGroup("group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void saveGroup() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.saveGroup(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteGroup() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteGroup("group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void newTenant() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.newTenant("tenant")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void saveTenant() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.saveTenant(null)).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteTenant() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteTenant("tenant")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void createGroupMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createMembership("user", "group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteGroupMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteMembership("user", "group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void createTenantUserMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createTenantUserMembership("tenant", "user")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void createTenantGroupMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.createTenantGroupMembership("tenant", "group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteTenantUserMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteTenantUserMembership("tenant", "user")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void deleteTenantGroupMembership() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.identityService.deleteTenantGroupMembership("tenant", "group")).isInstanceOf(UnsupportedOperationException.class)).hasMessageContaining("This identity service implementation is read-only.");
    }

    @Test
    public void checkPassword() {
        this.identityService.checkPassword("user", "password");
    }

    @Test
    public void createQuery() {
        this.identityService.createUserQuery().list();
        this.identityService.createGroupQuery().list();
        this.identityService.createTenantQuery().list();
    }
}

