/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.IncidentQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.api.mgmt.AlwaysFailingDelegate;
import org.camunda.bpm.engine.test.api.mgmt.FailingDelegate;
import org.camunda.bpm.engine.test.api.runtime.util.ChangeVariablesDelegate;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.test.util.Removable;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BoundaryEventBuilder;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.junit.Assert;
import org.junit.Test;

public class IncidentTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateOneIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getId());
        Assert.assertNotNull((Object)incident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)"Expected exception", (Object)incident.getIncidentMessage());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident.getExecutionId());
        Assert.assertEquals((Object)"theServiceTask", (Object)incident.getActivityId());
        Assert.assertEquals((Object)"theServiceTask", (Object)incident.getFailedActivityId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident.getProcessInstanceId());
        Assert.assertEquals((Object)processInstance.getProcessDefinitionId(), (Object)incident.getProcessDefinitionId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getCauseIncidentId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getRootCauseIncidentId());
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((Object)job.getId(), (Object)incident.getConfiguration());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)incident.getJobDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateOneIncidentAfterSetRetries() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.setJobRetries(job.getId(), 1);
        this.testRule.executeAvailableJobs();
        incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateOneIncidentAfterExecuteJob() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception was expected.");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        incidents = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 1 ? 1 : 0) != 0);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncidentForNestedExecution.bpmn"})
    @Test
    public void shouldCreateOneIncidentForNestedExecution() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcessWithNestedExecutions");
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        String executionIdOfNestedFailingExecution = job.getExecutionId();
        Assert.assertFalse((processInstance.getId() == executionIdOfNestedFailingExecution ? 1 : 0) != 0);
        Assert.assertNotNull((Object)incident.getId());
        Assert.assertNotNull((Object)incident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)incident.getIncidentType());
        Assert.assertEquals((Object)"Expected exception", (Object)incident.getIncidentMessage());
        Assert.assertEquals((Object)executionIdOfNestedFailingExecution, (Object)incident.getExecutionId());
        Assert.assertEquals((Object)"theServiceTask", (Object)incident.getActivityId());
        Assert.assertEquals((Object)"theServiceTask", (Object)incident.getFailedActivityId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)incident.getProcessInstanceId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getCauseIncidentId());
        Assert.assertEquals((Object)incident.getId(), (Object)incident.getRootCauseIncidentId());
        Assert.assertEquals((Object)job.getId(), (Object)incident.getConfiguration());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)incident.getJobDefinitionId());
    }

    @Test
    public void shouldCreateIncidentWithCorrectMessageWhenZeroRetriesAreDefined() {
        String key = "process";
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)key).camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theServiceTask").camundaClass(AlwaysFailingDelegate.class)).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R0/PT30S")).endEvent().done();
        this.testRule.deploy(model);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(key);
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getId()).isNotNull();
        Assertions.assertThat((Date)incident.getIncidentTimestamp()).isNotNull();
        Assertions.assertThat((String)incident.getIncidentType()).isEqualTo((Object)"failedJob");
        Assertions.assertThat((String)incident.getIncidentMessage()).isEqualTo((Object)"Expected exception");
        Assertions.assertThat((String)incident.getExecutionId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)incident.getActivityId()).isEqualTo((Object)"theServiceTask");
        Assertions.assertThat((String)incident.getFailedActivityId()).isEqualTo((Object)"theServiceTask");
        Assertions.assertThat((String)incident.getProcessInstanceId()).isEqualTo((Object)processInstance.getId());
        Assertions.assertThat((String)incident.getProcessDefinitionId()).isEqualTo((Object)processInstance.getProcessDefinitionId());
        Assertions.assertThat((String)incident.getCauseIncidentId()).isEqualTo((Object)incident.getId());
        Assertions.assertThat((String)incident.getRootCauseIncidentId()).isEqualTo((Object)incident.getId());
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assertions.assertThat((String)job.getExceptionMessage()).isEqualTo((Object)"Expected exception");
        String stacktrace = this.managementService.getJobExceptionStacktrace(job.getId());
        Assertions.assertThat((String)stacktrace).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateRecursiveIncidents.bpmn", "org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateRecursiveIncidents() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callFailingProcess");
        this.testRule.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 2 ? 1 : 0) != 0);
        ProcessInstance failingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("failingProcess").singleResult();
        Assert.assertNotNull((Object)failingProcess);
        ProcessInstance callProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callFailingProcess").singleResult();
        Assert.assertNotNull((Object)callProcess);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(failingProcess.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)causeIncident);
        Job job = (Job)this.managementService.createJobQuery().executionId(causeIncident.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNotNull((Object)causeIncident.getId());
        Assert.assertNotNull((Object)causeIncident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)causeIncident.getIncidentType());
        Assert.assertEquals((Object)"Expected exception", (Object)causeIncident.getIncidentMessage());
        Assert.assertEquals((Object)job.getExecutionId(), (Object)causeIncident.getExecutionId());
        Assert.assertEquals((Object)"theServiceTask", (Object)causeIncident.getActivityId());
        Assert.assertEquals((Object)"theServiceTask", (Object)causeIncident.getFailedActivityId());
        Assert.assertEquals((Object)failingProcess.getId(), (Object)causeIncident.getProcessInstanceId());
        Assert.assertEquals((Object)causeIncident.getId(), (Object)causeIncident.getCauseIncidentId());
        Assert.assertEquals((Object)causeIncident.getId(), (Object)causeIncident.getRootCauseIncidentId());
        Assert.assertEquals((Object)job.getId(), (Object)causeIncident.getConfiguration());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)causeIncident.getJobDefinitionId());
        Incident recursiveCreatedIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(callProcess.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)recursiveCreatedIncident);
        Execution theCallActivityExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallActivity").singleResult();
        Assert.assertNotNull((Object)theCallActivityExecution);
        Assert.assertNotNull((Object)recursiveCreatedIncident.getId());
        Assert.assertNotNull((Object)recursiveCreatedIncident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)recursiveCreatedIncident.getIncidentType());
        Assert.assertNull((Object)recursiveCreatedIncident.getIncidentMessage());
        Assert.assertEquals((Object)theCallActivityExecution.getId(), (Object)recursiveCreatedIncident.getExecutionId());
        Assert.assertEquals((Object)"theCallActivity", (Object)recursiveCreatedIncident.getActivityId());
        Assert.assertEquals((Object)"theCallActivity", (Object)recursiveCreatedIncident.getFailedActivityId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)recursiveCreatedIncident.getProcessInstanceId());
        Assert.assertEquals((Object)causeIncident.getId(), (Object)recursiveCreatedIncident.getCauseIncidentId());
        Assert.assertEquals((Object)causeIncident.getId(), (Object)recursiveCreatedIncident.getRootCauseIncidentId());
        Assert.assertNull((Object)recursiveCreatedIncident.getConfiguration());
        Assert.assertNull((Object)recursiveCreatedIncident.getJobDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateRecursiveIncidentsForNestedCallActivity.bpmn", "org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateRecursiveIncidents.bpmn", "org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldCreateRecursiveIncidentsForNestedCallActivity() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("callingFailingCallActivity");
        this.testRule.executeAvailableJobs();
        List incidents = this.runtimeService.createIncidentQuery().list();
        Assert.assertFalse((boolean)incidents.isEmpty());
        Assert.assertTrue((incidents.size() == 3 ? 1 : 0) != 0);
        ProcessInstance failingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("failingProcess").singleResult();
        Assert.assertNotNull((Object)failingProcess);
        Incident rootCauseIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(failingProcess.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)rootCauseIncident);
        Job job = (Job)this.managementService.createJobQuery().executionId(rootCauseIncident.getExecutionId()).singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNotNull((Object)rootCauseIncident.getId());
        Assert.assertNotNull((Object)rootCauseIncident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)rootCauseIncident.getIncidentType());
        Assert.assertEquals((Object)"Expected exception", (Object)rootCauseIncident.getIncidentMessage());
        Assert.assertEquals((Object)job.getExecutionId(), (Object)rootCauseIncident.getExecutionId());
        Assert.assertEquals((Object)"theServiceTask", (Object)rootCauseIncident.getActivityId());
        Assert.assertEquals((Object)"theServiceTask", (Object)rootCauseIncident.getFailedActivityId());
        Assert.assertEquals((Object)failingProcess.getId(), (Object)rootCauseIncident.getProcessInstanceId());
        Assert.assertEquals((Object)rootCauseIncident.getId(), (Object)rootCauseIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseIncident.getId(), (Object)rootCauseIncident.getRootCauseIncidentId());
        Assert.assertEquals((Object)job.getId(), (Object)rootCauseIncident.getConfiguration());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)rootCauseIncident.getJobDefinitionId());
        ProcessInstance callFailingProcess = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("callFailingProcess").singleResult();
        Assert.assertNotNull((Object)callFailingProcess);
        Incident causeIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(callFailingProcess.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)causeIncident);
        Execution theCallActivityExecution = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallActivity").singleResult();
        Assert.assertNotNull((Object)theCallActivityExecution);
        Assert.assertNotNull((Object)causeIncident.getId());
        Assert.assertNotNull((Object)causeIncident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)causeIncident.getIncidentType());
        Assert.assertNull((Object)causeIncident.getIncidentMessage());
        Assert.assertEquals((Object)theCallActivityExecution.getId(), (Object)causeIncident.getExecutionId());
        Assert.assertEquals((Object)"theCallActivity", (Object)causeIncident.getActivityId());
        Assert.assertEquals((Object)"theCallActivity", (Object)causeIncident.getFailedActivityId());
        Assert.assertEquals((Object)callFailingProcess.getId(), (Object)causeIncident.getProcessInstanceId());
        Assert.assertEquals((Object)rootCauseIncident.getId(), (Object)causeIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseIncident.getId(), (Object)causeIncident.getRootCauseIncidentId());
        Assert.assertNull((Object)causeIncident.getConfiguration());
        Assert.assertNull((Object)causeIncident.getJobDefinitionId());
        Incident topLevelIncident = (Incident)this.runtimeService.createIncidentQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        Assert.assertNotNull((Object)topLevelIncident);
        Execution theCallingCallActivity = (Execution)this.runtimeService.createExecutionQuery().activityId("theCallingCallActivity").singleResult();
        Assert.assertNotNull((Object)theCallingCallActivity);
        Assert.assertNotNull((Object)topLevelIncident.getId());
        Assert.assertNotNull((Object)topLevelIncident.getIncidentTimestamp());
        Assert.assertEquals((Object)"failedJob", (Object)topLevelIncident.getIncidentType());
        Assert.assertNull((Object)topLevelIncident.getIncidentMessage());
        Assert.assertEquals((Object)theCallingCallActivity.getId(), (Object)topLevelIncident.getExecutionId());
        Assert.assertEquals((Object)"theCallingCallActivity", (Object)topLevelIncident.getActivityId());
        Assert.assertEquals((Object)"theCallingCallActivity", (Object)topLevelIncident.getFailedActivityId());
        Assert.assertEquals((Object)processInstance.getId(), (Object)topLevelIncident.getProcessInstanceId());
        Assert.assertEquals((Object)causeIncident.getId(), (Object)topLevelIncident.getCauseIncidentId());
        Assert.assertEquals((Object)rootCauseIncident.getId(), (Object)topLevelIncident.getRootCauseIncidentId());
        Assert.assertNull((Object)topLevelIncident.getConfiguration());
        Assert.assertNull((Object)topLevelIncident.getJobDefinitionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldDeleteIncidentAfterJobHasBeenDeleted() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        this.managementService.deleteJob(job.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().incidentId(incident.getId()).singleResult();
        Assert.assertNull((Object)incident);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldDeleteIncidentAfterJobWasSuccessfully.bpmn"})
    @Test
    public void shouldDeleteIncidentAfterJobWasSuccessfully() {
        HashMap<String, Boolean> parameters = new HashMap<String, Boolean>();
        parameters.put("fail", true);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcessWithUserTask", parameters);
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)job);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        this.runtimeService.setVariable(processInstance.getId(), "fail", (Object)new Boolean(false));
        this.managementService.setJobRetries(job.getId(), 1);
        this.testRule.executeAvailableJobs();
        processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertTrue((boolean)(processInstance instanceof ExecutionEntity));
        ExecutionEntity exec = (ExecutionEntity)processInstance;
        Assert.assertEquals((Object)"theUserTask", (Object)exec.getActivityId());
        incident = (Incident)this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)incident);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateIncidentOnFailedStartTimerEvent.bpmn"})
    @Test
    public void shouldCreateIncidentOnFailedStartTimerEvent() {
        JobQuery jobQuery = this.managementService.createJobQuery();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        Job job = (Job)jobQuery.singleResult();
        String jobId = job.getId();
        while (0 != job.getRetries()) {
            try {
                this.managementService.executeJob(jobId);
                Assert.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            job = (Job)jobQuery.jobId(jobId).singleResult();
        }
        job = (Job)jobQuery.singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().configuration(job.getId()).singleResult();
        Assert.assertNotNull((Object)incident);
        this.managementService.deleteJob(job.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldNotCreateNewIncident() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        IncidentQuery query = this.runtimeService.createIncidentQuery().processInstanceId(processInstance.getId());
        Incident incident = (Incident)query.singleResult();
        Assert.assertNotNull((Object)incident);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 1);
        Incident tmp = (Incident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
        this.testRule.executeAvailableJobs();
        Assert.assertEquals((long)1L, (long)query.count());
        tmp = (Incident)query.singleResult();
        Assert.assertEquals((Object)incident.getId(), (Object)tmp.getId());
    }

    @Deployment
    @Test
    public void shouldUpdateIncidentAfterCompaction() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotSame((Object)processInstanceId, (Object)incident.getExecutionId());
        this.runtimeService.correlateMessage("Message");
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)processInstanceId, (Object)incident.getExecutionId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/IncidentTest.testShouldCreateOneIncident.bpmn"})
    @Test
    public void shouldNotSetNegativeRetries() {
        this.runtimeService.startProcessInstanceByKey("failingProcess");
        this.testRule.executeAvailableJobs();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
        final JobEntity jobEntity = (JobEntity)job;
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                jobEntity.setRetries(-100);
                return null;
            }
        });
        Assert.assertEquals((long)0L, (long)job.getRetries());
        try {
            this.managementService.executeJob(job.getId());
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)0L, (long)job.getRetries());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
        try {
            this.managementService.setJobRetries(job.getId(), -200);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        try {
            this.managementService.setJobRetriesByJobDefinitionId(job.getJobDefinitionId(), -300);
            Assert.fail((String)"Exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
    }

    @Deployment
    @Test
    public void shouldSetActivityIdProperty() {
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getActivityId());
        Assert.assertEquals((Object)"theStart", (Object)incident.getActivityId());
        Assert.assertNull((Object)incident.getProcessInstanceId());
        Assert.assertNull((Object)incident.getExecutionId());
    }

    @Test
    public void shouldShowFailedActivityIdPropertyForFailingAsyncTask() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getFailedActivityId());
        Assert.assertEquals((Object)"theTask", (Object)incident.getFailedActivityId());
    }

    @Test
    public void shouldShowFailedActivityIdPropertyForAsyncTaskWithFailingFollowUp() {
        this.testRule.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theTask").camundaAsyncBefore()).camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask2").camundaClass(ChangeVariablesDelegate.class)).serviceTask("theTask3").camundaClass(FailingDelegate.class)).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process", (Map)Variables.createVariables().putValue("fail", (Object)true));
        this.testRule.executeAvailableJobs();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertNotNull((Object)incident.getFailedActivityId());
        Assert.assertEquals((Object)"theTask3", (Object)incident.getFailedActivityId());
    }

    @Test
    public void shouldSetBoundaryEventIncidentActivityId() {
        this.testRule.deploy(((BoundaryEventBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("userTask").endEvent().moveToActivity("userTask").boundaryEvent("boundaryEvent").timerWithDuration("PT5S")).endEvent().done());
        this.runtimeService.startProcessInstanceByKey("process");
        Job timerJob = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(timerJob.getId(), 0);
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assert.assertNotNull((Object)incident);
        Assert.assertEquals((Object)"boundaryEvent", (Object)incident.getActivityId());
    }

    @Test
    public void shouldSetAnnotationForIncident() {
        String annotation = "my annotation";
        Incident incident = this.createIncident();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), annotation);
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getAnnotation()).isEqualTo((Object)annotation);
    }

    @Test
    public void shouldSetAnnotationForStandaloneIncident() {
        String annotation = "my annotation";
        String jobId = this.createStandaloneIncident();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), annotation);
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getAnnotation()).isEqualTo((Object)annotation);
        this.cleanupStandalonIncident(jobId);
    }

    @Test
    public void shouldFailSetAnnotationForIncidentWithNullId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setAnnotationForIncidentById(null, "my annotation")).isInstanceOf(NotValidException.class)).hasMessageContaining("incident id");
    }

    @Test
    public void shouldFailSetAnnotationForIncidentWithNonExistingIncidentId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.setAnnotationForIncidentById("not existing", "my annotation")).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("incident");
    }

    @Test
    public void shouldUpdateAnnotationForIncident() {
        String annotation = "my new annotation";
        Incident incident = this.createIncident();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "old annotation");
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), annotation);
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getAnnotation()).isEqualTo((Object)annotation);
    }

    @Test
    public void shouldClearAnnotationForIncident() {
        Incident incident = this.createIncident();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "old annotation");
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getAnnotation()).isNull();
    }

    @Test
    public void shouldClearAnnotationForStandaloneIncident() {
        String jobId = this.createStandaloneIncident();
        Incident incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), "old annotation");
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
        incident = (Incident)this.runtimeService.createIncidentQuery().singleResult();
        Assertions.assertThat((String)incident.getAnnotation()).isNull();
        this.cleanupStandalonIncident(jobId);
    }

    @Test
    public void shouldFailClearAnnotationForIncidentWithNullId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.clearAnnotationForIncidentById(null)).isInstanceOf(NotValidException.class)).hasMessageContaining("incident id");
    }

    @Test
    public void shouldFailClearAnnotationForIncidentWithNonExistingIncidentId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.runtimeService.clearAnnotationForIncidentById("not existing")).isInstanceOf(BadUserRequestException.class)).hasMessageContaining("incident");
    }

    protected Incident createIncident() {
        String key = "process";
        BpmnModelInstance model = ((ServiceTaskBuilder)((ServiceTaskBuilder)((ServiceTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)key).camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().serviceTask("theServiceTask").camundaClass(AlwaysFailingDelegate.class)).camundaAsyncBefore()).camundaFailedJobRetryTimeCycle("R0/PT30S")).endEvent().done();
        this.testRule.deploy(model);
        this.runtimeService.startProcessInstanceByKey(key);
        this.testRule.executeAvailableJobs();
        return (Incident)this.runtimeService.createIncidentQuery().singleResult();
    }

    protected String createStandaloneIncident() {
        this.repositoryService.suspendProcessDefinitionByKey("process", true, new Date());
        String jobId = null;
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            if (job.getProcessDefinitionKey() != null) continue;
            jobId = job.getId();
            break;
        }
        this.managementService.setJobRetries(jobId, 0);
        return jobId;
    }

    protected void cleanupStandalonIncident(String jobId) {
        this.managementService.deleteJob(jobId);
        Removable.of(this.processEngine).remove(HistoricIncident.class);
    }
}

