/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricIncident;
import org.camunda.bpm.engine.impl.ProcessEngineImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.AcquireJobsCmd;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.jobexecutor.JobExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentEntity;
import org.camunda.bpm.engine.impl.persistence.entity.HistoricIncidentManager;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.impl.persistence.entity.JobManager;
import org.camunda.bpm.engine.impl.persistence.entity.MessageEntity;
import org.camunda.bpm.engine.impl.persistence.entity.PropertyEntity;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.management.TableMetaData;
import org.camunda.bpm.engine.management.TablePage;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ManagementServiceTest
extends PluggableProcessEngineTest {
    protected boolean tearDownTelemetry;
    protected boolean tearDownEnsureJobDueDateNotNull;
    protected final Date TEST_DUE_DATE = new Date(1675752840000L);

    @After
    public void tearDown() {
        if (this.tearDownTelemetry) {
            this.managementService.toggleTelemetry(false);
        }
        if (this.tearDownEnsureJobDueDateNotNull) {
            this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        }
    }

    @Test
    public void testGetMetaDataForUnexistingTable() {
        TableMetaData metaData = this.managementService.getTableMetaData("unexistingtable");
        Assert.assertNull((Object)metaData);
    }

    @Test
    public void testGetMetaDataNullTableName() {
        try {
            this.managementService.getTableMetaData(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("tableName is null", re.getMessage());
        }
    }

    @Test
    public void testExecuteJobNullJobId() {
        try {
            this.managementService.executeJob(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    @Test
    public void testExecuteJobUnexistingJob() {
        try {
            this.managementService.executeJob("unexistingjob");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No job found with id", ae.getMessage());
        }
    }

    @Deployment
    @Test
    public void testGetJobExceptionStacktrace() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        try {
            this.managementService.executeJob(timerJob.getId());
            Assert.fail((String)"RuntimeException from within the script task expected");
        }
        catch (RuntimeException re) {
            this.testRule.assertTextPresent("This is an exception thrown from scriptTask", re.getMessage());
        }
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((Object)timerJob);
        Assert.assertNotNull((Object)timerJob.getExceptionMessage());
        this.testRule.assertTextPresent("This is an exception thrown from scriptTask", timerJob.getExceptionMessage());
        String exceptionStack = this.managementService.getJobExceptionStacktrace(timerJob.getId());
        Assert.assertNotNull((Object)exceptionStack);
        this.testRule.assertTextPresent("This is an exception thrown from scriptTask", exceptionStack);
    }

    @Test
    public void testgetJobExceptionStacktraceUnexistingJobId() {
        try {
            this.managementService.getJobExceptionStacktrace("unexistingjob");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("No job found with id unexistingjob", re.getMessage());
        }
    }

    @Test
    public void testgetJobExceptionStacktraceNullJobId() {
        try {
            this.managementService.getJobExceptionStacktrace(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobRetries() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        Assert.assertEquals((long)3L, (long)timerJob.getRetries());
        this.managementService.setJobRetries(timerJob.getId(), 5);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((long)5L, (long)timerJob.getRetries());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetMultipleJobRetries() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List<String> allJobIds = this.getAllJobIds();
        this.managementService.setJobRetries(allJobIds, 5);
        this.assertRetries(allJobIds, 5);
    }

    @Test
    public void shouldThrowExceptionOnSetJobRetriesWithNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries((List)null, 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("job ids is null");
    }

    @Test
    public void shouldThrowExceptionOnSetJobRetriesWithNoJobReference() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries(5).execute()).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("052").hasMessageContaining("You must specify exactly one of jobId, jobIds or jobDefinitionId as parameter.");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetJobRetriesWithDuedateByJobIds() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List<String> jobIds = this.getAllJobIds();
        this.managementService.setJobRetries(5).jobIds(jobIds).dueDate(this.TEST_DUE_DATE).execute();
        List jobs = this.managementService.createJobQuery().list();
        for (Job job : jobs) {
            Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
            Assertions.assertThat((Date)job.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetJobRetriesWithDuedateByJobId() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List<String> jobIds = this.getAllJobIds();
        String jobId = jobIds.get(0);
        this.managementService.setJobRetries(5).jobId(jobId).dueDate(this.TEST_DUE_DATE).execute();
        Job job = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
        Assertions.assertThat((Date)job.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetJobRetriesWithNullDuedateByJobId() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List jobs = this.managementService.createJobQuery().list();
        Job job = (Job)jobs.get(0);
        String jobId = job.getId();
        this.managementService.setJobRetries(5).jobId(jobId).dueDate(null).execute();
        Job updatedJob = (Job)this.managementService.createJobQuery().jobId(jobId).singleResult();
        Assertions.assertThat((int)updatedJob.getRetries()).isEqualTo(5);
        Assertions.assertThat((Date)updatedJob.getDuedate()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetJobRetriesWithDuedateByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List list = this.managementService.createJobQuery().list();
        Job job = (Job)list.get(0);
        this.managementService.setJobRetries(job.getId(), 0);
        this.managementService.setJobRetries(5).jobDefinitionId(job.getJobDefinitionId()).dueDate(this.TEST_DUE_DATE).execute();
        job = (Job)this.managementService.createJobQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        Assertions.assertThat((int)job.getRetries()).isEqualTo(5);
        Assertions.assertThat((Date)job.getDuedate()).isEqualToIgnoringMillis(this.TEST_DUE_DATE);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetJobRetriesWithNullDuedateByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List list = this.managementService.createJobQuery().list();
        Job job = (Job)list.get(0);
        this.managementService.setJobRetries(job.getId(), 0);
        this.managementService.setJobRetries(5).jobDefinitionId(job.getJobDefinitionId()).dueDate(null).execute();
        Job updatedJob = (Job)this.managementService.createJobQuery().jobDefinitionId(job.getJobDefinitionId()).singleResult();
        Assertions.assertThat((int)updatedJob.getRetries()).isEqualTo(5);
        Assertions.assertThat((Date)updatedJob.getDuedate()).isNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetDueDateOnSetJobRetriesWithNullDuedateWhenEnsureDueDateNotNull() {
        this.tearDownEnsureJobDueDateNotNull = true;
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(true);
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List list = this.managementService.createJobQuery().list();
        Job job = (Job)list.get(0);
        this.managementService.setJobRetries(job.getId(), 0);
        this.managementService.setJobRetries(5).jobDefinitionId(job.getJobDefinitionId()).dueDate(null).execute();
        job = (Job)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isNotNull();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void shouldSetDueDateNullOnSetJobRetriesWithNullDuedateWhenNotEnsureDueDateNotNull() {
        this.tearDownEnsureJobDueDateNotNull = true;
        this.processEngineConfiguration.setEnsureJobDueDateNotNull(false);
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List list = this.managementService.createJobQuery().list();
        Job job = (Job)list.get(0);
        this.managementService.setJobRetries(job.getId(), 0);
        this.managementService.setJobRetries(5).jobDefinitionId(job.getJobDefinitionId()).dueDate(null).execute();
        job = (Job)this.managementService.createJobQuery().jobId(job.getId()).singleResult();
        Assertions.assertThat((Date)job.getDuedate()).isNull();
    }

    @Test
    public void shouldThrowExceptionOnSetJobRetriesWithNegativeRetries() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries("aFake", -1)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("54").hasMessageContaining("The number of job retries must be a non-negative Integer, but '-1' has been provided.");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobRetriesWithFake() {
        this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        List<String> allJobIds = this.getAllJobIds();
        allJobIds.add("aFake");
        try {
            this.managementService.setJobRetries(allJobIds, 5);
            Assert.fail((String)"exception expected");
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.assertRetries(this.getAllJobIds(), 3);
    }

    protected void assertRetries(List<String> allJobIds, int i) {
        for (String id : allJobIds) {
            Assertions.assertThat((int)((Job)this.managementService.createJobQuery().jobId(id).singleResult()).getRetries()).isEqualTo(i);
        }
    }

    protected List<String> getAllJobIds() {
        ArrayList<String> result = new ArrayList<String>();
        for (Job job : this.managementService.createJobQuery().list()) {
            result.add(job.getId());
        }
        return result;
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobRetriesNullCreatesIncident() {
        Assert.assertEquals((long)0L, (long)this.runtimeService.createIncidentQuery().count());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        Assert.assertEquals((long)3L, (long)timerJob.getRetries());
        this.managementService.setJobRetries(timerJob.getId(), 0);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertEquals((long)0L, (long)timerJob.getRetries());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createIncidentQuery().count());
    }

    @Test
    public void shouldThrowExceptionOnSetJobRetriesWithUnexistingJobId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries("unexistingjob", 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("053").hasMessageContaining("No job found with id 'unexistingjob'.");
    }

    @Test
    public void shouldThrowExceptionOnSetJobRetriesWithEmptyJobId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries("", 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("052").hasMessageContaining("You must specify exactly one of jobId, jobIds or jobDefinitionId as parameter.");
    }

    @Test
    public void testSetJobRetriesJobIdNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetries((String)null, 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("052").hasMessageContaining("You must specify exactly one of jobId, jobIds or jobDefinitionId as parameter.");
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobRetriesByJobDefinitionId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        this.testRule.executeAvailableJobs();
        JobQuery query = this.managementService.createJobQuery().processInstanceId(processInstance.getId());
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        Job timerJob = (Job)query.singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        Assert.assertEquals((long)0L, (long)timerJob.getRetries());
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 5);
        timerJob = (Job)query.singleResult();
        Assert.assertEquals((long)5L, (long)timerJob.getRetries());
    }

    @Test
    public void testSetJobRetriesByJobDefinitionIdEmptyJobDefinitionId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesByJobDefinitionId("", 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("052").hasMessageContaining("You must specify exactly one of jobId, jobIds or jobDefinitionId as parameter.");
    }

    @Test
    public void testSetJobRetriesByJobDefinitionIdNull() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.managementService.setJobRetriesByJobDefinitionId(null, 5)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("052").hasMessageContaining("You must specify exactly one of jobId, jobIds or jobDefinitionId as parameter.");
    }

    @Test
    public void testSetJobRetriesUnlocksInconsistentJob() {
        this.createJob(0, "owner", ClockUtil.getCurrentTime());
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNull((Object)job.getLockOwner());
        Assert.assertNull((Object)job.getLockExpirationTime());
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
        this.createJob(2, "owner", null);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNull((Object)job.getLockOwner());
        Assert.assertNull((Object)job.getLockExpirationTime());
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
        this.createJob(2, "owner", ClockUtil.getCurrentTime());
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 3);
        job = (JobEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNotNull((Object)job.getLockOwner());
        Assert.assertNotNull((Object)job.getLockExpirationTime());
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
    }

    protected void createJob(final int retries, final String owner, final Date lockExpirationTime) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                MessageEntity job = new MessageEntity();
                job.setJobHandlerType("any");
                job.setLockOwner(owner);
                job.setLockExpirationTime(lockExpirationTime);
                job.setRetries(retries);
                jobManager.send(job);
                return null;
            }
        });
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobRetriesByDefinitionUnlocksInconsistentJobs() {
        final JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                JobManager jobManager = commandContext.getJobManager();
                MessageEntity job = new MessageEntity();
                job.setJobDefinitionId(jobDefinition.getId());
                job.setJobHandlerType("any");
                job.setLockOwner("owner");
                job.setLockExpirationTime(ClockUtil.getCurrentTime());
                job.setRetries(0);
                jobManager.send(job);
                return null;
            }
        });
        this.managementService.setJobRetriesByJobDefinitionId(jobDefinition.getId(), 3);
        JobEntity job = (JobEntity)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)job);
        Assert.assertNull((Object)job.getLockOwner());
        Assert.assertNull((Object)job.getLockExpirationTime());
        Assert.assertEquals((long)3L, (long)job.getRetries());
        this.deleteJobAndIncidents((Job)job);
    }

    protected void deleteJobAndIncidents(final Job job) {
        final List incidents = this.historyService.createHistoricIncidentQuery().incidentType("failedJob").list();
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                ((JobEntity)job).delete();
                HistoricIncidentManager historicIncidentManager = commandContext.getHistoricIncidentManager();
                for (HistoricIncident incident : incidents) {
                    HistoricIncidentEntity incidentEntity = (HistoricIncidentEntity)incident;
                    historicIncidentManager.delete((DbEntity)incidentEntity);
                }
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(job.getId());
                return null;
            }
        });
    }

    @Test
    public void testDeleteJobNullJobId() {
        try {
            this.managementService.deleteJob(null);
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("jobId is null", re.getMessage());
        }
    }

    @Test
    public void testDeleteJobUnexistingJob() {
        try {
            this.managementService.deleteJob("unexistingjob");
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException ae) {
            this.testRule.assertTextPresent("No job found with id", ae.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml"})
    @Test
    public void testDeleteJobDeletion() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerOnTask");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"Task timer should be there", (Object)timerJob);
        this.managementService.deleteJob(timerJob.getId());
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((String)"There should be no job now. It was deleted", (Object)timerJob);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/timerOnTask.bpmn20.xml"})
    @Test
    public void testDeleteJobThatWasAlreadyAcquired() {
        ClockUtil.setCurrentTime((Date)new Date());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("timerOnTask");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        ClockUtil.setCurrentTime((Date)new Date(ClockUtil.getCurrentTime().getTime() + 0x6DDD00L));
        ProcessEngineImpl processEngineImpl = (ProcessEngineImpl)this.processEngine;
        JobExecutor jobExecutor = processEngineImpl.getProcessEngineConfiguration().getJobExecutor();
        AcquireJobsCmd acquireJobsCmd = new AcquireJobsCmd(jobExecutor);
        CommandExecutor commandExecutor = processEngineImpl.getProcessEngineConfiguration().getCommandExecutorTxRequired();
        commandExecutor.execute((Command)acquireJobsCmd);
        try {
            this.managementService.deleteJob(timerJob.getId());
            Assert.fail();
        }
        catch (ProcessEngineException processEngineException) {
            // empty catch block
        }
        this.managementService.executeJob(timerJob.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobDuedate() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        Assert.assertNotNull((Object)timerJob.getDuedate());
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(5, 3);
        this.managementService.setJobDuedate(timerJob.getId(), cal.getTime());
        Job newTimerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        int SECOND = 1000;
        Assert.assertEquals((long)(cal.getTime().getTime() / (long)SECOND * (long)SECOND), (long)(newTimerJob.getDuedate().getTime() / (long)SECOND * (long)SECOND));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/ManagementServiceTest.testGetJobExceptionStacktrace.bpmn20.xml"})
    @Test
    public void testSetJobDuedateDateNull() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("exceptionInJobExecution");
        Job timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNotNull((String)"No job found for process instance", (Object)timerJob);
        Assert.assertNotNull((Object)timerJob.getDuedate());
        this.managementService.setJobDuedate(timerJob.getId(), null);
        timerJob = (Job)this.managementService.createJobQuery().processInstanceId(processInstance.getId()).singleResult();
        Assert.assertNull((Object)timerJob.getDuedate());
    }

    @Test
    public void testSetJobDuedateJobIdNull() {
        try {
            this.managementService.setJobDuedate(null, new Date());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("The job id is mandatory, but 'null' has been provided.", re.getMessage());
        }
    }

    @Test
    public void testSetJobDuedateEmptyJobId() {
        try {
            this.managementService.setJobDuedate("", new Date());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("The job id is mandatory, but '' has been provided.", re.getMessage());
        }
    }

    @Test
    public void testSetJobDuedateUnexistingJobId() {
        try {
            this.managementService.setJobDuedate("unexistingjob", new Date());
            Assert.fail((String)"ProcessEngineException expected");
        }
        catch (ProcessEngineException re) {
            this.testRule.assertTextPresent("No job found with id 'unexistingjob'.", re.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/job/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobDuedateNonTimerJob() {
        this.runtimeService.startProcessInstanceByKey("oneTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().processDefinitionKey("oneTaskProcess").singleResult();
        Assert.assertNotNull((Object)job);
        this.managementService.setJobDuedate(job.getId(), new Date());
        job = (Job)this.managementService.createJobQuery().processDefinitionKey("oneTaskProcess").singleResult();
        Assert.assertNotNull((Object)job.getDuedate());
    }

    @Test
    public void testGetProperties() {
        Map properties = this.managementService.getProperties();
        Assert.assertNotNull((Object)properties);
        Assert.assertFalse((boolean)properties.isEmpty());
    }

    @Test
    public void testSetProperty() {
        String name = "testProp";
        String value = "testValue";
        this.managementService.setProperty("testProp", "testValue");
        Map properties = this.managementService.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("testProp"));
        String storedValue = (String)properties.get("testProp");
        Assert.assertEquals((Object)"testValue", (Object)storedValue);
        this.managementService.deleteProperty("testProp");
    }

    @Test
    public void testDeleteProperty() {
        String name = "testProp";
        String value = "testValue";
        this.managementService.setProperty("testProp", "testValue");
        Map properties = this.managementService.getProperties();
        Assert.assertTrue((boolean)properties.containsKey("testProp"));
        String storedValue = (String)properties.get("testProp");
        Assert.assertEquals((Object)"testValue", (Object)storedValue);
        this.managementService.deleteProperty("testProp");
        properties = this.managementService.getProperties();
        Assert.assertFalse((boolean)properties.containsKey("testProp"));
    }

    @Test
    public void testDeleteNonexistingProperty() {
        this.managementService.deleteProperty("non existing");
    }

    @Test
    public void testGetHistoryLevel() {
        int historyLevel = this.managementService.getHistoryLevel();
        Assert.assertEquals((long)this.processEngineConfiguration.getHistoryLevel().getId(), (long)historyLevel);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobPriority() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), 42L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)42L, (long)job.getPriority());
    }

    @Test
    public void testSetJobPriorityForNonExistingJob() {
        try {
            this.managementService.setJobPriority("nonExistingJob", 42L);
            Assert.fail((String)"should not succeed");
        }
        catch (NotFoundException e) {
            this.testRule.assertTextPresentIgnoreCase("No job found with id 'nonExistingJob'", e.getMessage());
        }
    }

    @Test
    public void testSetJobPriorityForNullJob() {
        try {
            this.managementService.setJobPriority(null, 42L);
            Assert.fail((String)"should not succeed");
        }
        catch (NullValueException e) {
            this.testRule.assertTextPresentIgnoreCase("Job id must not be null", e.getMessage());
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/mgmt/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobPriorityToExtremeValues() {
        ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("asyncTaskProcess").startBeforeActivity("task")).execute();
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), Long.MAX_VALUE);
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)Long.MAX_VALUE, (long)job.getPriority());
        this.managementService.setJobPriority(job.getId(), -9223372036854775807L);
        job = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertEquals((long)-9223372036854775807L, (long)job.getPriority());
    }

    @Ignore
    @Test
    public void testGetTableMetaData() {
        TableMetaData tableMetaData = this.managementService.getTableMetaData("ACT_RU_TASK");
        Assertions.assertThat((int)tableMetaData.getColumnNames().size()).isEqualTo(tableMetaData.getColumnTypes().size());
        Assertions.assertThat((List)tableMetaData.getColumnNames()).contains((Object[])new String[]{"ID_", "REV_", "NAME_", "PARENT_TASK_ID_", "PRIORITY_", "CREATE_TIME_", "LAST_UPDATED_", "OWNER_", "ASSIGNEE_", "DELEGATION_", "EXECUTION_ID_", "PROC_DEF_ID_", "PROC_INST_ID_", "CASE_EXECUTION_ID_", "CASE_INST_ID_", "CASE_DEF_ID_", "TASK_DEF_KEY_", "DESCRIPTION_", "DUE_DATE_", "FOLLOW_UP_DATE_", "SUSPENSION_STATE_", "TENANT_ID_"});
        int assigneeIndex = tableMetaData.getColumnNames().indexOf("ASSIGNEE_");
        int createTimeIndex = tableMetaData.getColumnNames().indexOf("CREATE_TIME_");
        Assertions.assertThat((assigneeIndex >= 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((createTimeIndex >= 0 ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((String)((String)tableMetaData.getColumnTypes().get(assigneeIndex))).isIn(new Object[]{"CHARACTER VARYING", "VARCHAR", "NVARCHAR2", "nvarchar", "NVARCHAR"});
        Assertions.assertThat((String)((String)tableMetaData.getColumnTypes().get(createTimeIndex))).isIn(new Object[]{"TIMESTAMP", "TIMESTAMP(6)", "datetime", "DATETIME", "DATETIME2"});
    }

    private void assertOneOf(String[] possibleValues, String currentValue) {
        for (String value : possibleValues) {
            if (!currentValue.equals(value)) continue;
            return;
        }
        Assert.fail((String)("Value '" + currentValue + "' should be one of: " + Arrays.deepToString(possibleValues)));
    }

    @Test
    public void testGetTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(20);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(0, 5);
        Assert.assertEquals((long)0L, (long)tablePage.getFirstResult());
        Assert.assertEquals((long)5L, (long)tablePage.getSize());
        Assert.assertEquals((long)5L, (long)tablePage.getRows().size());
        Assert.assertEquals((long)20L, (long)tablePage.getTotal());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").listPage(14, 10);
        Assert.assertEquals((long)14L, (long)tablePage.getFirstResult());
        Assert.assertEquals((long)6L, (long)tablePage.getSize());
        Assert.assertEquals((long)6L, (long)tablePage.getRows().size());
        Assert.assertEquals((long)20L, (long)tablePage.getTotal());
        this.taskService.deleteTasks(taskIds, true);
    }

    @Test
    public void testGetSortedTablePage() {
        String tablePrefix = this.processEngineConfiguration.getDatabaseTablePrefix();
        List<String> taskIds = this.generateDummyTasks(15);
        TablePage tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderAsc("NAME_").listPage(1, 7);
        String[] expectedTaskNames = new String[]{"B", "C", "D", "E", "F", "G", "H"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        tablePage = this.managementService.createTablePageQuery().tableName(tablePrefix + "ACT_RU_TASK").orderDesc("NAME_").listPage(6, 8);
        expectedTaskNames = new String[]{"I", "H", "G", "F", "E", "D", "C", "B"};
        this.verifyTaskNames(expectedTaskNames, tablePage.getRows());
        this.taskService.deleteTasks(taskIds, true);
    }

    @Test
    public void testFetchTelemetryConfiguration() {
        boolean expectedTelemetryValue = Boolean.parseBoolean(this.getTelemetryProperty(this.processEngineConfiguration).getValue());
        boolean actualTelemetryValue = this.managementService.isTelemetryEnabled();
        Assertions.assertThat((boolean)actualTelemetryValue).isEqualTo(expectedTelemetryValue);
    }

    @Test
    public void testTelemetryEnabled() {
        this.tearDownTelemetry = true;
        this.managementService.toggleTelemetry(true);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isTrue();
    }

    @Test
    public void testTelemetryDisabled() {
        this.tearDownTelemetry = true;
        this.managementService.toggleTelemetry(true);
        this.managementService.toggleTelemetry(false);
        Assertions.assertThat((Boolean)this.managementService.isTelemetryEnabled()).isFalse();
    }

    private void verifyTaskNames(String[] expectedTaskNames, List<Map<String, Object>> rowData) {
        Assert.assertEquals((long)expectedTaskNames.length, (long)rowData.size());
        String columnKey = "NAME_";
        for (int i = 0; i < expectedTaskNames.length; ++i) {
            Object o = rowData.get(i).get(columnKey);
            if (o == null) {
                o = rowData.get(i).get(columnKey.toLowerCase());
            }
            Assert.assertEquals((Object)expectedTaskNames[i], (Object)o);
        }
    }

    private List<String> generateDummyTasks(int nrOfTasks) {
        ArrayList<String> taskIds = new ArrayList<String>();
        for (int i = 0; i < nrOfTasks; ++i) {
            Task task = this.taskService.newTask();
            task.setName("" + (char)(65 + i));
            this.taskService.saveTask(task);
            taskIds.add(task.getId());
        }
        return taskIds;
    }

    protected PropertyEntity getTelemetryProperty(ProcessEngineConfigurationImpl configuration) {
        return (PropertyEntity)configuration.getCommandExecutorTxRequired().execute((Command)new Command<PropertyEntity>(){

            public PropertyEntity execute(CommandContext commandContext) {
                return commandContext.getPropertyManager().findPropertyById("camunda.telemetry.enabled");
            }
        });
    }
}

