/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.AuthorizationService;
import org.camunda.bpm.engine.CaseService;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.FilterService;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ProcessEngineConfiguration;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.filter.Filter;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.HistoricDecisionInstanceQuery;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.management.JobDefinition;
import org.camunda.bpm.engine.query.Query;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.runtime.Incident;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Attachment;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.migration.batch.BatchMigrationHelper;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MultiTenancyUserOperationLogTest {
    protected static final String USER_ID = "aUserId";
    protected static final String USER_WITHOUT_TENANT = "aUserId1";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String PROCESS_NAME = "process";
    protected static final String TASK_ID = "aTaskId";
    protected static final String AN_ANNOTATION = "anAnnotation";
    protected Date today = new Date(ClockUtil.getCurrentTime().getTime() / 1000L * 1000L);
    protected Date tomorrow = new Date((ClockUtil.getCurrentTime().getTime() + 86400000L) / 1000L * 1000L);
    protected Date yesterday = new Date((ClockUtil.getCurrentTime().getTime() - 86400000L) / 1000L * 1000L);
    protected Task userTask;
    protected static final BpmnModelInstance MODEL = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aTaskId").done();
    protected static final BpmnModelInstance MODEL_JOB = ((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask("aTaskId").camundaAsyncBefore()).done();
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected BatchMigrationHelper batchHelper = new BatchMigrationHelper(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ProcessEngineConfiguration configuration;
    protected TaskService taskService;
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    protected ManagementService managementService;
    protected boolean isDefaultTenantCheckEnabled;

    @Before
    public void init() {
        this.configuration = this.engineRule.getProcessEngineConfiguration();
        this.taskService = this.engineRule.getTaskService();
        this.historyService = this.engineRule.getHistoryService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        this.managementService = this.engineRule.getManagementService();
        this.isDefaultTenantCheckEnabled = this.configuration.isTenantCheckEnabled();
        this.configuration.setTenantCheckEnabled(false);
    }

    @After
    public void tearDown() {
        this.configuration.setTenantCheckEnabled(this.isDefaultTenantCheckEnabled);
    }

    @Test
    public void shouldLogUserOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Task").singleResult();
        this.historyService.setAnnotationForOperationLogById(singleResult.getOperationId(), AN_ANNOTATION);
        this.historyService.clearAnnotationForOperationLogById(singleResult.getOperationId());
        List list = this.historyService.createUserOperationLogQuery().entityType("OperationLog").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogIncidentOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        Incident incident = this.runtimeService.createIncident("foo", processInstance.getId(), TASK_ID, "bar");
        this.runtimeService.setAnnotationForIncidentById(incident.getId(), AN_ANNOTATION);
        this.runtimeService.clearAnnotationForIncidentById(incident.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Incident").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogIdentityLinkOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.taskService.addCandidateUser(processTaskId, "they");
        this.taskService.deleteCandidateUser(processTaskId, "they");
        this.taskService.addCandidateGroup(processTaskId, "we");
        this.taskService.deleteCandidateGroup(processTaskId, "we");
        List list = this.historyService.createUserOperationLogQuery().list();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"IdentityLink");
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogAttachmentOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        Attachment attachment = this.taskService.createAttachment("image/ico", processTaskId, process.getId(), "favicon.ico", "favicon", "http://camunda.com/favicon.ico");
        this.taskService.deleteAttachment(attachment.getId());
        List list = this.historyService.createUserOperationLogQuery().list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"Attachment");
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogTaskOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        String processTaskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        ClockUtil.setCurrentTime((Date)this.today);
        this.taskService.setOwner(processTaskId, "icke");
        this.taskService.claim(processTaskId, "icke");
        this.taskService.setAssignee(processTaskId, "er");
        this.taskService.setPriority(processTaskId, 10);
        this.taskService.complete(processTaskId);
        List list = this.historyService.createUserOperationLogQuery().list();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getEntityType()).isEqualTo((Object)"Task");
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogStandaloneTaskOperationsWithTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.userTask = this.taskService.newTask();
        this.userTask.setName("to do");
        this.userTask.setTenantId(TENANT_ONE);
        this.taskService.saveTask(this.userTask);
        ClockUtil.setCurrentTime((Date)this.tomorrow);
        this.userTask.setDescription("desc");
        this.userTask.setOwner("icke");
        this.userTask.setAssignee("er");
        this.userTask.setDueDate(new Date());
        this.taskService.saveTask(this.userTask);
        this.taskService.complete(this.userTask.getId());
        this.historyService.deleteHistoricTaskInstance(this.userTask.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Task").list();
        Assertions.assertThat((int)list.size()).isEqualTo(8);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogJobDefinitionOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL_JOB);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        JobDefinition jobDefinition = (JobDefinition)this.managementService.createJobDefinitionQuery().singleResult();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.managementService.setOverridingJobPriorityForJobDefinition(jobDefinition.getId(), 42L);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("JobDefinition").operationType("SetPriority").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldLogJobOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL_JOB);
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.managementService.setJobRetries(job.getId(), 4);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().entityType("Job").operationType("SetJobRetries").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldLogProcessInstanceOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.runtimeService.suspendProcessInstanceById(process.getId());
        this.runtimeService.activateProcessInstanceById(process.getId());
        this.runtimeService.deleteProcessInstance(process.getId(), "a delete reason");
        List list = this.historyService.createUserOperationLogQuery().entityType("ProcessInstance").list();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogProcessDefinitionOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        ProcessDefinition definition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult();
        this.repositoryService.updateProcessDefinitionHistoryTimeToLive(definition.getId(), Integer.valueOf(5));
        this.repositoryService.deleteProcessDefinition(definition.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("ProcessDefinition").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogVariableOperationsWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.setVariable(process.getId(), "myVariable", (Object)10);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetVariable").entityType("Variable").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldLogDeployOperationWithTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        String deploymentId = this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml").getId();
        this.repositoryService.deleteDeployment(deploymentId);
        List list = this.historyService.createUserOperationLogQuery().entityType("Deployment").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogBatchOperationWithTenant() {
        Batch batch = this.batchHelper.migrateProcessInstanceAsync(this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS), this.testRule.deployForTenantAndGetDefinition(TENANT_ONE, ProcessModels.ONE_TASK_PROCESS));
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.managementService.suspendBatchById(batch.getId());
        this.managementService.deleteBatch(batch.getId(), true);
        List list = this.historyService.createUserOperationLogQuery().entityType("Batch").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogExternalTaskOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey("twoExternalTaskWithPriorityProcess", Collections.singletonMap("priority", 14));
        ExternalTaskService externalTaskService = this.engineRule.getExternalTaskService();
        ExternalTask externalTask = (ExternalTask)externalTaskService.createExternalTaskQuery().priorityHigherThanOrEquals(1L).singleResult();
        externalTaskService.setPriority(externalTask.getId(), 78L);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetPriority").entityType("ExternalTask").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldLogDecisionDefinitionOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        DecisionDefinition decisionDefinition = (DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().singleResult();
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(decisionDefinition.getId(), Integer.valueOf(6));
        List list = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("DecisionDefinition").list();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogDecisionInstanceOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.engineRule.getDecisionService().evaluateDecisionByKey("decision").variables((Map)Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723)).evaluate();
        String instanceId = ((HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult()).getId();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(instanceId);
        List list = this.historyService.createUserOperationLogQuery().entityType("DecisionInstance").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogDecisionInstancesOperationWithoutTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.engineRule.getDecisionService().evaluateDecisionByKey("decision").variables((Map)Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723)).evaluate();
        HistoricDecisionInstanceQuery historicDecisionInstanceQuery = this.historyService.createHistoricDecisionInstanceQuery();
        Batch batch = this.historyService.setRemovalTimeToHistoricDecisionInstances().clearedRemovalTime().byQuery(historicDecisionInstanceQuery).executeAsync();
        this.managementService.deleteBatch(batch.getId(), true);
        List list = this.historyService.createUserOperationLogQuery().entityType("DecisionInstance").list();
        Assertions.assertThat((int)list.size()).isEqualTo(5);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }

    @Test
    public void shouldLogCaseDefinitionOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        this.repositoryService.updateCaseDefinitionHistoryTimeToLive(caseDefinition.getId(), Integer.valueOf(6));
        List list = this.historyService.createUserOperationLogQuery().operationType("UpdateHistoryTimeToLive").entityType("CaseDefinition").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)TENANT_ONE);
        }
    }

    @Test
    public void shouldLogCaseInstanceOperationWithTenant() {
        this.testRule.deployForTenant(TENANT_ONE, "org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn");
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        CaseDefinition caseDefinition = (CaseDefinition)this.repositoryService.createCaseDefinitionQuery().singleResult();
        CaseService caseService = this.engineRule.getCaseService();
        String caseInstanceId = caseService.withCaseDefinition(caseDefinition.getId()).create().getId();
        String caseExecutionId = ((CaseExecution)caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        caseService.withCaseExecution(caseExecutionId).complete();
        caseService.withCaseExecution(caseInstanceId).close();
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").entityType("CaseInstance").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void shouldLogMetricsOperationWithoutTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.managementService.deleteTaskMetrics(null);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Delete").entityType("TaskMetrics").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo(null);
    }

    @Test
    public void shouldLogTaskMetricsOperationWithoutTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.runtimeService.startProcessInstanceByKey(PROCESS_NAME);
        this.managementService.deleteMetrics(null);
        UserOperationLogEntry singleResult = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Delete").entityType("Metrics").singleResult();
        Assertions.assertThat((String)singleResult.getTenantId()).isEqualTo(null);
    }

    @Test
    public void shouldLogFilterOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        FilterService filterService = this.engineRule.getFilterService();
        Filter filter = filterService.newTaskFilter().setName("name").setOwner("owner").setQuery((Query)this.taskService.createTaskQuery()).setProperties(new HashMap());
        filterService.saveFilter(filter);
        filter.setName(filter.getName() + "_new");
        filterService.saveFilter(filter);
        filterService.deleteFilter(filter.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Filter").list();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }

    @Test
    public void shouldLogUserOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        User newUser = this.identityService.newUser("test");
        this.identityService.saveUser(newUser);
        newUser.setEmail("test@mail.com");
        this.identityService.saveUser(newUser);
        this.identityService.deleteUser(newUser.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("User").list();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }

    @Test
    public void shouldLogGroupOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        Group newGroup = this.identityService.newGroup("test");
        this.identityService.saveGroup(newGroup);
        newGroup.setName("testName");
        this.identityService.saveGroup(newGroup);
        this.identityService.deleteGroup(newGroup.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Group").list();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }

    @Test
    public void shouldLogTenantOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        Tenant newTenant = this.identityService.newTenant("test");
        this.identityService.saveTenant(newTenant);
        newTenant.setName("testName");
        this.identityService.saveTenant(newTenant);
        this.identityService.deleteTenant(newTenant.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Tenant").list();
        Assertions.assertThat((int)list.size()).isEqualTo(3);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)"test");
        }
    }

    @Test
    public void shouldLogGroupMemebershipOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.identityService.saveUser(this.identityService.newUser("testUser"));
        this.identityService.saveGroup(this.identityService.newGroup("testGroup"));
        this.identityService.createMembership("testUser", "testGroup");
        this.identityService.deleteMembership("testUser", "testGroup");
        List list = this.historyService.createUserOperationLogQuery().entityType("Group membership").list();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
        this.identityService.deleteUser("testUser");
        this.identityService.deleteGroup("testGroup");
    }

    @Test
    public void shouldLogTenantMemebershipOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.identityService.saveUser(this.identityService.newUser("testUser"));
        this.identityService.saveTenant(this.identityService.newTenant("testTenant"));
        this.identityService.createTenantUserMembership("testTenant", "testUser");
        this.identityService.deleteTenantUserMembership("testTenant", "testUser");
        List list = this.historyService.createUserOperationLogQuery().entityType("TenantMembership").list();
        Assertions.assertThat((int)list.size()).isEqualTo(4);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo((Object)"testTenant");
        }
        this.identityService.deleteUser("testUser");
        this.identityService.deleteTenant("testTenant");
    }

    @Test
    public void shouldLogAuthorizationOperationsWithoutTenant() {
        this.testRule.deployForTenant(TENANT_ONE, MODEL);
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROCESS_NAME).getId();
        AuthorizationService authorizationService = this.engineRule.getAuthorizationService();
        Authorization authorization = authorizationService.createNewAuthorization(1);
        authorization.setUserId("myUserId");
        authorization.setResource((Resource)Resources.HISTORIC_PROCESS_INSTANCE);
        authorization.setResourceId(processInstanceId);
        authorizationService.saveAuthorization(authorization);
        authorizationService.deleteAuthorization(authorization.getId());
        List list = this.historyService.createUserOperationLogQuery().entityType("Authorization").list();
        Assertions.assertThat((int)list.size()).isEqualTo(12);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }

    @Test
    public void shouldLogPropertyOperationsWithoutTenant() {
        this.identityService.setAuthentication(USER_ID, null, Arrays.asList(TENANT_ONE));
        this.managementService.setProperty("testProperty", "testValue");
        this.managementService.deleteProperty("testProperty");
        List list = this.historyService.createUserOperationLogQuery().entityType("Property").list();
        Assertions.assertThat((int)list.size()).isEqualTo(2);
        for (UserOperationLogEntry userOperationLogEntry : list) {
            Assertions.assertThat((String)userOperationLogEntry.getTenantId()).isEqualTo(null);
        }
    }
}

