/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.repository;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.dmn.engine.impl.transform.DmnTransformException;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.ParseException;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.CaseDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class HistoryTimeToLiveDeploymentTest {
    protected static final String CONFIG_LOGGER = "org.camunda.bpm.engine.cfg";
    protected static final String EXPECTED_DEFAULT_CONFIG_MSG = "You are using the default TTL (Time To Live) of 180 days (six months); the history clean-up feature will delete your data after six months. We recommend adjusting the TTL configuration property aligned with your specific requirements.";
    protected static final String DEFAULT_HTTL_CONFIG_VALUE = "180";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().watch(new String[]{"org.camunda.bpm.engine.cfg"}).level(Level.DEBUG);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RepositoryService repositoryService;
    protected ManagementService managementService;
    protected ProcessEngine processEngine;
    protected String historyTimeToLive;

    @Before
    public void setUp() throws Exception {
        this.processEngine = this.engineRule.getProcessEngine();
        this.processEngineConfiguration = this.engineRule.getProcessEngineConfiguration();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.managementService = this.engineRule.getManagementService();
        this.historyTimeToLive = this.processEngineConfiguration.getHistoryTimeToLive();
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
    }

    @After
    public void tearDown() throws Exception {
        this.processEngineConfiguration.setHistoryTimeToLive(this.historyTimeToLive);
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        ClockUtil.reset();
    }

    @Test
    public void processWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml"))).isInstanceOf(ParseException.class)).hasMessageContaining("History Time To Live cannot be null");
    }

    @Test
    public void processWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version3.bpmn20.xml"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void caseWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCaseWithHistoryTimeToLive.cmmn"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void caseWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"))).isInstanceOf(ProcessEngineException.class)).hasCauseInstanceOf(NotValidException.class).hasStackTraceContaining("History Time To Live cannot be null");
    }

    @Test
    public void decisionWithHTTLShouldSucceed() {
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/dmn/Example.dmn"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void decisionWithoutHTTLShouldFail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn"))).isInstanceOf(ProcessEngineException.class)).hasCauseInstanceOf(DmnTransformException.class).hasStackTraceContaining("History Time To Live cannot be null");
    }

    @Test
    public void shouldDeploySuccessfullyDueToProcessEngineConfigFallback() {
        this.processEngineConfiguration.setHistoryTimeToLive("5");
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        Deployment deployment = (Deployment)this.repositoryService.createDeploymentQuery().singleResult();
        Assertions.assertThat((Object)deployment).isNotNull();
    }

    @Test
    public void shouldNotLogMessageOnDefaultConfigOriginatingFromConfig() {
        this.processEngineConfiguration.setHistoryTimeToLive(DEFAULT_HTTL_CONFIG_VALUE);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(EXPECTED_DEFAULT_CONFIG_MSG)).hasSize(0);
    }

    @Test
    public void shouldLogMessageOnDefaultValueOfProcessModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version3.bpmn20.xml"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: process; You are using the default TTL (Time To Live) of 180 days (six months); the history clean-up feature will delete your data after six months. We recommend adjusting the TTL configuration property aligned with your specific requirements.")).hasSize(1);
    }

    @Test
    public void shouldLogMessageOnDefaultValueOfCaseModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/case_with_180_httl.cmmn"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: testCase; You are using the default TTL (Time To Live) of 180 days (six months); the history clean-up feature will delete your data after six months. We recommend adjusting the TTL configuration property aligned with your specific requirements.")).hasSize(1);
    }

    @Test
    public void shouldLogMessageOnDefaultValueOfDecisionModel() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/decision_with_180_httl.dmn"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog("definitionKey: testDecision; You are using the default TTL (Time To Live) of 180 days (six months); the history clean-up feature will delete your data after six months. We recommend adjusting the TTL configuration property aligned with your specific requirements.")).hasSize(1);
    }

    @Test
    public void shouldNotLogAnyMessageOnNonDefaultConfig() {
        String nonDefaultValue = "179";
        this.processEngineConfiguration.setHistoryTimeToLive(nonDefaultValue);
        this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        Assertions.assertThat((List)this.loggingRule.getFilteredLog(EXPECTED_DEFAULT_CONFIG_MSG)).hasSize(0);
    }

    @Test
    public void shouldGetDeployedProcess() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/repository/version1.bpmn20.xml"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getProcessDefinition(((ProcessDefinition)definitions.getDeployedProcessDefinitions().get(0)).getId());
    }

    @Test
    public void shouldGetDeployedDecision() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getDecisionDefinition(((DecisionDefinition)definitions.getDeployedDecisionDefinitions().get(0)).getId());
    }

    @Test
    public void shouldGetDeployedCase() {
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(false);
        Object definitions = this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/cmmn/oneTaskCase2.cmmn"));
        this.processEngineConfiguration.setEnforceHistoryTimeToLive(true);
        this.processEngineConfiguration.getDeploymentCache().purgeCache();
        this.repositoryService.getCaseDefinition(((CaseDefinition)definitions.getDeployedCaseDefinitions().get(0)).getId());
    }
}

