/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history;

import java.util.Date;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.exception.NotValidException;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReport;
import org.camunda.bpm.engine.history.CleanableHistoricDecisionInstanceReportResult;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class CleanableHistoricDecisionInstanceReportTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.testRule).around((TestRule)this.engineRule);
    protected HistoryService historyService;
    protected RepositoryService repositoryService;
    protected static final String DECISION_DEFINITION_KEY = "one";
    protected static final String SECOND_DECISION_DEFINITION_KEY = "two";
    protected static final String THIRD_DECISION_DEFINITION_KEY = "anotherDecision";
    protected static final String FOURTH_DECISION_DEFINITION_KEY = "decision";

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.repositoryService = this.engineRule.getRepositoryService();
        this.testRule.deploy("org/camunda/bpm/engine/test/repository/one.dmn");
    }

    @After
    public void cleanUp() {
        List historicDecisionInstances = this.historyService.createHistoricDecisionInstanceQuery().list();
        for (HistoricDecisionInstance historicDecisionInstance : historicDecisionInstances) {
            this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        }
    }

    protected void prepareDecisionInstances(String key, int daysInThePast, Integer historyTimeToLive, int instanceCount) {
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(key).list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        this.repositoryService.updateDecisionDefinitionHistoryTimeToLive(((DecisionDefinition)decisionDefinitions.get(0)).getId(), historyTimeToLive);
        Date oldCurrentTime = ClockUtil.getCurrentTime();
        ClockUtil.setCurrentTime((Date)DateUtils.addDays((Date)oldCurrentTime, (int)daysInThePast));
        VariableMap variables = Variables.createVariables().putValue("status", (Object)"silver").putValue("sum", (Object)723);
        for (int i = 0; i < instanceCount; ++i) {
            this.engineRule.getDecisionService().evaluateDecisionByKey(key).variables((Map)variables).evaluate();
        }
        ClockUtil.setCurrentTime((Date)oldCurrentTime);
    }

    @Test
    public void testReportComplex() {
        this.testRule.deploy("org/camunda/bpm/engine/test/repository/two.dmn", "org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn", "org/camunda/bpm/engine/test/api/dmn/Example.dmn");
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, 0, 5, 10);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        this.prepareDecisionInstances(SECOND_DECISION_DEFINITION_KEY, -6, null, 10);
        this.prepareDecisionInstances(THIRD_DECISION_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        String secondDecisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(SECOND_DECISION_DEFINITION_KEY).singleResult()).getId();
        CleanableHistoricDecisionInstanceReportResult secondReportResult = (CleanableHistoricDecisionInstanceReportResult)this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionIdIn(new String[]{secondDecisionDefinitionId}).singleResult();
        CleanableHistoricDecisionInstanceReportResult thirdReportResult = (CleanableHistoricDecisionInstanceReportResult)this.historyService.createCleanableHistoricDecisionInstanceReport().decisionDefinitionKeyIn(new String[]{THIRD_DECISION_DEFINITION_KEY}).singleResult();
        Assert.assertEquals((long)4L, (long)reportResults.size());
        for (CleanableHistoricDecisionInstanceReportResult result : reportResults) {
            if (result.getDecisionDefinitionKey().equals(DECISION_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 20);
                continue;
            }
            if (result.getDecisionDefinitionKey().equals(SECOND_DECISION_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 0, 10);
                continue;
            }
            if (result.getDecisionDefinitionKey().equals(THIRD_DECISION_DEFINITION_KEY)) {
                this.checkResultNumbers(result, 10, 10);
                continue;
            }
            if (!result.getDecisionDefinitionKey().equals(FOURTH_DECISION_DEFINITION_KEY)) continue;
            this.checkResultNumbers(result, 0, 0);
        }
        this.checkResultNumbers(secondReportResult, 0, 10);
        this.checkResultNumbers(thirdReportResult, 10, 10);
    }

    private void checkResultNumbers(CleanableHistoricDecisionInstanceReportResult result, int expectedCleanable, int expectedFinished) {
        Assert.assertEquals((long)expectedCleanable, (long)result.getCleanableDecisionInstanceCount());
        Assert.assertEquals((long)expectedFinished, (long)result.getFinishedDecisionInstanceCount());
    }

    @Test
    public void testReportWithAllCleanableInstances() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 10);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        long count = this.historyService.createCleanableHistoricDecisionInstanceReport().count();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        Assert.assertEquals((long)1L, (long)count);
        this.checkResultNumbers((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithPartiallyCleanableInstances() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 5);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, 0, 5, 5);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0), 5, 10);
    }

    @Test
    public void testReportWithZeroHistoryTTL() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 0, 5);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, 0, 0, 5);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0), 10, 10);
    }

    @Test
    public void testReportWithNullHistoryTTL() {
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, null, 5);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, 0, null, 5);
        List reportResults = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)reportResults.size());
        this.checkResultNumbers((CleanableHistoricDecisionInstanceReportResult)reportResults.get(0), 0, 10);
    }

    @Test
    public void testReportByInvalidDecisionDefinitionId() {
        CleanableHistoricDecisionInstanceReport report = this.historyService.createCleanableHistoricDecisionInstanceReport();
        try {
            report.decisionDefinitionIdIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.decisionDefinitionIdIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportByInvalidDecisionDefinitionKey() {
        CleanableHistoricDecisionInstanceReport report = this.historyService.createCleanableHistoricDecisionInstanceReport();
        try {
            report.decisionDefinitionKeyIn(null);
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
        try {
            report.decisionDefinitionKeyIn(new String[]{"abc", null, "def"});
            TestCase.fail((String)"Expected NotValidException");
        }
        catch (NotValidException notValidException) {
            // empty catch block
        }
    }

    @Test
    public void testReportCompact() {
        List decisionDefinitions = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).list();
        Assert.assertEquals((long)1L, (long)decisionDefinitions.size());
        List resultWithZeros = this.historyService.createCleanableHistoricDecisionInstanceReport().list();
        Assert.assertEquals((long)1L, (long)resultWithZeros.size());
        Assert.assertEquals((long)0L, (long)((CleanableHistoricDecisionInstanceReportResult)resultWithZeros.get(0)).getFinishedDecisionInstanceCount());
        long resultCountWithoutZeros = this.historyService.createCleanableHistoricDecisionInstanceReport().compact().count();
        Assert.assertEquals((long)0L, (long)resultCountWithoutZeros);
    }

    @Test
    public void testReportOrderByFinishedAsc() {
        this.testRule.deploy("org/camunda/bpm/engine/test/repository/two.dmn", "org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn");
        this.prepareDecisionInstances(SECOND_DECISION_DEFINITION_KEY, -6, 5, 6);
        this.prepareDecisionInstances(THIRD_DECISION_DEFINITION_KEY, -6, 5, 8);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 4);
        List reportResult = ((CleanableHistoricDecisionInstanceReport)this.historyService.createCleanableHistoricDecisionInstanceReport().orderByFinished().asc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(0)).getDecisionDefinitionKey());
        Assert.assertEquals((Object)SECOND_DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(1)).getDecisionDefinitionKey());
        Assert.assertEquals((Object)THIRD_DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(2)).getDecisionDefinitionKey());
    }

    @Test
    public void testReportOrderByFinishedDesc() {
        this.testRule.deploy("org/camunda/bpm/engine/test/repository/two.dmn", "org/camunda/bpm/engine/test/api/dmn/Another_Example.dmn");
        this.prepareDecisionInstances(SECOND_DECISION_DEFINITION_KEY, -6, 5, 6);
        this.prepareDecisionInstances(THIRD_DECISION_DEFINITION_KEY, -6, 5, 8);
        this.prepareDecisionInstances(DECISION_DEFINITION_KEY, -6, 5, 4);
        List reportResult = ((CleanableHistoricDecisionInstanceReport)this.historyService.createCleanableHistoricDecisionInstanceReport().orderByFinished().desc()).list();
        Assert.assertEquals((long)3L, (long)reportResult.size());
        Assert.assertEquals((Object)THIRD_DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(0)).getDecisionDefinitionKey());
        Assert.assertEquals((Object)SECOND_DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(1)).getDecisionDefinitionKey());
        Assert.assertEquals((Object)DECISION_DEFINITION_KEY, (Object)((CleanableHistoricDecisionInstanceReportResult)reportResult.get(2)).getDecisionDefinitionKey());
    }
}

