/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.standalone.scripting;

import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.scripting.ExecutableScript;
import org.camunda.bpm.engine.impl.scripting.ScriptFactory;
import org.camunda.bpm.engine.impl.scripting.SourceExecutableScript;
import org.camunda.bpm.engine.impl.scripting.env.ScriptingEnvironment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScriptCompilationTest
extends PluggableProcessEngineTest {
    protected static final String SCRIPT_LANGUAGE = "groovy";
    protected static final String EXAMPLE_SCRIPT = "println 'hello world'";
    protected ScriptFactory scriptFactory;

    @Before
    public void setUp() {
        this.scriptFactory = this.processEngineConfiguration.getScriptFactory();
    }

    protected SourceExecutableScript createScript(String language, String source) {
        return (SourceExecutableScript)this.scriptFactory.createScriptFromSource(language, source);
    }

    @Test
    public void testScriptShouldBeCompiledByDefault() {
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        Assert.assertNotNull((Object)script);
        Assert.assertTrue((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        Assert.assertFalse((boolean)script.isShouldBeCompiled());
        Assert.assertNotNull((Object)script.getCompiledScript());
    }

    @Test
    public void testDisableScriptCompilation() {
        this.processEngineConfiguration.setEnableScriptCompilation(false);
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        Assert.assertNotNull((Object)script);
        Assert.assertTrue((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        Assert.assertFalse((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.processEngineConfiguration.setEnableScriptCompilation(true);
    }

    @Test
    public void testDisableScriptCompilationByDisabledScriptEngineCaching() {
        this.processEngineConfiguration.setEnableScriptEngineCaching(false);
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        Assert.assertNotNull((Object)script);
        Assert.assertTrue((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        Assert.assertFalse((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.processEngineConfiguration.setEnableScriptEngineCaching(true);
    }

    @Test
    public void testOverrideScriptSource() {
        SourceExecutableScript script = this.createScript(SCRIPT_LANGUAGE, EXAMPLE_SCRIPT);
        Assert.assertNotNull((Object)script);
        this.executeScript((ExecutableScript)script);
        Assert.assertFalse((boolean)script.isShouldBeCompiled());
        Assert.assertNotNull((Object)script.getCompiledScript());
        script.setScriptSource(EXAMPLE_SCRIPT);
        Assert.assertTrue((boolean)script.isShouldBeCompiled());
        Assert.assertNull((Object)script.getCompiledScript());
        this.executeScript((ExecutableScript)script);
        Assert.assertFalse((boolean)script.isShouldBeCompiled());
        Assert.assertNotNull((Object)script.getCompiledScript());
    }

    protected Object executeScript(final ExecutableScript script) {
        final ScriptingEnvironment scriptingEnvironment = this.processEngineConfiguration.getScriptingEnvironment();
        return this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                return scriptingEnvironment.execute(script, null);
            }
        });
    }
}

