/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.util;

import java.sql.SQLException;
import org.apache.ibatis.exceptions.PersistenceException;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.util.ExceptionUtil;
import org.junit.Test;
import org.mockito.Mockito;

public class ExceptionUtilTest {
    @Test
    public void checkValueTooLongException() {
        Assertions.assertThat((boolean)ExceptionUtil.checkValueTooLongException((SQLException)((SQLException)Mockito.mock(SQLException.class)))).isFalse();
        SQLException tooLong = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"too long").when((Object)tooLong)).getMessage();
        Assertions.assertThat((boolean)ExceptionUtil.checkValueTooLongException((SQLException)tooLong)).isTrue();
    }

    @Test
    public void checkConstraintViolationException() {
        Assertions.assertThat((boolean)ExceptionUtil.checkConstraintViolationException((ProcessEngineException)new ProcessEngineException((Throwable)new PersistenceException((Throwable)Mockito.mock(SQLException.class))))).isFalse();
        SQLException constraintViolation = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"ora-00001").when((Object)constraintViolation)).getMessage();
        Assertions.assertThat((boolean)ExceptionUtil.checkConstraintViolationException((ProcessEngineException)new ProcessEngineException((Throwable)new PersistenceException((Throwable)constraintViolation)))).isTrue();
    }

    @Test
    public void checkForeignKeyConstraintViolation() {
        Assertions.assertThat((boolean)ExceptionUtil.checkForeignKeyConstraintViolation((SQLException)((SQLException)Mockito.mock(SQLException.class)))).isFalse();
        SQLException constraintViolation = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"integrity constraint").when((Object)constraintViolation)).getMessage();
        Assertions.assertThat((boolean)ExceptionUtil.checkForeignKeyConstraintViolation((SQLException)constraintViolation)).isTrue();
    }

    @Test
    public void checkVariableIntegrityViolation() {
        Assertions.assertThat((boolean)ExceptionUtil.checkVariableIntegrityViolation((PersistenceException)new PersistenceException((Throwable)Mockito.mock(SQLException.class)))).isFalse();
        SQLException integrityViolation = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"act_uniq_variable").when((Object)integrityViolation)).getMessage();
        ((SQLException)Mockito.doReturn((Object)"23505").when((Object)integrityViolation)).getSQLState();
        Assertions.assertThat((boolean)ExceptionUtil.checkVariableIntegrityViolation((PersistenceException)new PersistenceException((Throwable)integrityViolation))).isTrue();
    }

    @Test
    public void checkCrdbTransactionRetryException() {
        Assertions.assertThat((boolean)ExceptionUtil.checkCrdbTransactionRetryException((SQLException)((SQLException)Mockito.mock(SQLException.class)))).isFalse();
        SQLException retry = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"restart transaction").when((Object)retry)).getMessage();
        ((SQLException)Mockito.doReturn((Object)40001).when((Object)retry)).getErrorCode();
        Assertions.assertThat((boolean)ExceptionUtil.checkCrdbTransactionRetryException((SQLException)retry)).isTrue();
    }

    @Test
    public void checkDeadlockException() {
        Assertions.assertThat((boolean)ExceptionUtil.checkDeadlockException((SQLException)((SQLException)Mockito.mock(SQLException.class)))).isFalse();
        SQLException deadlock = (SQLException)Mockito.mock(SQLException.class);
        ((SQLException)Mockito.doReturn((Object)"40P01").when((Object)deadlock)).getSQLState();
        Assertions.assertThat((boolean)ExceptionUtil.checkDeadlockException((SQLException)deadlock)).isTrue();
    }
}

