/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@RequiredHistoryLevel(value="full")
public class DeleteHistoricBatchAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected MigrationPlan migrationPlan;
    protected Batch batch;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.DELETE_HISTORY})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.DELETE_HISTORY})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @Before
    public void deployProcessesAndCreateMigrationPlan() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).build();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void deleteBatch() {
        this.engineRule.getManagementService().deleteBatch(this.batch.getId(), true);
    }

    @Test
    public void testDeleteBatch() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(this.migrationPlan.getSourceProcessDefinitionId());
        this.batch = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", this.batch.getId()).start();
        this.engineRule.getHistoryService().deleteHistoricBatch(this.batch.getId());
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricBatchQuery().count());
            List userOperationLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().operationType("DeleteHistory").list();
            Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
            UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
            Assert.assertNull((Object)entry.getProperty());
            Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
        }
    }
}

