/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstantiationBuilder;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.BusinessRuleTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MultiTenancyBusinessRuleTaskTest
extends PluggableProcessEngineTest {
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected static final String DMN_FILE = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String DMN_FILE_VERSION_TWO = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable_v2.dmn";
    protected static final String RESULT_OF_VERSION_ONE = "A";
    protected static final String RESULT_OF_VERSION_TWO = "C";
    public static final String DMN_FILE_VERSION_TAG = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionVersionTagOkay.dmn11.xml";
    public static final String DMN_FILE_VERSION_TAG_TWO = "org/camunda/bpm/engine/test/dmn/businessruletask/DmnBusinessRuleTaskTest.testDecisionVersionTagOkay_v2.dmn11.xml";
    protected static final String RESULT_OF_VERSION_TAG_ONE = "A";
    protected static final String RESULT_OF_VERSION_TAG_TWO = "C";

    @Test
    public void testEvaluateDecisionWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, process, DMN_FILE_VERSION_TWO);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar"))).isEqualTo((Object)"C");
    }

    @Test
    public void testEvaluateDecisionWithLatestBindingSameVersion() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, process, DMN_FILE_VERSION_TWO);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar"))).isEqualTo((Object)"C");
    }

    @Test
    public void testEvaluateDecisionWithLatestBindingDifferentVersions() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar"))).isEqualTo((Object)"C");
    }

    @Test
    public void testEvaluateDecisionWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("1")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE_VERSION_TWO);
        this.testRule.deployForTenant(TENANT_TWO, process, DMN_FILE_VERSION_TWO);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar"))).isEqualTo((Object)"C");
    }

    @Test
    public void testEvaluateDecisionWithVersionTagBinding() {
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE_VERSION_TAG);
        this.testRule.deploy(((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefTenantId(TENANT_ONE)).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).endEvent().camundaAsyncBefore()).done());
        ProcessInstance processInstance = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstance.getId(), "decisionVar"))).isEqualTo((Object)"A");
    }

    @Test
    public void testEvaluateDecisionWithVersionTagBinding_ResolveTenantFromDefinition() {
        BpmnModelInstance process = ((EndEventBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).endEvent().camundaAsyncBefore()).done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE_VERSION_TAG);
        this.testRule.deployForTenant(TENANT_TWO, process, DMN_FILE_VERSION_TAG_TWO);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_ONE).execute();
        ProcessInstance processInstanceTwo = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).processDefinitionTenantId(TENANT_TWO).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceTwo.getId(), "decisionVar"))).isEqualTo((Object)"C");
    }

    @Test
    public void testFailEvaluateDecisionFromOtherTenantWithDeploymentBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("deployment")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key = 'decision'"});
        }
    }

    @Test
    public void testFailEvaluateDecisionFromOtherTenantWithLatestBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key 'decision'"});
        }
    }

    @Test
    public void testFailEvaluateDecisionFromOtherTenantWithVersionBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("version")).camundaDecisionRefVersion("2")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE);
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key = 'decision', version = '2' and tenant-id 'tenant1'"});
        }
    }

    @Test
    public void testFailEvaluateDecisionFromOtherTenantWithVersionTagBinding() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("versionTag")).camundaDecisionRefVersionTag("0.0.2")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("result")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TAG);
        try {
            this.runtimeService.createProcessInstanceByKey("process").processDefinitionTenantId(TENANT_ONE).execute();
            Assert.fail((String)"expected exception");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"no decision definition deployed with key = 'decision', versionTag = '0.0.2' and tenant-id 'tenant1': decisionDefinition is null"});
        }
    }

    @Test
    public void testEvaluateDecisionTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId(TENANT_ONE)).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO);
        this.testRule.deploy(process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
    }

    @Test
    public void testEvaluateDecisionWithoutTenantIdConstant() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${null}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deploy(DMN_FILE);
        this.testRule.deployForTenant(TENANT_ONE, process);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
    }

    @Test
    public void testEvaluateDecisionTenantIdExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("${'tenant1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO);
        this.testRule.deploy(process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
    }

    @Test
    public void testEvaluateDecisionTenantIdCompositeExpression() {
        BpmnModelInstance process = ((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)((BusinessRuleTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().businessRuleTask().camundaDecisionRef("decision")).camundaDecisionRefBinding("latest")).camundaDecisionRefTenantId("tenant${'1'}")).camundaMapDecisionResult("singleEntry")).camundaResultVariable("decisionVar")).camundaAsyncAfter()).endEvent().done();
        this.testRule.deployForTenant(TENANT_ONE, DMN_FILE);
        this.testRule.deployForTenant(TENANT_TWO, DMN_FILE_VERSION_TWO);
        this.testRule.deploy(process);
        ProcessInstance processInstanceOne = ((ProcessInstantiationBuilder)this.runtimeService.createProcessInstanceByKey("process").setVariable("status", (Object)"gold")).execute();
        Assertions.assertThat((String)((String)this.runtimeService.getVariable(processInstanceOne.getId(), "decisionVar"))).isEqualTo((Object)"A");
    }
}

