/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.runtime;

import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ProcessInstanceQueryByLeafInstancesTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected RuntimeService runtimeService;

    @Before
    public void init() {
        this.runtimeService = this.engineRule.getRuntimeService();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/superProcessWithNestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesThreeLayers() {
        ProcessInstance threeLayerProcess = this.runtimeService.startProcessInstanceByKey("nestedSubProcessQueryTest");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(3L);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSubProcessQueryTest").count()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSimpleSubProcess").count()).isEqualTo(1L);
        Assertions.assertThat((long)simpleSubProcessQuery.count()).isEqualTo(1L);
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assertions.assertThat((String)instance.getRootProcessInstanceId()).isEqualTo((Object)threeLayerProcess.getId());
        Assertions.assertThat((String)instance.getId()).isEqualTo((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/nestedSubProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesTwoLayers() {
        ProcessInstance twoLayerProcess = this.runtimeService.startProcessInstanceByKey("nestedSimpleSubProcess");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(2L);
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().processDefinitionKey("nestedSimpleSubProcess").count()).isEqualTo(1L);
        Assertions.assertThat((long)simpleSubProcessQuery.count()).isEqualTo(1L);
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assertions.assertThat((String)instance.getRootProcessInstanceId()).isEqualTo((Object)twoLayerProcess.getId());
        Assertions.assertThat((String)instance.getId()).isEqualTo((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId());
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/runtime/subProcess.bpmn20.xml"})
    public void testQueryByLeafInstancesOneLayer() {
        ProcessInstance process = this.runtimeService.startProcessInstanceByKey("simpleSubProcess");
        ProcessInstanceQuery simpleSubProcessQuery = this.runtimeService.createProcessInstanceQuery().processDefinitionKey("simpleSubProcess");
        Assertions.assertThat((long)this.runtimeService.createProcessInstanceQuery().count()).isEqualTo(1L);
        Assertions.assertThat((long)simpleSubProcessQuery.count()).isEqualTo(1L);
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().leafProcessInstances().singleResult();
        Assertions.assertThat((String)instance.getRootProcessInstanceId()).isEqualTo((Object)process.getId());
        Assertions.assertThat((String)instance.getId()).isEqualTo((Object)((ProcessInstance)simpleSubProcessQuery.singleResult()).getId());
    }
}

