/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.OptimisticLockingException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.TaskService;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.cmd.CompleteTaskCmd;
import org.camunda.bpm.engine.impl.errorcode.BuiltinExceptionCode;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.concurrency.ControllableThread;
import org.camunda.bpm.engine.test.concurrency.ControlledCommand;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.junit.After;
import org.junit.Test;
import org.slf4j.Logger;

public abstract class AbstractCompetingTransactionsOptimisticLockingTest {
    private static Logger LOG = ProcessEngineLogger.TEST_LOGGER.getLogger();
    protected ProcessEngineConfigurationImpl processEngineConfiguration;
    protected RuntimeService runtimeService;
    protected TaskService taskService;
    protected static ControllableThread activeThread;

    protected abstract ProcessEngineTestRule getTestRule();

    @After
    public void resetConfiguration() {
        this.processEngineConfiguration.setEnableOptimisticLockingOnForeignKeyViolation(true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/AbstractCompetingTransactionsOptimisticLockingTest.shouldDetectConcurrentDeletionOfExecutionForTaskInsert.bpmn20.xml"})
    @Test
    public void shouldDetectConcurrentDeletionOfExecutionForTaskInsert() {
        this.runtimeService.startProcessInstanceByKey("competingTransactionsProcess");
        List tasks = this.taskService.createTaskQuery().list();
        Task firstTask = "task1-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        Task secondTask = "task2-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        CompleteTaskThread thread1 = new CompleteTaskThread(firstTask);
        thread1.startAndWaitUntilControlIsReturned();
        CompleteTaskThread thread2 = new CompleteTaskThread(secondTask);
        thread2.startAndWaitUntilControlIsReturned();
        thread2.proceedAndWaitTillDone();
        Assertions.assertThat((Throwable)thread2.exception).isNull();
        thread1.proceedAndWaitTillDone();
        Assertions.assertThat((Throwable)thread1.exception).isNotNull();
        if (this.getTestRule().isOptimisticLockingExceptionSuppressible()) {
            Assertions.assertThat((Throwable)thread1.exception).isInstanceOf(OptimisticLockingException.class);
        } else {
            Assertions.assertThat((Throwable)thread1.exception).isInstanceOf(CrdbTransactionRetryException.class);
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/AbstractCompetingTransactionsOptimisticLockingTest.shouldDetectConcurrentDeletionOfExecutionForTaskInsert.bpmn20.xml"})
    @Test
    @RequiredDatabase(includes={"postgres"})
    public void shouldTreatConcurrentDeletionOfExecutionForTaskInsertAsForeignKeyException() {
        this.processEngineConfiguration.setEnableOptimisticLockingOnForeignKeyViolation(false);
        this.runtimeService.startProcessInstanceByKey("competingTransactionsProcess");
        List tasks = this.taskService.createTaskQuery().list();
        Task firstTask = "task1-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        Task secondTask = "task2-1".equals(((Task)tasks.get(0)).getTaskDefinitionKey()) ? (Task)tasks.get(0) : (Task)tasks.get(1);
        CompleteTaskThread thread1 = new CompleteTaskThread(firstTask);
        thread1.startAndWaitUntilControlIsReturned();
        CompleteTaskThread thread2 = new CompleteTaskThread(secondTask);
        thread2.startAndWaitUntilControlIsReturned();
        thread2.proceedAndWaitTillDone();
        Assertions.assertThat((Throwable)thread2.exception).isNull();
        thread1.proceedAndWaitTillDone();
        ((AbstractThrowableAssert)Assertions.assertThat((Throwable)thread1.exception).isInstanceOf(ProcessEngineException.class)).extracting(new String[]{"code"}).contains(new Object[]{BuiltinExceptionCode.FOREIGN_KEY_CONSTRAINT_VIOLATION.getCode()});
    }

    public class CompleteTaskThread
    extends ControllableThread {
        Task task;
        ProcessEngineException exception;

        public CompleteTaskThread(Task task) {
            this.task = task;
        }

        @Override
        public synchronized void startAndWaitUntilControlIsReturned() {
            activeThread = this;
            super.startAndWaitUntilControlIsReturned();
        }

        @Override
        public void run() {
            try {
                AbstractCompetingTransactionsOptimisticLockingTest.this.processEngineConfiguration.getCommandExecutorTxRequired().execute(new ControlledCommand(activeThread, new CompleteTaskCmd(this.task.getId(), null)));
            }
            catch (ProcessEngineException e) {
                this.exception = e;
            }
            LOG.debug(this.getName() + " ends.");
        }
    }
}

