/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.runtime.VariableInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.junit.Test;

@RequiredHistoryLevel(value="activity")
@RequiredDatabase(includes={"cockroachdb"})
public class TransactionIsolationSerializableTest
extends ConcurrencyTestCase {
    protected static final String PROC_DEF_KEY = "oneTaskProcess";
    protected static final String VAR_NAME = "testVariableName";
    protected static final String VAR_INIT_VAL = "initialValue";
    protected static final String VAR_FIRST_VAL = "firstValue";
    protected static final String VAR_SECOND_VAL = "secondValue";

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/oneTaskProcess.bpmn20.xml"})
    public void shouldHandleConcurrentWriteConflictWithTX2Failure() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, Collections.singletonMap(VAR_NAME, VAR_INIT_VAL)).getId();
        ConcurrencyTestHelper.ThreadControl updateVarThread1 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_FIRST_VAL));
        updateVarThread1.waitForSync();
        updateVarThread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl updateVarThread2 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_SECOND_VAL));
        updateVarThread2.waitForSync();
        updateVarThread2.reportInterrupts();
        updateVarThread1.makeContinue();
        updateVarThread1.waitUntilDone();
        updateVarThread2.makeContinue();
        updateVarThread2.waitUntilDone();
        Assertions.assertThat((String)updateVarThread2.getException().getCause().getMessage()).containsIgnoringCase((CharSequence)"TransactionRetryWithProtoRefreshError");
        VariableInstance var = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(VAR_NAME).singleResult();
        Assertions.assertThat((Object)var.getValue()).isEqualTo((Object)VAR_FIRST_VAL);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/oneTaskProcess.bpmn20.xml"})
    public void shouldHandleConcurrentWriteConflictWithTX1Failure() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, Collections.singletonMap(VAR_NAME, VAR_INIT_VAL)).getId();
        ConcurrencyTestHelper.ThreadControl updateVarThread1 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_FIRST_VAL, true));
        updateVarThread1.waitForSync();
        updateVarThread1.reportInterrupts();
        ConcurrencyTestHelper.ThreadControl updateVarThread2 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_SECOND_VAL));
        updateVarThread2.waitForSync();
        updateVarThread2.reportInterrupts();
        updateVarThread1.makeContinue();
        updateVarThread1.waitUntilDone();
        updateVarThread2.makeContinue();
        updateVarThread2.waitUntilDone();
        Assertions.assertThat((Throwable)updateVarThread1.getException()).isInstanceOf(RuntimeException.class);
        Assertions.assertThat((Throwable)updateVarThread2.getException()).isNull();
        VariableInstance var = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(VAR_NAME).singleResult();
        Assertions.assertThat((Object)var.getValue()).isEqualTo((Object)VAR_SECOND_VAL);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/concurrency/oneTaskProcess.bpmn20.xml"})
    public void shouldHandleConcurrentWriteAfterReadConflict() throws InterruptedException {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROC_DEF_KEY, Collections.singletonMap(VAR_NAME, VAR_INIT_VAL)).getId();
        ConcurrencyTestHelper.ThreadControl updateVarThread1 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_FIRST_VAL, false, false));
        updateVarThread1.waitForSync();
        updateVarThread1.reportInterrupts();
        Thread.sleep(1000L);
        ConcurrencyTestHelper.ThreadControl updateVarThread2 = this.executeControllableCommand(new ControllableVariableWriteCommand(processInstanceId, VAR_SECOND_VAL, false, true));
        updateVarThread2.waitForSync();
        updateVarThread2.reportInterrupts();
        updateVarThread1.makeContinue();
        updateVarThread1.waitUntilDone();
        Assertions.assertThat((Throwable)updateVarThread1.getException()).isNull();
        VariableInstance var = (VariableInstance)this.runtimeService.createVariableInstanceQuery().variableName(VAR_NAME).singleResult();
        Assertions.assertThat((Object)var.getValue()).isEqualTo((Object)VAR_FIRST_VAL);
        updateVarThread2.waitUntilDone(true);
    }

    public class ControllableVariableWriteCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected String processInstanceId;
        protected String newVariableValue;
        protected boolean rollback;
        protected boolean readVariable;

        ControllableVariableWriteCommand(String processInstanceId, String newVariableValue) {
            this(processInstanceId, newVariableValue, false, true);
        }

        ControllableVariableWriteCommand(String processInstanceId, String newVariableValue, boolean rollback) {
            this(processInstanceId, newVariableValue, rollback, true);
        }

        ControllableVariableWriteCommand(String processInstanceId, String newVariableValue, boolean rollback, boolean readVariable) {
            this.processInstanceId = processInstanceId;
            this.newVariableValue = newVariableValue;
            this.rollback = rollback;
            this.readVariable = readVariable;
        }

        public Void execute(CommandContext commandContext) {
            if (this.readVariable) {
                commandContext.getProcessEngineConfiguration().getRuntimeService().createVariableInstanceQuery().processInstanceIdIn(new String[]{this.processInstanceId}).variableName(TransactionIsolationSerializableTest.VAR_NAME).list();
            }
            this.monitor.sync();
            commandContext.getProcessEngineConfiguration().getRuntimeService().setVariable(this.processInstanceId, TransactionIsolationSerializableTest.VAR_NAME, (Object)this.newVariableValue);
            if (this.rollback) {
                throw new RuntimeException();
            }
            return null;
        }
    }
}

