/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.io;

import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Test;

public class SkipOutputMappingOnCanceledActitivitesTest
extends PluggableProcessEngineTest {
    protected static final String WORKER_ID = "aWorkerId";
    protected static final long LOCK_TIME = 10000L;
    protected static final String TOPIC_NAME = "externalTaskTopic";

    @After
    public void tearDown() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(false);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/io/SkipOutputMappingOnCanceledActitivitesTest.oneExternalTaskWithOutputMappingAndCatchingErrorBoundaryEvent.bpmn"})
    public void shouldSkipOutputMappingOnBpmnErrorAtExternalTask() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(true);
        this.runtimeService.startProcessInstanceByKey("externalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "errorCode", null);
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/io/SkipOutputMappingOnCanceledActitivitesTest.oneExternalTaskWithOutputMappingAndCatchingErrorBoundaryEvent.bpmn"})
    public void shouldNotSkipOutputMappingOnBpmnErrorAtExternalTask() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(false);
        this.runtimeService.startProcessInstanceByKey("externalTaskProcess");
        List externalTasks = this.externalTaskService.fetchAndLock(1, WORKER_ID).topic(TOPIC_NAME, 10000L).execute();
        Assertions.assertThat((List)externalTasks).hasSize(1);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.externalTaskService.handleBpmnError(((LockedExternalTask)externalTasks.get(0)).getId(), WORKER_ID, "errorCode", null)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Propagation of bpmn error errorCode failed.");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/io/SkipOutputMappingOnCanceledActitivitesTest.oneSubprocessWithOutputMappingAndCatchingErrorBoundaryEvent.bpmn"})
    public void shouldSkipOutputMappingOnBpmnErrorInSubprocess() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(true);
        this.runtimeService.startProcessInstanceByKey("subProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((String)task.getName()).isEqualTo((Object)"userTask in Subprocess");
        this.taskService.handleBpmnError(task.getId(), "errorCode");
        Task userTask = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)userTask).isNotNull();
        Assertions.assertThat((String)userTask.getName()).isEqualTo((Object)"userTask");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/io/SkipOutputMappingOnCanceledActitivitesTest.oneSubprocessWithOutputMappingAndCatchingErrorBoundaryEvent.bpmn"})
    public void shouldNotSkipOutputMappingOnBpmnErrorInSubprocess() {
        this.processEngineConfiguration.setSkipOutputMappingOnCanceledActivities(false);
        this.runtimeService.startProcessInstanceByKey("subProcess");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assertions.assertThat((Object)task).isNotNull();
        Assertions.assertThat((String)task.getName()).isEqualTo((Object)"userTask in Subprocess");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.taskService.handleBpmnError(task.getId(), "errorCode")).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("Propagation of bpmn error errorCode failed.");
    }
}

