/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.incident;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.impl.incident.CompositeIncidentHandler;
import org.camunda.bpm.engine.impl.incident.DefaultIncidentHandler;
import org.camunda.bpm.engine.impl.incident.IncidentContext;
import org.camunda.bpm.engine.impl.incident.IncidentHandler;
import org.camunda.bpm.engine.runtime.Incident;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.verification.Times;
import org.mockito.verification.VerificationMode;

public class CompositeIncidentHandlerTest {
    @Test
    public void shouldUseCompositeIncidentHandlerWithMainIncidentHandlerAddNullHandler() {
        CompositeIncidentHandler compositeIncidentHandler = new CompositeIncidentHandler((IncidentHandler)new DefaultIncidentHandler(""), new IncidentHandler[0]);
        try {
            compositeIncidentHandler.add(null);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handler is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithNullMainHandler() {
        try {
            new CompositeIncidentHandler(null, new IncidentHandler[0]);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handler is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithNullVarargs() {
        Object incidentHandler = null;
        try {
            new CompositeIncidentHandler(null, new IncidentHandler[]{incidentHandler});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handlers contains null value");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithNullList() {
        List incidentHandler = null;
        try {
            new CompositeIncidentHandler(null, incidentHandler);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handler is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithMainHandlersAndNullVarargValue() {
        DefaultIncidentHandler mainIncidentHandler = new DefaultIncidentHandler("failedJob");
        Object incidentHandler = null;
        try {
            new CompositeIncidentHandler((IncidentHandler)mainIncidentHandler, new IncidentHandler[]{incidentHandler});
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handlers contains null value");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithMainHandlersAndNullVarargs() {
        DefaultIncidentHandler mainIncidentHandler = new DefaultIncidentHandler("failedJob");
        IncidentHandler[] incidentHandler = null;
        try {
            new CompositeIncidentHandler((IncidentHandler)mainIncidentHandler, incidentHandler);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handlers is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithMainHandlersAndNullList() {
        DefaultIncidentHandler mainIncidentHandler = new DefaultIncidentHandler("failedJob");
        List incidentHandler = null;
        try {
            new CompositeIncidentHandler((IncidentHandler)mainIncidentHandler, incidentHandler);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handlers is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerArgumentConstructorWithMainHandlersAndListWithNulls() {
        DefaultIncidentHandler mainIncidentHandler = new DefaultIncidentHandler("failedJob");
        ArrayList<Object> incidentHandler = new ArrayList<Object>();
        incidentHandler.add(null);
        incidentHandler.add(null);
        try {
            new CompositeIncidentHandler((IncidentHandler)mainIncidentHandler, incidentHandler);
            Assertions.fail((String)"NullValueException expected");
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incident handler is null");
        }
    }

    @Test
    public void shouldUseCompositeIncidentHandlerWithAnotherIncidentType() {
        CompositeIncidentHandler compositeIncidentHandler = new CompositeIncidentHandler((IncidentHandler)new DefaultIncidentHandler("failedJob"), new IncidentHandler[0]);
        try {
            compositeIncidentHandler.add((IncidentHandler)new DefaultIncidentHandler("failedExternalTask"));
            Assertions.fail((String)"Non expected message expected");
        }
        catch (ProcessEngineException e) {
            Assertions.assertThat((String)e.getMessage()).containsIgnoringCase((CharSequence)"Incorrect incident type handler in composite handler with type: failedJob");
        }
    }

    @Test
    public void shouldCallAllHandlersWhenCreatingIncident() {
        IncidentHandler mainHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Incident incident = (Incident)Mockito.mock(Incident.class);
        Mockito.when((Object)mainHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        Mockito.when((Object)mainHandler.handleIncident((IncidentContext)Mockito.any(), (String)Mockito.any())).thenReturn((Object)incident);
        CompositeIncidentHandler compositeIncidentHandler = new CompositeIncidentHandler(mainHandler, new IncidentHandler[0]);
        IncidentHandler subHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Mockito.when((Object)subHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        Mockito.when((Object)subHandler.handleIncident((IncidentContext)Mockito.any(), (String)Mockito.any())).thenReturn(null);
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        IncidentContext incidentContext = (IncidentContext)Mockito.mock(IncidentContext.class);
        Incident result = compositeIncidentHandler.handleIncident(incidentContext, "Incident message");
        Assertions.assertThat((Object)result).isNotNull();
        Assertions.assertThat((Object)result).isEqualTo((Object)incident);
        ((IncidentHandler)Mockito.verify((Object)mainHandler)).handleIncident((IncidentContext)Mockito.eq((Object)incidentContext), (String)Mockito.eq((Object)"Incident message"));
        ((IncidentHandler)Mockito.verify((Object)subHandler, (VerificationMode)new Times(3))).handleIncident((IncidentContext)Mockito.eq((Object)incidentContext), (String)Mockito.eq((Object)"Incident message"));
    }

    @Test
    public void shouldCallAllHandlersWhenDeletingIncident() {
        IncidentHandler mainHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Mockito.when((Object)mainHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        CompositeIncidentHandler compositeIncidentHandler = new CompositeIncidentHandler(mainHandler, new IncidentHandler[0]);
        IncidentHandler subHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Mockito.when((Object)subHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        IncidentContext incidentContext = (IncidentContext)Mockito.mock(IncidentContext.class);
        compositeIncidentHandler.deleteIncident(incidentContext);
        ((IncidentHandler)Mockito.verify((Object)mainHandler)).deleteIncident((IncidentContext)Mockito.eq((Object)incidentContext));
        ((IncidentHandler)Mockito.verify((Object)subHandler, (VerificationMode)new Times(3))).deleteIncident((IncidentContext)Mockito.eq((Object)incidentContext));
    }

    @Test
    public void shouldCallAllHandlersWhenResolvingIncident() {
        IncidentHandler mainHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Mockito.when((Object)mainHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        CompositeIncidentHandler compositeIncidentHandler = new CompositeIncidentHandler(mainHandler, new IncidentHandler[0]);
        IncidentHandler subHandler = (IncidentHandler)Mockito.mock(IncidentHandler.class);
        Mockito.when((Object)subHandler.getIncidentHandlerType()).thenReturn((Object)"failedJob");
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        compositeIncidentHandler.add(subHandler);
        IncidentContext incidentContext = (IncidentContext)Mockito.mock(IncidentContext.class);
        compositeIncidentHandler.resolveIncident(incidentContext);
        ((IncidentHandler)Mockito.verify((Object)mainHandler)).resolveIncident((IncidentContext)Mockito.eq((Object)incidentContext));
        ((IncidentHandler)Mockito.verify((Object)subHandler, (VerificationMode)new Times(3))).resolveIncident((IncidentContext)Mockito.eq((Object)incidentContext));
    }
}

