/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.mgmt.metrics;

import java.util.Date;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="full")
public class MetricsUserOperationLogTest {
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);
    protected ManagementService managementService;
    protected HistoryService historyService;
    protected IdentityService identityService;

    @Before
    public void setup() {
        this.managementService = this.engineRule.getManagementService();
        this.historyService = this.engineRule.getHistoryService();
        this.identityService = this.engineRule.getIdentityService();
    }

    @Test
    public void testDeleteMetrics() {
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(null);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isNull();
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isNull();
    }

    @Test
    public void testDeleteMetricsWithTimestamp() {
        Date timestamp = ClockUtil.getCurrentTime();
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(timestamp);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"timestamp");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)String.valueOf(timestamp.getTime()));
    }

    @Test
    public void testDeleteMetricsWithReporterId() {
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(null, "reporter1");
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"reporter");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)"reporter1");
    }

    @Test
    public void testDeleteMetricsWithTimestampAndReporterId() {
        Date timestamp = ClockUtil.getCurrentTime();
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteMetrics(timestamp, "reporter1");
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(2L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("reporter").singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"reporter");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)"reporter1");
        logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("timestamp").singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"timestamp");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)String.valueOf(timestamp.getTime()));
    }

    @Test
    public void shouldLogDeletionOfTaskMetricsWithTimestamp() {
        Date timestamp = ClockUtil.getCurrentTime();
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteTaskMetrics(timestamp);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().property("timestamp").singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"TaskMetrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isEqualTo((Object)"timestamp");
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isEqualTo((Object)String.valueOf(timestamp.getTime()));
    }

    @Test
    public void shouldLogDeletionOfTaskMetricsWithoutTimestamp() {
        this.identityService.setAuthenticatedUserId("userId");
        this.managementService.deleteTaskMetrics(null);
        this.identityService.clearAuthentication();
        Assertions.assertThat((long)this.historyService.createUserOperationLogQuery().count()).isEqualTo(1L);
        UserOperationLogEntry logEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().singleResult();
        Assertions.assertThat((String)logEntry.getEntityType()).isEqualTo((Object)"TaskMetrics");
        Assertions.assertThat((String)logEntry.getOperationType()).isEqualTo((Object)"Delete");
        Assertions.assertThat((String)logEntry.getProperty()).isNull();
        Assertions.assertThat((String)logEntry.getOrgValue()).isNull();
        Assertions.assertThat((String)logEntry.getNewValue()).isNull();
    }
}

