/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.task;

import ch.qos.logback.classic.Level;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.task.Event;
import org.camunda.bpm.engine.task.IdentityLink;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.bpmn.tasklistener.util.GetIdentityLinksTaskListener;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.commons.testing.ProcessEngineLoggingRule;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class TaskIdentityLinksTest
extends PluggableProcessEngineTest {
    @Rule
    public ProcessEngineLoggingRule loggingRule = new ProcessEngineLoggingRule().level(Level.ERROR);

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    @Test
    public void testCandidateUserLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addCandidateUser(taskId, "kermit");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        Assert.assertNull((Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"kermit", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
        Assert.assertEquals((Object)taskId, (Object)identityLink.getTaskId());
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        this.taskService.deleteCandidateUser(taskId, "kermit");
        Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    @Test
    public void testCandidateGroupLink() {
        try {
            List taskEventMessageParts;
            Event taskEvent;
            List taskEvents;
            this.identityService.setAuthenticatedUserId("demo");
            this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
            String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
            this.taskService.addCandidateGroup(taskId, "muppets");
            List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
            IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
            Assert.assertEquals((Object)"muppets", (Object)identityLink.getGroupId());
            Assert.assertNull((String)"kermit", (Object)identityLink.getUserId());
            Assert.assertEquals((Object)"candidate", (Object)identityLink.getType());
            Assert.assertEquals((Object)taskId, (Object)identityLink.getTaskId());
            Assert.assertEquals((long)1L, (long)identityLinks.size());
            if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
                taskEvents = this.taskService.getTaskEvents(taskId);
                Assert.assertEquals((long)1L, (long)taskEvents.size());
                taskEvent = (Event)taskEvents.get(0);
                Assert.assertEquals((Object)"AddGroupLink", (Object)taskEvent.getAction());
                taskEventMessageParts = taskEvent.getMessageParts();
                Assert.assertEquals((Object)"muppets", taskEventMessageParts.get(0));
                Assert.assertEquals((Object)"candidate", taskEventMessageParts.get(1));
                Assert.assertEquals((long)2L, (long)taskEventMessageParts.size());
            }
            this.taskService.deleteCandidateGroup(taskId, "muppets");
            if (this.processEngineConfiguration.getHistoryLevel().getId() >= ProcessEngineConfigurationImpl.HISTORYLEVEL_FULL) {
                taskEvents = this.taskService.getTaskEvents(taskId);
                taskEvent = this.findTaskEvent(taskEvents, "DeleteGroupLink");
                Assert.assertEquals((Object)"DeleteGroupLink", (Object)taskEvent.getAction());
                taskEventMessageParts = taskEvent.getMessageParts();
                Assert.assertEquals((Object)"muppets", taskEventMessageParts.get(0));
                Assert.assertEquals((Object)"candidate", taskEventMessageParts.get(1));
                Assert.assertEquals((long)2L, (long)taskEventMessageParts.size());
                Assert.assertEquals((long)2L, (long)taskEvents.size());
            }
            Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(taskId).size());
        }
        finally {
            this.identityService.clearAuthentication();
        }
    }

    @Test
    public void testAssigneeLink() {
        Task task = this.taskService.newTask("task");
        task.setAssignee("assignee");
        this.taskService.saveTask(task);
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        Assert.assertNotNull((Object)identityLinks);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        Assert.assertEquals((Object)"assignee", (Object)identityLink.getType());
        Assert.assertEquals((Object)"assignee", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"task", (Object)identityLink.getTaskId());
        identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testOwnerLink() {
        Task task = this.taskService.newTask("task");
        task.setOwner("owner");
        this.taskService.saveTask(task);
        List identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        Assert.assertNotNull((Object)identityLinks);
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        Assert.assertEquals((Object)"owner", (Object)identityLink.getType());
        Assert.assertEquals((Object)"owner", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"task", (Object)identityLink.getTaskId());
        identityLinks = this.taskService.getIdentityLinksForTask(task.getId());
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        this.taskService.deleteTask(task.getId(), true);
    }

    private Event findTaskEvent(List<Event> taskEvents, String action) {
        for (Event event : taskEvents) {
            if (!action.equals(event.getAction())) continue;
            return event;
        }
        throw new AssertionError((Object)("no task event found with action " + action));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    @Test
    public void testCustomTypeUserLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addUserIdentityLink(taskId, "kermit", "interestee");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        Assert.assertNull((Object)identityLink.getGroupId());
        Assert.assertEquals((Object)"kermit", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"interestee", (Object)identityLink.getType());
        Assert.assertEquals((Object)taskId, (Object)identityLink.getTaskId());
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        this.taskService.deleteUserIdentityLink(taskId, "kermit", "interestee");
        Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/task/IdentityLinksProcess.bpmn20.xml"})
    @Test
    public void testCustomLinkGroupLink() {
        this.runtimeService.startProcessInstanceByKey("IdentityLinksProcess");
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.addGroupIdentityLink(taskId, "muppets", "playing");
        List identityLinks = this.taskService.getIdentityLinksForTask(taskId);
        IdentityLink identityLink = (IdentityLink)identityLinks.get(0);
        Assert.assertEquals((Object)"muppets", (Object)identityLink.getGroupId());
        Assert.assertNull((String)"kermit", (Object)identityLink.getUserId());
        Assert.assertEquals((Object)"playing", (Object)identityLink.getType());
        Assert.assertEquals((Object)taskId, (Object)identityLink.getTaskId());
        Assert.assertEquals((long)1L, (long)identityLinks.size());
        this.taskService.deleteGroupIdentityLink(taskId, "muppets", "playing");
        Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(taskId).size());
    }

    @Test
    public void testDeleteAssignee() {
        Task task = this.taskService.newTask();
        task.setAssignee("nonExistingUser");
        this.taskService.saveTask(task);
        this.taskService.deleteUserIdentityLink(task.getId(), "nonExistingUser", "assignee");
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertNull((Object)task.getAssignee());
        Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(task.getId()).size());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testDeleteOwner() {
        Task task = this.taskService.newTask();
        task.setOwner("nonExistingUser");
        this.taskService.saveTask(task);
        this.taskService.deleteUserIdentityLink(task.getId(), "nonExistingUser", "owner");
        task = (Task)this.taskService.createTaskQuery().taskId(task.getId()).singleResult();
        Assert.assertNull((Object)task.getOwner());
        Assert.assertEquals((long)0L, (long)this.taskService.getIdentityLinksForTask(task.getId()).size());
        this.taskService.deleteTask(task.getId(), true);
    }

    @Test
    public void testAssigneeGetIdentityLinksInCompleteListener() {
        BpmnModelInstance model = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("task1").camundaTaskListenerClass("complete", GetIdentityLinksTaskListener.class.getName())).userTask("task2").endEvent().done();
        this.testRule.deploy(model);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        task.setAssignee("elmo");
        this.taskService.saveTask(task);
        this.taskService.addUserIdentityLink(taskId, "kermit", "interestee");
        this.taskService.complete(taskId);
        Assertions.assertThat((List)this.loggingRule.getLog()).isEmpty();
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariable(processInstanceId, "identityLinksSize"));
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariable(processInstanceId, "secondCallidentityLinksSize"));
    }

    @Test
    public void testOwnerGetIdentityLinksInCompleteListener() {
        BpmnModelInstance model = ((UserTaskBuilder)((ProcessBuilder)Bpmn.createExecutableProcess((String)"process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("task1").camundaTaskListenerClass("complete", GetIdentityLinksTaskListener.class.getName())).userTask("task2").endEvent().done();
        this.testRule.deploy(model);
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        String taskId = task.getId();
        task.setOwner("gonzo");
        this.taskService.saveTask(task);
        this.taskService.addUserIdentityLink(taskId, "kermit", "interestee");
        this.taskService.complete(taskId);
        Assertions.assertThat((List)this.loggingRule.getLog()).isEmpty();
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariable(processInstanceId, "identityLinksSize"));
        Assert.assertEquals((Object)2, (Object)this.runtimeService.getVariable(processInstanceId, "secondCallidentityLinksSize"));
    }
}

