/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.message;

import java.util.List;
import org.camunda.bpm.engine.impl.EventSubscriptionQueryImpl;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.persistence.entity.ExecutionEntity;
import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.ExecutionAssert;
import org.camunda.bpm.engine.test.util.ExecutionTree;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.test.util.TestExecutionListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class MessageEventSubprocessTest
extends PluggableProcessEngineTest {
    @After
    public void tearDown() throws Exception {
        TestExecutionListener.reset();
    }

    @Deployment
    @Test
    public void testInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(1);
    }

    @Deployment
    @Test
    public void testTwoInterruptingUnderProcessDefinition() {
        this.testInterruptingUnderProcessDefinition(2);
    }

    private void testInterruptingUnderProcessDefinition(int expectedNumberOfEventSubscriptions) {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)expectedNumberOfEventSubscriptions, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"eventSubProcessTask", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskInEventSubProcess", (Object)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        Assert.assertEquals((Object)"taskInMainFlow-start", (Object)collectedEvents.get(0));
        Assert.assertEquals((Object)"taskInMainFlow-end", (Object)collectedEvents.get(1));
        Assert.assertEquals((Object)"eventSubProcess-start", (Object)collectedEvents.get(2));
        Assert.assertEquals((Object)"startEventInSubProcess-start", (Object)collectedEvents.get(3));
        Assert.assertEquals((Object)"startEventInSubProcess-end", (Object)collectedEvents.get(4));
        Assert.assertEquals((Object)"taskInEventSubProcess-start", (Object)collectedEvents.get(5));
        Assert.assertEquals((Object)"taskInEventSubProcess-end", (Object)collectedEvents.get(6));
        Assert.assertEquals((Object)"eventSubProcess-end", (Object)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    @Test
    public void testNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        Assert.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        Assert.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        Assert.assertEquals((Object)"taskInMainFlow-start", (Object)collectedEvents.get(0));
        Assert.assertEquals((Object)"eventSubProcess-start", (Object)collectedEvents.get(1));
        Assert.assertEquals((Object)"startEventInSubProcess-start", (Object)collectedEvents.get(2));
        Assert.assertEquals((Object)"startEventInSubProcess-end", (Object)collectedEvents.get(3));
        Assert.assertEquals((Object)"taskInEventSubProcess-start", (Object)collectedEvents.get(4));
        Assert.assertEquals((Object)"taskInMainFlow-end", (Object)collectedEvents.get(5));
        Assert.assertEquals((Object)"taskInEventSubProcess-end", (Object)collectedEvents.get(6));
        Assert.assertEquals((Object)"eventSubProcess-end", (Object)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    @Test
    public void testNestedEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskInEventSubProcess", (Object)taskInEventSubProcess.getTaskDefinitionKey());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        Assert.assertEquals((Object)"taskInMainFlow-start", (Object)collectedEvents.get(0));
        Assert.assertEquals((Object)"taskInMainFlow-end", (Object)collectedEvents.get(1));
        Assert.assertEquals((Object)"eventSubProcess-start", (Object)collectedEvents.get(2));
        Assert.assertEquals((Object)"startEventInSubProcess-start", (Object)collectedEvents.get(3));
        Assert.assertEquals((Object)"startEventInSubProcess-end", (Object)collectedEvents.get(4));
        Assert.assertEquals((Object)"taskInEventSubProcess-start", (Object)collectedEvents.get(5));
        Assert.assertEquals((Object)"taskInEventSubProcess-end", (Object)collectedEvents.get(6));
        Assert.assertEquals((Object)"eventSubProcess-end", (Object)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    @Test
    public void testNestedNonInterruptingEventSubprocessListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInMainFlow = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInMainFlow").singleResult();
        Assert.assertNotNull((Object)taskInMainFlow);
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().taskDefinitionKey("taskInEventSubProcess").singleResult();
        Assert.assertNotNull((Object)taskInEventSubProcess);
        this.taskService.complete(taskInMainFlow.getId());
        this.taskService.complete(taskInEventSubProcess.getId());
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        Assert.assertEquals((Object)"taskInMainFlow-start", (Object)collectedEvents.get(0));
        Assert.assertEquals((Object)"eventSubProcess-start", (Object)collectedEvents.get(1));
        Assert.assertEquals((Object)"startEventInSubProcess-start", (Object)collectedEvents.get(2));
        Assert.assertEquals((Object)"startEventInSubProcess-end", (Object)collectedEvents.get(3));
        Assert.assertEquals((Object)"taskInEventSubProcess-start", (Object)collectedEvents.get(4));
        Assert.assertEquals((Object)"taskInMainFlow-end", (Object)collectedEvents.get(5));
        Assert.assertEquals((Object)"taskInEventSubProcess-end", (Object)collectedEvents.get(6));
        Assert.assertEquals((Object)"eventSubProcess-end", (Object)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("endEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("subProcess").finished().count());
        }
    }

    @Deployment
    @Test
    public void testEventSubprocessBoundaryListenersInvoked() {
        this.runtimeService.startProcessInstanceByKey("testProcess");
        this.runtimeService.correlateMessage("message");
        Task taskInEventSubProcess = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"taskInEventSubProcess", (Object)taskInEventSubProcess.getTaskDefinitionKey());
        this.runtimeService.correlateMessage("message2");
        List<String> collectedEvents = TestExecutionListener.collectedEvents;
        Assert.assertEquals((Object)"taskInMainFlow-start", (Object)collectedEvents.get(0));
        Assert.assertEquals((Object)"taskInMainFlow-end", (Object)collectedEvents.get(1));
        Assert.assertEquals((Object)"eventSubProcess-start", (Object)collectedEvents.get(2));
        Assert.assertEquals((Object)"startEventInSubProcess-start", (Object)collectedEvents.get(3));
        Assert.assertEquals((Object)"startEventInSubProcess-end", (Object)collectedEvents.get(4));
        Assert.assertEquals((Object)"taskInEventSubProcess-start", (Object)collectedEvents.get(5));
        Assert.assertEquals((Object)"taskInEventSubProcess-end", (Object)collectedEvents.get(6));
        Assert.assertEquals((Object)"eventSubProcess-end", (Object)collectedEvents.get(7));
        if (this.processEngineConfiguration.getHistoryLevel().getId() > ProcessEngineConfigurationImpl.HISTORYLEVEL_NONE) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInMainFlow").canceled().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("startEventInSubProcess").finished().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("taskInEventSubProcess").canceled().count());
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricActivityInstanceQuery().activityId("eventSubProcess").finished().count());
        }
    }

    @Deployment
    @Test
    public void testNonInterruptingUnderProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().executionId(processInstance.getId()).messageEventSubscriptionName("newMessage").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", processInstance.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testNonInterruptingUnderProcessDefinitionScope() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        Assert.assertNotNull((Object)execution);
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"task", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.createEventSubscriptionQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.correlateMessage("newMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        this.taskService.complete(task.getId());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createExecutionQuery().count());
        task = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createExecutionQuery().count());
    }

    @Deployment
    @Test
    public void testMultipleNonInterruptingInEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Execution subProcess = (Execution)this.runtimeService.createExecutionQuery().messageEventSubscriptionName("newMessage").singleResult();
        Assert.assertNotNull((Object)subProcess);
        Assert.assertEquals((long)1L, (long)this.createEventSubscriptionQuery().count());
        Task subProcessTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("subProcessTask").singleResult();
        Assert.assertNotNull((Object)subProcessTask);
        for (int i = 1; i < 3; ++i) {
            this.runtimeService.messageEventReceived("newMessage", subProcess.getId());
            List eventSubProcessTasks = this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").list();
            Assert.assertEquals((long)i, (long)eventSubProcessTasks.size());
        }
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("subProcessTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().up().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.taskService.complete(subProcessTask.getId());
        Assert.assertEquals((long)0L, (long)this.taskService.createTaskQuery().count());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createProcessInstanceQuery().count());
    }

    private EventSubscriptionQueryImpl createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.processEngineConfiguration.getCommandExecutorTxRequired());
    }

    @Deployment
    @Test
    public void testNonInterruptingInMultiParallelEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Assert.assertEquals((long)6L, (long)this.runtimeService.createExecutionQuery().count());
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            Assert.assertEquals((Object)"subUserTask", (Object)task.getTaskDefinitionKey());
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
        processInstance = this.runtimeService.startProcessInstanceByKey("process");
        for (EventSubscription es : this.runtimeService.createEventSubscriptionQuery().list()) {
            this.runtimeService.messageEventReceived("message", es.getExecutionId());
        }
        Assert.assertEquals((long)2L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        tasks = this.taskService.createTaskQuery().taskName("Message User Task").list();
        Assert.assertEquals((long)2L, (long)tasks.size());
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().taskName("Message User Task").list().size());
        tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingInMultiSequentialEmbeddedSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("message", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Message User Task").singleResult()).getId());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().taskName("Sub User Task").list().get(0)).getId());
        Assert.assertEquals((long)0L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(((Task)this.taskService.createTaskQuery().singleResult()).getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingWithParallelForkInsideEmbeddedSubProcess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage", ((EventSubscription)this.runtimeService.createEventSubscriptionQuery().singleResult()).getExecutionId());
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstance.getId(), this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).scope().child("firstUserTask").concurrent().noScope().up().child("secondUserTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").done());
        List tasks = this.taskService.createTaskQuery().list();
        for (Task task : tasks) {
            this.taskService.complete(task.getId());
        }
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testNonInterruptingWithReceiveTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        ExecutionTree executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child(null).concurrent().noScope().child("receiveTask").scope().up().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        Assert.assertNotNull((Object)task2);
        executionTree = ExecutionTree.forExecution(processInstanceId, this.processEngine);
        ExecutionAssert.assertThat(executionTree).matches(ExecutionAssert.describeExecutionTree(null).scope().child("userTask").concurrent().noScope().up().child(null).concurrent().noScope().child("eventSubProcessTask").scope().done());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingWithAsyncConcurrentTask() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("message");
        Job asyncJob = (Job)this.managementService.createJobQuery().singleResult();
        Assert.assertNotNull((Object)asyncJob);
        this.managementService.executeJob(asyncJob.getId());
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task processTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        Task eventSubprocessTask = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)processTask);
        Assert.assertNotNull((Object)eventSubprocessTask);
        this.taskService.complete(processTask.getId());
        this.taskService.complete(eventSubprocessTask.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingWithReceiveTaskInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingWithUserTaskAndBoundaryEventInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("newMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        Execution task1Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task1Execution).getParentId()));
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("task").singleResult();
        Assert.assertNotNull((Object)task2);
        Execution task2Execution = (Execution)this.runtimeService.createExecutionQuery().activityId("eventSubProcessTask").singleResult();
        Assert.assertFalse((boolean)processInstanceId.equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertTrue((boolean)((ExecutionEntity)task1Execution).getParentId().equals(((ExecutionEntity)task2Execution).getParentId()));
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testNonInterruptingOutsideEmbeddedSubProcessWithReceiveTaskInsideEmbeddedSubProcess() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey("process").getId();
        this.runtimeService.correlateMessage("firstMessage");
        Assert.assertEquals((long)1L, (long)this.taskService.createTaskQuery().count());
        Task task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        this.runtimeService.correlateMessage("secondMessage");
        Assert.assertEquals((long)2L, (long)this.taskService.createTaskQuery().count());
        task1 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("eventSubProcessTask").singleResult();
        Assert.assertNotNull((Object)task1);
        Task task2 = (Task)this.taskService.createTaskQuery().taskDefinitionKey("userTask").singleResult();
        Assert.assertNotNull((Object)task2);
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().count());
        this.taskService.complete(task1.getId());
        this.taskService.complete(task2.getId());
        this.testRule.assertProcessEnded(processInstanceId);
    }

    @Deployment
    @Test
    public void testInterruptingActivityInstanceTree() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("newMessage");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().endScope().done());
    }

    @Deployment
    @Test
    public void testNonInterruptingActivityInstanceTree() {
        ProcessInstance instance = this.runtimeService.startProcessInstanceByKey("process");
        String processInstanceId = instance.getId();
        this.runtimeService.correlateMessage("newMessage");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstanceId);
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(instance.getProcessDefinitionId()).beginScope("subProcess").activity("innerTask").beginScope("eventSubProcess").activity("eventSubProcessTask").endScope().endScope().done());
    }

    @Deployment
    @Test
    public void testNonInterruptingWithTerminatingEndEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertThat((Object)task.getName(), (Matcher)CoreMatchers.is((Object)"Inner User Task"));
        this.runtimeService.correlateMessage("message");
        Task eventSubprocessTask = (Task)this.taskService.createTaskQuery().taskName("Event User Task").singleResult();
        Assert.assertThat((Object)eventSubprocessTask, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.taskService.complete(eventSubprocessTask.getId());
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("SubProcess_1").activity("UserTask_1").endScope().endScope().done());
    }

    @Deployment
    @Test
    public void testExpressionInMessageNameInInterruptingSubProcessDefinition() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("process");
        this.runtimeService.messageEventReceived("newMessage-foo", processInstance.getId());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        Assert.assertEquals((Object)"eventSubProcessTask", (Object)task.getTaskDefinitionKey());
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }
}

