/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.concurrency;

import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.impl.HistoryLevelSetupCommand;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestCase;
import org.camunda.bpm.engine.test.concurrency.ConcurrencyTestHelper;
import org.camunda.bpm.engine.test.util.DatabaseHelper;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConcurrentHistoryLevelTest
extends ConcurrencyTestCase {
    @Before
    public void setUp() throws Exception {
        TestHelper.deleteHistoryLevel((ProcessEngineConfigurationImpl)this.processEngineConfiguration);
    }

    @Test
    @RequiredDatabase(excludes={"h2", "mariadb"})
    public void test() throws InterruptedException {
        Integer transactionIsolationLevel = DatabaseHelper.getTransactionIsolationLevel(this.processEngineConfiguration);
        Assumptions.assumeThat((transactionIsolationLevel != null && !transactionIsolationLevel.equals(2) ? 1 : 0) != 0);
        ConcurrencyTestHelper.ThreadControl thread1 = this.executeControllableCommand(new ControllableUpdateHistoryLevelCommand());
        thread1.reportInterrupts();
        thread1.waitForSync();
        ConcurrencyTestHelper.ThreadControl thread2 = this.executeControllableCommand(new ControllableUpdateHistoryLevelCommand());
        thread2.reportInterrupts();
        thread2.waitForSync();
        thread1.makeContinue();
        thread1.waitForSync();
        thread2.makeContinue();
        Thread.sleep(2000L);
        thread1.waitUntilDone();
        thread2.waitForSync();
        thread2.waitUntilDone();
        Assert.assertNull((Object)thread1.getException());
        Throwable thread2Exception = thread2.getException();
        if (this.testRule.isOptimisticLockingExceptionSuppressible()) {
            Assert.assertNull((Object)thread2Exception);
        } else {
            Assertions.assertThat((Throwable)thread2Exception).isInstanceOf(CrdbTransactionRetryException.class);
        }
        HistoryLevel historyLevel = this.processEngineConfiguration.getHistoryLevel();
        Assert.assertEquals((Object)"full", (Object)historyLevel.getName());
    }

    protected static class ControllableUpdateHistoryLevelCommand
    extends ConcurrencyTestHelper.ControllableCommand<Void> {
        protected ControllableUpdateHistoryLevelCommand() {
        }

        public Void execute(CommandContext commandContext) {
            this.monitor.sync();
            new HistoryLevelSetupCommand().execute(commandContext);
            this.monitor.sync();
            return null;
        }
    }
}

