/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.time.DateUtils;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.util.ClockUtil;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.junit.Assert;
import org.junit.Test;

public class UserOperationLogJobTest
extends AbstractUserOperationLogTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobPriority() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobPriority(job.getId(), 42L);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetPriority").singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)job.getId(), (Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetPriority", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"priority", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"42", (Object)userOperationLogEntry.getNewValue());
        Assert.assertEquals((Object)"0", (Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetries() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetries(job.getId(), 4);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetJobRetries").singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)job.getId(), (Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"retries", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"4", (Object)userOperationLogEntry.getNewValue());
        Assert.assertEquals((Object)"3", (Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesByJobDefinitionId() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.setJobRetriesByJobDefinitionId(job.getJobDefinitionId(), 4);
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("SetJobRetries").singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"retries", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"4", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesAsync() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Batch batch = this.managementService.setJobRetriesAsync(Arrays.asList(job.getId()), 4);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetJobRetries");
        Assert.assertEquals((long)3L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.property("retries").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"retries", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"4", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("nrOfInstances").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"nrOfInstances", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"1", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("async").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"async", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetRetriesAsyncProcessInstanceId() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Batch batch = this.managementService.setJobRetriesAsync(Arrays.asList(processInstance.getId()), (ProcessInstanceQuery)null, 4);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetJobRetries");
        Assert.assertEquals((long)3L, (long)query.count());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)query.property("retries").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"retries", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"4", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("nrOfInstances").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"nrOfInstances", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"1", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        userOperationLogEntry = (UserOperationLogEntry)query.property("async").singleResult();
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertNull((Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"SetJobRetries", (Object)userOperationLogEntry.getOperationType());
        Assert.assertEquals((Object)"async", (Object)userOperationLogEntry.getProperty());
        Assert.assertEquals((Object)"true", (Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertNull((String)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertNull((String)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertNull((String)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertNull((String)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertNull((String)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
        this.managementService.deleteBatch(batch.getId(), true);
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testSetJobDueDate() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        Date newDate = new Date(ClockUtil.getCurrentTime().getTime() + 2000L);
        this.managementService.setJobDuedate(job.getId(), newDate);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("SetDueDate");
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)entry.getJobId());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)entry.getDeploymentId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)entry.getJobDefinitionId());
        Assert.assertEquals((Object)"duedate", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertEquals((Object)newDate, (Object)new Date(Long.parseLong(entry.getNewValue())));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/timer/TimerRecalculationTest.testFinishedJob.bpmn20.xml"})
    @Test
    public void testRecalculateJobDueDate() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        Date duedate = ClockUtil.getCurrentTime();
        variables1.put("dueDate", duedate);
        this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.recalculateJobDuedate(job.getId(), false);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().operationType("RecalculateDueDate");
        Assert.assertEquals((long)2L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)query.property("duedate").singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)entry.getJobId());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)entry.getDeploymentId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)entry.getJobDefinitionId());
        Assert.assertEquals((Object)"duedate", (Object)entry.getProperty());
        Assert.assertTrue((boolean)DateUtils.truncatedEquals((Date)duedate, (Date)new Date(Long.parseLong(entry.getOrgValue())), (int)13));
        Assert.assertTrue((boolean)DateUtils.truncatedEquals((Date)duedate, (Date)new Date(Long.parseLong(entry.getNewValue())), (int)13));
        entry = (UserOperationLogEntry)query.property("creationDateBased").singleResult();
        Assert.assertEquals((Object)job.getId(), (Object)entry.getJobId());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)entry.getDeploymentId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)entry.getJobDefinitionId());
        Assert.assertEquals((Object)"creationDateBased", (Object)entry.getProperty());
        Assert.assertNull((Object)entry.getOrgValue());
        Assert.assertFalse((boolean)Boolean.parseBoolean(entry.getNewValue()));
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testDelete() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.deleteJob(job.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Delete").singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)job.getId(), (Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"Delete", (Object)userOperationLogEntry.getOperationType());
        Assert.assertNull((Object)userOperationLogEntry.getProperty());
        Assert.assertNull((Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testExecute() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.managementService.executeJob(job.getId());
        UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("Execute").singleResult();
        Assert.assertNotNull((Object)userOperationLogEntry);
        Assert.assertEquals((Object)"Job", (Object)userOperationLogEntry.getEntityType());
        Assert.assertEquals((Object)job.getId(), (Object)userOperationLogEntry.getJobId());
        Assert.assertEquals((Object)"Execute", (Object)userOperationLogEntry.getOperationType());
        Assert.assertNull((Object)userOperationLogEntry.getProperty());
        Assert.assertNull((Object)userOperationLogEntry.getNewValue());
        Assert.assertNull((Object)userOperationLogEntry.getOrgValue());
        Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
        Assert.assertEquals((Object)job.getJobDefinitionId(), (Object)userOperationLogEntry.getJobDefinitionId());
        Assert.assertEquals((Object)job.getProcessInstanceId(), (Object)userOperationLogEntry.getProcessInstanceId());
        Assert.assertEquals((Object)job.getProcessDefinitionId(), (Object)userOperationLogEntry.getProcessDefinitionId());
        Assert.assertEquals((Object)job.getProcessDefinitionKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
        Assert.assertEquals((Object)job.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
        Assert.assertEquals((Object)"Operator", (Object)userOperationLogEntry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/asyncTaskProcess.bpmn20.xml"})
    @Test
    public void testExecuteByJobExecutor() {
        this.runtimeService.startProcessInstanceByKey("asyncTaskProcess");
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().count());
        this.testRule.waitForJobExecutorToProcessAllJobs(TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS));
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().count());
        long logEntriesCount = this.historyService.createUserOperationLogQuery().operationType("Execute").count();
        Assert.assertEquals((long)0L, (long)logEntriesCount);
    }
}

