/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.impl.cfg;

import java.sql.SQLException;
import javax.transaction.RollbackException;
import javax.transaction.TransactionManager;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.CrdbTransactionRetryException;
import org.camunda.bpm.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.interceptor.CommandInterceptor;
import org.camunda.bpm.engine.impl.interceptor.JtaTransactionInterceptor;
import org.camunda.bpm.engine.impl.interceptor.TransactionException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class JtaTransactionInterceptorTest {
    @Mock
    public TransactionManager txManager;
    @Mock
    public ProcessEngineConfigurationImpl engineConfiguration;
    @Mock
    public CommandInterceptor nextInterceptor;

    @Before
    public void mockEngineConfiguration() {
        Mockito.when((Object)this.engineConfiguration.getDatabaseType()).thenReturn((Object)"cockroachdb");
    }

    @Test
    public void shouldConvertSqlExceptionToCrdbError() throws Exception {
        JtaTransactionInterceptor interceptor = new JtaTransactionInterceptor(this.txManager, true, this.engineConfiguration);
        interceptor.setNext((CommandExecutor)this.nextInterceptor);
        RollbackException exception = new RollbackException();
        exception.addSuppressed((Throwable)this.buildCrdbCommitException());
        ((TransactionManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.txManager)).commit();
        Assertions.assertThatThrownBy(() -> interceptor.execute(c -> null)).isInstanceOf(CrdbTransactionRetryException.class);
    }

    @Test
    public void shoulNotConvertUnrelatedSqlExceptionToCrdbError() throws Exception {
        JtaTransactionInterceptor interceptor = new JtaTransactionInterceptor(this.txManager, true, this.engineConfiguration);
        interceptor.setNext((CommandExecutor)this.nextInterceptor);
        RollbackException exception = new RollbackException();
        exception.addSuppressed((Throwable)new SQLException("unrelated error"));
        ((TransactionManager)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.txManager)).commit();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> interceptor.execute(c -> null)).isInstanceOf(TransactionException.class)).hasMessage("Unable to commit transaction");
    }

    @Test
    public void shoulNotConvertGenericRuntimeExceptionToCrdbError() throws Exception {
        JtaTransactionInterceptor interceptor = new JtaTransactionInterceptor(this.txManager, true, this.engineConfiguration);
        interceptor.setNext((CommandExecutor)this.nextInterceptor);
        ((TransactionManager)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.txManager)).commit();
        Assertions.assertThatThrownBy(() -> interceptor.execute(c -> null)).isInstanceOf(RuntimeException.class);
    }

    private Exception buildCrdbCommitException() {
        return new SQLException("ERROR: restart transaction: TransactionRetryWithProtoRefreshError: TransactionRetryError: retry txn (RETRY_SERIALIZABLE)");
    }
}

