/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.batch;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.impl.history.HistoryLevel;
import org.camunda.bpm.engine.migration.MigrationPlan;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationScenario;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationSpec;
import org.camunda.bpm.engine.test.api.authorization.util.AuthorizationTestRule;
import org.camunda.bpm.engine.test.api.runtime.migration.models.ProcessModels;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RequiredHistoryLevel(value="full")
@RunWith(value=Parameterized.class)
public class DeleteBatchAuthorizationTest {
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    public AuthorizationTestRule authRule = new AuthorizationTestRule(this.engineRule);
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain chain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.authRule).around((TestRule)this.testHelper);
    @Parameterized.Parameter
    public AuthorizationScenario scenario;
    protected MigrationPlan migrationPlan;
    protected Batch batch;
    protected boolean cascade;

    @Parameterized.Parameters(name="Scenario {index}")
    public static Collection<AuthorizationScenario[]> scenarios() {
        return AuthorizationTestRule.asParameters(AuthorizationScenario.scenario().withoutAuthorizations().failsDueToRequired(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.DELETE})), AuthorizationScenario.scenario().withAuthorizations(AuthorizationSpec.grant((Resource)Resources.BATCH, "batchId", "userId", new Permission[]{Permissions.DELETE})).succeeds());
    }

    @Before
    public void setUp() {
        this.authRule.createUserAndGroup("userId", "groupId");
    }

    @Before
    public void deployProcessesAndCreateMigrationPlan() {
        ProcessDefinition sourceDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        ProcessDefinition targetDefinition = this.testHelper.deployAndGetDefinition(ProcessModels.ONE_TASK_PROCESS);
        this.migrationPlan = this.engineRule.getRuntimeService().createMigrationPlan(sourceDefinition.getId(), targetDefinition.getId()).build();
    }

    @After
    public void tearDown() {
        this.authRule.deleteUsersAndGroups();
    }

    @After
    public void deleteBatch() {
        if (this.authRule.scenarioFailed()) {
            this.engineRule.getManagementService().deleteBatch(this.batch.getId(), true);
        } else if (!this.cascade && this.engineRule.getProcessEngineConfiguration().getHistoryLevel() == HistoryLevel.HISTORY_LEVEL_FULL) {
            this.engineRule.getHistoryService().deleteHistoricBatch(this.batch.getId());
        }
    }

    @Test
    public void testDeleteBatch() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(this.migrationPlan.getSourceProcessDefinitionId());
        this.batch = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", this.batch.getId()).start();
        this.cascade = false;
        this.engineRule.getManagementService().deleteBatch(this.batch.getId(), this.cascade);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createBatchQuery().count());
            List userOperationLogEntries = this.engineRule.getHistoryService().createUserOperationLogQuery().operationType("Delete").list();
            Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
            UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
            Assert.assertEquals((Object)"cascadeToHistory", (Object)entry.getProperty());
            Assert.assertEquals((Object)"false", (Object)entry.getNewValue());
            Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
        }
    }

    @Test
    public void testDeleteBatchCascade() {
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceById(this.migrationPlan.getSourceProcessDefinitionId());
        this.batch = this.engineRule.getRuntimeService().newMigration(this.migrationPlan).processInstanceIds(Arrays.asList(processInstance.getId())).executeAsync();
        this.authRule.init(this.scenario).withUser("userId").bindResource("batchId", this.batch.getId()).start();
        this.cascade = true;
        this.engineRule.getManagementService().deleteBatch(this.batch.getId(), this.cascade);
        if (this.authRule.assertScenario(this.scenario)) {
            Assert.assertEquals((long)0L, (long)this.engineRule.getManagementService().createBatchQuery().count());
            Assert.assertEquals((long)0L, (long)this.engineRule.getHistoryService().createHistoricBatchQuery().count());
            UserOperationLogQuery query = this.engineRule.getHistoryService().createUserOperationLogQuery();
            List userOperationLogEntries = query.operationType("Delete").batchId(this.batch.getId()).list();
            Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
            UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
            Assert.assertEquals((Object)"cascadeToHistory", (Object)entry.getProperty());
            Assert.assertEquals((Object)"true", (Object)entry.getNewValue());
            Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
            List userOperationLogHistoricEntries = query.operationType("DeleteHistory").batchId(this.batch.getId()).list();
            Assert.assertEquals((long)0L, (long)userOperationLogHistoricEntries.size());
        }
    }
}

