/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.DecisionDefinitionQuery;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiTenancyDecisionDefinitionQueryTest
extends PluggableProcessEngineTest {
    protected static final String DECISION_DEFINITION_KEY = "decision";
    protected static final String DMN = "org/camunda/bpm/engine/test/api/multitenancy/simpleDecisionTable.dmn";
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";

    @Before
    public void setUp() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_TWO, DMN);
    }

    @Test
    public void testQueryNoTenantIdSet() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIds() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void testQueryByDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByTenantIdsIncludeDefinitionsWithoutTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE}).includeDecisionDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    @Test
    public void testQueryByKey() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY);
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryByLatestNoTenantIdSet() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(null).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantId() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assertions.assertThat((String)decisionDefinition.getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(2);
        query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        decisionDefinition = (DecisionDefinition)query.singleResult();
        Assertions.assertThat((String)decisionDefinition.getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithTenantIds() {
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = (DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(2);
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
    }

    @Test
    public void testQueryByLatestWithoutTenantId() {
        this.testRule.deploy(DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
        DecisionDefinition decisionDefinition = (DecisionDefinition)query.singleResult();
        Assertions.assertThat((String)decisionDefinition.getTenantId()).isNull();
        Assertions.assertThat((int)decisionDefinition.getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByLatestWithTenantIdsIncludeDefinitionsWithoutTenantId() {
        this.testRule.deploy(DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        this.testRule.deployForTenant(TENANT_ONE, DMN);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).latestVersion().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Map<String, DecisionDefinition> decisionDefinitionsForTenant = this.getDecisionDefinitionsForTenant(query.list());
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_ONE).getVersion()).isEqualTo(3);
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(TENANT_TWO).getVersion()).isEqualTo(1);
        Assertions.assertThat((int)decisionDefinitionsForTenant.get(null).getVersion()).isEqualTo(2);
    }

    @Test
    public void testQueryByNonExistingTenantId() {
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void testFailQueryByTenantIdNull() {
        try {
            this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{null});
            Assert.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void testQuerySortingAsc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().asc()).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(2);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_ONE);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_TWO);
    }

    @Test
    public void testQuerySortingDesc() {
        List decisionDefinitions = ((DecisionDefinitionQuery)this.repositoryService.createDecisionDefinitionQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).orderByTenantId().desc()).list();
        Assertions.assertThat((List)decisionDefinitions).hasSize(2);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(0)).getTenantId()).isEqualTo((Object)TENANT_TWO);
        Assertions.assertThat((String)((DecisionDefinition)decisionDefinitions.get(1)).getTenantId()).isEqualTo((Object)TENANT_ONE);
    }

    @Test
    public void testQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(1L);
    }

    @Test
    public void testQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).includeDecisionDefinitionsWithoutTenantId().count()).isEqualTo(2L);
    }

    @Test
    public void testQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(1L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(1L);
    }

    @Test
    public void testQueryDisabledTenantCheck() {
        this.processEngineConfiguration.setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        DecisionDefinitionQuery query = this.repositoryService.createDecisionDefinitionQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(3L);
    }

    protected Map<String, DecisionDefinition> getDecisionDefinitionsForTenant(List<DecisionDefinition> decisionDefinitions) {
        HashMap<String, DecisionDefinition> definitionsForTenant = new HashMap<String, DecisionDefinition>();
        for (DecisionDefinition definition : decisionDefinitions) {
            definitionsForTenant.put(definition.getTenantId(), definition);
        }
        return definitionsForTenant;
    }
}

