/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.multitenancy.query.history;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.HistoryService;
import org.camunda.bpm.engine.IdentityService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.history.HistoricActivityInstanceQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.runtime.TestOrderingUtil;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

@RequiredHistoryLevel(value="activity")
public class MultiTenancyHistoricActivityInstanceQueryTest {
    protected static final String TENANT_NULL = null;
    protected static final String TENANT_ONE = "tenant1";
    protected static final String TENANT_TWO = "tenant2";
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testRule = new ProcessEngineTestRule(this.engineRule);
    protected HistoryService historyService;
    protected RuntimeService runtimeService;
    protected IdentityService identityService;
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testRule);

    @Before
    public void setUp() {
        this.historyService = this.engineRule.getHistoryService();
        this.runtimeService = this.engineRule.getRuntimeService();
        this.identityService = this.engineRule.getIdentityService();
        BpmnModelInstance oneTaskProcess = Bpmn.createExecutableProcess((String)"testProcess").startEvent().endEvent().done();
        this.testRule.deployForTenant(TENANT_NULL, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_ONE, oneTaskProcess);
        this.testRule.deployForTenant(TENANT_TWO, oneTaskProcess);
        this.startProcessInstanceForTenant(TENANT_NULL);
        this.startProcessInstanceForTenant(TENANT_ONE);
        this.startProcessInstanceForTenant(TENANT_TWO);
    }

    @Test
    public void shouldQueryWithoutTenantId() {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    @Test
    public void shouldQueryFilterWithoutTenantId() {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().withoutTenantId();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByTenantId() {
        HistoricActivityInstanceQuery queryTenantOne = this.historyService.createHistoricActivityInstanceQuery().tenantIdIn(new String[]{TENANT_ONE});
        HistoricActivityInstanceQuery queryTenantTwo = this.historyService.createHistoricActivityInstanceQuery().tenantIdIn(new String[]{TENANT_TWO});
        Assertions.assertThat((long)queryTenantOne.count()).isEqualTo(2L);
        Assertions.assertThat((long)queryTenantTwo.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryByTenantIds() {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO});
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
    }

    @Test
    public void shouldQueryByNonExistingTenantId() {
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery().tenantIdIn(new String[]{"nonExisting"});
        Assertions.assertThat((long)query.count()).isEqualTo(0L);
    }

    @Test
    public void shouldFailQueryByTenantIdNull() {
        try {
            this.historyService.createHistoricActivityInstanceQuery().tenantIdIn(new String[]{null});
            Assertions.fail((String)"expected exception");
        }
        catch (NullValueException nullValueException) {
            // empty catch block
        }
    }

    @Test
    public void shouldQuerySortingAsc() {
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByTenantId().asc()).list();
        Assertions.assertThat((int)historicActivityInstances.size()).isEqualTo(6);
        TestOrderingUtil.verifySorting(historicActivityInstances, TestOrderingUtil.historicActivityInstanceByTenantId());
    }

    @Test
    public void shouldQuerySortingDesc() {
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().orderByTenantId().desc()).list();
        Assertions.assertThat((int)historicActivityInstances.size()).isEqualTo(6);
        TestOrderingUtil.verifySorting(historicActivityInstances, TestOrderingUtil.inverted(TestOrderingUtil.historicActivityInstanceByTenantId()));
    }

    @Test
    public void shouldQueryNoAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, null);
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenant() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE));
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(4L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(0L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE, TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryAuthenticatedTenants() {
        this.identityService.setAuthentication("user", null, Arrays.asList(TENANT_ONE, TENANT_TWO));
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
        Assertions.assertThat((long)query.withoutTenantId().count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_ONE}).count()).isEqualTo(2L);
        Assertions.assertThat((long)query.tenantIdIn(new String[]{TENANT_TWO}).count()).isEqualTo(2L);
    }

    @Test
    public void shouldQueryDisabledTenantCheck() {
        this.engineRule.getProcessEngineConfiguration().setTenantCheckEnabled(false);
        this.identityService.setAuthentication("user", null, null);
        HistoricActivityInstanceQuery query = this.historyService.createHistoricActivityInstanceQuery();
        Assertions.assertThat((long)query.count()).isEqualTo(6L);
    }

    protected ProcessInstance startProcessInstanceForTenant(String tenant) {
        return this.runtimeService.createProcessInstanceByKey("testProcess").processDefinitionTenantId(tenant).execute();
    }
}

