/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.escalation;

import org.camunda.bpm.engine.runtime.ActivityInstance;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.ActivityInstanceAssert;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Test;

public class EscalationActivityInstanceTreeTest
extends PluggableProcessEngineTest {
    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testThrowEscalationEventFromEmbeddedSubprocess.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("escalationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("taskAfterCatchedEscalation").beginScope("subProcess").activity("taskInSubprocess").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventTest.testInterruptingEscalationBoundaryEvent.bpmn20.xml"})
    @Test
    public void testInterruptingEscalationBoundaryEvent() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("escalationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).activity("taskAfterCatchedEscalation").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testCatchEscalationEventInsideSubprocess.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationEventSubprocessInsideSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("escalationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("taskInSubprocess").beginScope("escalationEventSubprocess").activity("taskAfterCatchedEscalation").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testCatchEscalationEventFromEmbeddedSubprocess.bpmn20.xml"})
    @Test
    public void testNonInterruptingEscalationEventSubprocessOutsideSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("escalationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").activity("taskInSubprocess").endScope().beginScope("escalationEventSubprocess").activity("taskAfterCatchedEscalation").done());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/event/escalation/EscalationEventSubprocessTest.testInterruptionEscalationEventSubprocess.bpmn20.xml"})
    @Test
    public void testInterruptingEscalationEventSubprocessInsideSubprocess() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("escalationProcess");
        ActivityInstance tree = this.runtimeService.getActivityInstance(processInstance.getId());
        ActivityInstanceAssert.assertThat(tree).hasStructure(ActivityInstanceAssert.describeActivityInstanceTree(processInstance.getProcessDefinitionId()).beginScope("subProcess").beginScope("escalationEventSubprocess").activity("taskAfterCatchedEscalation").done());
    }
}

