/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.signal;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.exception.NullValueException;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.IntermediateCatchEventBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.junit.Test;

public class SignalEventReceivedBuilderTest
extends PluggableProcessEngineTest {
    protected BpmnModelInstance signalStartProcess(String processId) {
        return ((StartEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().signal("signal")).userTask().endEvent().done();
    }

    protected BpmnModelInstance signalCatchProcess(String processId) {
        return ((IntermediateCatchEventBuilder)Bpmn.createExecutableProcess((String)processId).startEvent().intermediateCatchEvent().signal("signal")).userTask().endEvent().done();
    }

    @Test
    public void testSendSignalToStartEvent() {
        this.testRule.deploy(this.signalStartProcess("signalStart"));
        this.runtimeService.createSignalEvent("signal").send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testSendSignalToIntermediateCatchEvent() {
        this.testRule.deploy(this.signalCatchProcess("signalCatch"));
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.createSignalEvent("signal").send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testSendSignalToStartAndIntermediateCatchEvent() {
        this.testRule.deploy(this.signalStartProcess("signalStart"), this.signalCatchProcess("signalCatch"));
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.createSignalEvent("signal").send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(2L);
    }

    @Test
    public void testSendSignalToMultipleStartEvents() {
        this.testRule.deploy(this.signalStartProcess("signalStart"), this.signalStartProcess("signalStart2"));
        this.runtimeService.createSignalEvent("signal").send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(2L);
    }

    @Test
    public void testSendSignalToMultipleIntermediateCatchEvents() {
        this.testRule.deploy(this.signalCatchProcess("signalCatch"), this.signalCatchProcess("signalCatch2"));
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.startProcessInstanceByKey("signalCatch2");
        this.runtimeService.createSignalEvent("signal").send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(2L);
    }

    @Test
    public void testSendSignalWithExecutionId() {
        this.testRule.deploy(this.signalCatchProcess("signalCatch"), this.signalCatchProcess("signalCatch2"));
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("signalCatch");
        this.runtimeService.startProcessInstanceByKey("signalCatch2");
        EventSubscription eventSubscription = (EventSubscription)this.runtimeService.createEventSubscriptionQuery().processInstanceId(processInstance.getId()).singleResult();
        String executionId = eventSubscription.getExecutionId();
        this.runtimeService.createSignalEvent("signal").executionId(executionId).send();
        Assertions.assertThat((long)this.taskService.createTaskQuery().count()).isEqualTo(1L);
    }

    @Test
    public void testSendSignalToStartEventWithVariables() {
        this.testRule.deploy(this.signalStartProcess("signalStart"));
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b");
        this.runtimeService.createSignalEvent("signal").setVariables((Map)variables).send();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assertions.assertThat((Map)this.runtimeService.getVariables(execution.getId())).isEqualTo((Object)variables);
    }

    @Test
    public void testSendSignalToIntermediateCatchEventWithVariables() {
        this.testRule.deploy(this.signalCatchProcess("signalCatch"));
        this.runtimeService.startProcessInstanceByKey("signalCatch");
        VariableMap variables = Variables.createVariables().putValue("var1", (Object)"a").putValue("var2", (Object)"b");
        this.runtimeService.createSignalEvent("signal").setVariables((Map)variables).send();
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().singleResult();
        Assertions.assertThat((Map)this.runtimeService.getVariables(execution.getId())).isEqualTo((Object)variables);
    }

    @Test
    public void testNoSignalEventSubscription() {
        this.runtimeService.createSignalEvent("signal").send();
    }

    @Test
    public void testNonExistingExecutionId() {
        try {
            this.runtimeService.createSignalEvent("signal").executionId("nonExisting").send();
        }
        catch (NullValueException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot find execution with id 'nonExisting'"});
        }
    }

    @Test
    public void testNoSignalEventSubscriptionWithExecutionId() {
        this.testRule.deploy(Bpmn.createExecutableProcess((String)"noSignal").startEvent().userTask().endEvent().done());
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("noSignal");
        String executionId = processInstance.getId();
        try {
            this.runtimeService.createSignalEvent("signal").executionId(executionId).send();
        }
        catch (NotFoundException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Execution '" + executionId + "' has not subscribed to a signal event with name 'signal'"});
        }
    }
}

