/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.event.timer;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.impl.db.DbEntity;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.CommandExecutor;
import org.camunda.bpm.engine.impl.persistence.entity.JobEntity;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.JobQuery;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class TimerRecalculationTest
extends PluggableProcessEngineTest {
    private Set<String> jobIds = new HashSet<String>();

    @After
    public void tearDown() {
        this.clearMeterLog();
        for (String jobId : this.jobIds) {
            this.clearJobLog(jobId);
            this.clearJob(jobId);
        }
        this.jobIds = new HashSet<String>();
    }

    @Test
    public void testUnknownId() {
        try {
            this.managementService.recalculateJobDuedate("unknownID", false);
            Assert.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.testRule.assertTextPresent("No job found with id 'unknownID", pe.getMessage());
        }
    }

    @Test
    public void testEmptyId() {
        try {
            this.managementService.recalculateJobDuedate("", false);
            Assert.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.testRule.assertTextPresent("The job id is mandatory: jobId is empty", pe.getMessage());
        }
    }

    @Test
    public void testNullId() {
        try {
            this.managementService.recalculateJobDuedate(null, false);
            Assert.fail((String)"The recalculation with an unknown job ID should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.testRule.assertTextPresent("The job id is mandatory: jobId is null", pe.getMessage());
        }
    }

    @Deployment
    @Test
    public void testFinishedJob() {
        HashMap<String, Date> variables1 = new HashMap<String, Date>();
        variables1.put("dueDate", new Date());
        ProcessInstance pi1 = this.runtimeService.startProcessInstanceByKey("intermediateTimerEventExample", variables1);
        Assert.assertEquals((long)1L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        JobQuery jobQuery = this.managementService.createJobQuery().executable();
        Assert.assertEquals((long)1L, (long)jobQuery.count());
        String jobId = ((Job)jobQuery.singleResult()).getId();
        this.managementService.recalculateJobDuedate(jobId, false);
        this.managementService.executeJob(jobId);
        Assert.assertEquals((long)0L, (long)this.managementService.createJobQuery().processInstanceId(pi1.getId()).count());
        this.testRule.assertProcessEnded(pi1.getProcessInstanceId());
        try {
            this.managementService.recalculateJobDuedate(jobId, false);
            Assert.fail((String)"The recalculation of a finished job should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.testRule.assertTextPresent("No job found with id '" + jobId, pe.getMessage());
        }
    }

    @Test
    public void testEverLivingJob() {
        Job job = this.historyService.cleanUpHistoryAsync(true);
        this.jobIds.add(job.getId());
        this.tryRecalculateUnsupported(job, "history-cleanup");
    }

    @Deployment
    @Test
    public void testMessageJob() {
        this.runtimeService.startProcessInstanceByKey("asyncService");
        Job job = (Job)this.managementService.createJobQuery().singleResult();
        this.jobIds.add(job.getId());
        this.tryRecalculateUnsupported(job, "async-continuation");
    }

    protected void tryRecalculateUnsupported(Job job, String type) {
        try {
            this.managementService.recalculateJobDuedate(job.getId(), false);
            Assert.fail((String)"The recalculation with an unsupported type should not be possible");
        }
        catch (ProcessEngineException pe) {
            this.testRule.assertTextPresent("Only timer jobs can be recalculated, but the job with id '" + job.getId() + "' is of type '" + type, pe.getMessage());
        }
    }

    protected void clearMeterLog() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getMeterLogManager().deleteAll();
                return null;
            }
        });
    }

    protected void clearJobLog(final String jobId) {
        CommandExecutor commandExecutor = this.processEngineConfiguration.getCommandExecutorTxRequired();
        commandExecutor.execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                commandContext.getHistoricJobLogManager().deleteHistoricJobLogByJobId(jobId);
                return null;
            }
        });
    }

    protected void clearJob(final String jobId) {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Object>(){

            public Object execute(CommandContext commandContext) {
                JobEntity job = commandContext.getJobManager().findJobById(jobId);
                if (job != null) {
                    commandContext.getJobManager().delete((DbEntity)job);
                }
                return null;
            }
        });
    }
}

