/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.bpmn.receivetask;

import java.util.List;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.impl.event.EventType;
import org.camunda.bpm.engine.runtime.EventSubscription;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.util.PluggableProcessEngineTest;
import org.junit.Assert;
import org.junit.Test;

public class ReceiveTaskTest
extends PluggableProcessEngineTest {
    private List<EventSubscription> getEventSubscriptionList() {
        return this.runtimeService.createEventSubscriptionQuery().eventType(EventType.MESSAGE.name()).list();
    }

    private List<EventSubscription> getEventSubscriptionList(String activityId) {
        return this.runtimeService.createEventSubscriptionQuery().eventType(EventType.MESSAGE.name()).activityId(activityId).list();
    }

    private String getExecutionId(String processInstanceId, String activityId) {
        return ((Execution)this.runtimeService.createExecutionQuery().processInstanceId(processInstanceId).activityId(activityId).singleResult()).getId();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.simpleReceiveTask.bpmn20.xml"})
    @Test
    public void testReceiveTaskWithoutMessageReference() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.runtimeService.signal(processInstance.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsLegacySignalingOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)1L, (long)this.getEventSubscriptionList().size());
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsCorrelateMessageOnSingleReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.correlateMessage(subscription.getEventName());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.singleReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsCorrelateMessageByBusinessKeyOnSingleReceiveTask() {
        ProcessInstance processInstance23 = this.runtimeService.startProcessInstanceByKey("testProcess", "23");
        ProcessInstance processInstance42 = this.runtimeService.startProcessInstanceByKey("testProcess", "42");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptionList.size());
        this.runtimeService.correlateMessage("newInvoiceMessage", "23");
        Assert.assertEquals((long)1L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance23.getId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInstance42.getId()).count());
        this.runtimeService.correlateMessage("newInvoiceMessage", "42");
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance42.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsLegacySignalingOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        subscription = subscriptionList.get(0);
        Assert.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.signal(this.getExecutionId(processInstance.getId(), "waitState"));
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        subscription = subscriptionList.get(0);
        Assert.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSequentialReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsCorrelateMessageOnSequentialMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        String firstSubscriptionId = subscription.getId();
        this.runtimeService.correlateMessage(subscription.getEventName());
        subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        subscription = subscriptionList.get(0);
        Assert.assertFalse((boolean)firstSubscriptionId.equals(subscription.getId()));
        this.runtimeService.correlateMessage(subscription.getEventName());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsLegacySignalingOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInstance.getId()).activityId("waitState").messageEventSubscriptionName("newInvoiceMessage").list();
        Assert.assertEquals((long)2L, (long)executions.size());
        this.runtimeService.signal(((Execution)executions.get(0)).getId());
        this.runtimeService.signal(((Execution)executions.get(1)).getId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTask.bpmn20.xml"})
    @Test
    public void testNotSupportsCorrelateMessageOnParallelMultiReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        try {
            this.runtimeService.correlateMessage(subscriptions.get(0).getEventName());
            Assert.fail((String)"should throw a mismatch");
        }
        catch (MismatchingMessageCorrelationException mismatchingMessageCorrelationException) {
            // empty catch block
        }
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskCompensate.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnParallelMultiReceiveTaskWithCompensation() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        Assert.assertEquals((long)1L, (long)this.runtimeService.createEventSubscriptionQuery().eventType(EventType.COMPENSATE.name()).count());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        Assert.assertEquals((long)3L, (long)this.runtimeService.createEventSubscriptionQuery().eventType(EventType.COMPENSATE.name()).count());
        Task task = (Task)this.taskService.createTaskQuery().singleResult();
        this.taskService.complete(task.getId());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskBoundary.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnParallelMultiInstanceWithBoundary() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)3L, (long)this.getEventSubscriptionList().size());
        List<EventSubscription> subscriptions = this.getEventSubscriptionList("waitState");
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiParallelReceiveTaskBoundary.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnParallelMultiInstanceWithBoundaryEventReceived() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        Assert.assertEquals((long)3L, (long)this.getEventSubscriptionList().size());
        List<EventSubscription> subscriptions = this.getEventSubscriptionList("cancel");
        Assert.assertEquals((long)1L, (long)subscriptions.size());
        EventSubscription subscription = subscriptions.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.subProcessReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnSubProcessReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptionList = this.getEventSubscriptionList();
        Assert.assertEquals((long)1L, (long)subscriptionList.size());
        EventSubscription subscription = subscriptionList.get(0);
        this.runtimeService.messageEventReceived(subscription.getEventName(), subscription.getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.multiSubProcessReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnMultiSubProcessReceiveTask() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.parallelGatewayReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsMessageEventReceivedOnReceiveTaskBehindParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.messageEventReceived(subscriptions.get(0).getEventName(), subscriptions.get(0).getExecutionId());
        this.runtimeService.messageEventReceived(subscriptions.get(1).getEventName(), subscriptions.get(1).getExecutionId());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/bpmn/receivetask/ReceiveTaskTest.parallelGatewayReceiveTask.bpmn20.xml"})
    @Test
    public void testSupportsCorrelateMessageOnReceiveTaskBehindParallelGateway() {
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceByKey("testProcess");
        List<EventSubscription> subscriptions = this.getEventSubscriptionList();
        Assert.assertEquals((long)2L, (long)subscriptions.size());
        this.runtimeService.correlateMessage(subscriptions.get(0).getEventName());
        this.runtimeService.correlateMessage(subscriptions.get(1).getEventName());
        Assert.assertEquals((long)0L, (long)this.getEventSubscriptionList().size());
        this.testRule.assertProcessEnded(processInstance.getId());
    }

    @Deployment
    @Test
    public void testWaitStateBehavior() {
        ProcessInstance pi = this.runtimeService.startProcessInstanceByKey("receiveTask");
        Execution execution = (Execution)this.runtimeService.createExecutionQuery().processInstanceId(pi.getId()).activityId("waitState").singleResult();
        Assert.assertNotNull((Object)execution);
        this.runtimeService.signal(execution.getId());
        this.testRule.assertProcessEnded(pi.getId());
    }
}

