/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.operation;

import java.util.ArrayList;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.delegate.CaseExecutionListener;
import org.camunda.bpm.engine.exception.cmmn.CaseIllegalStateTransitionException;
import org.camunda.bpm.engine.impl.cmmn.behavior.CmmnActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.behavior.StageActivityBehavior;
import org.camunda.bpm.engine.impl.cmmn.execution.CaseExecutionImpl;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnActivityExecution;
import org.camunda.bpm.engine.impl.cmmn.execution.CmmnCaseInstance;
import org.camunda.bpm.engine.impl.cmmn.model.CaseDefinitionBuilder;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnCaseDefinition;
import org.camunda.bpm.engine.impl.test.TestHelper;
import org.camunda.bpm.engine.test.cmmn.operation.CaseExecutionStateTransitionCollector;
import org.camunda.bpm.engine.test.cmmn.operation.TaskWaitState;
import org.junit.Assert;
import org.junit.Test;

public class CaseExecutionCompletionTest {
    @Test
    public void testCompleteActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    @Test
    public void testManualCompleteActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    @Test
    public void testCompleteEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        try {
            taskA.complete();
            Assert.fail((String)"It should not be possible to complete an enabled task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isEnabled());
        }
    }

    @Test
    public void testManualCompleteEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        try {
            taskA.manualComplete();
            Assert.fail((String)"It should not be possible to complete an enabled task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isEnabled());
        }
    }

    @Test
    public void testCompleteAlreadyCompletedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.complete();
        Assert.assertTrue((boolean)taskA.isCompleted());
        try {
            taskA.complete();
            Assert.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isCompleted());
        }
    }

    @Test
    public void testManualCompleteAlreadyCompletedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.complete();
        Assert.assertTrue((boolean)taskA.isCompleted());
        try {
            taskA.manualComplete();
            Assert.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isCompleted());
        }
    }

    @Test
    public void testCompleteTerminatedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.terminate();
        Assert.assertTrue((boolean)taskA.isTerminated());
        try {
            taskA.complete();
            Assert.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isTerminated());
        }
    }

    @Test
    public void testManualCompleteTerminatedTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        taskA.terminate();
        Assert.assertTrue((boolean)taskA.isTerminated());
        try {
            taskA.manualComplete();
            Assert.fail((String)"It should not be possible to complete an already completed task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)taskA.isTerminated());
        }
    }

    @Test
    public void testDisableTaskShouldCompleteCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("disable", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        taskA.disable();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("enabled --disable(A)--> disabled");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)taskA.isDisabled());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    @Test
    public void testTerminateTaskShouldCompleteCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("terminate", (CaseExecutionListener)stateTransitionCollector).listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isActive());
        taskA.terminate();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --terminate(A)--> terminated");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)taskA.isTerminated());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertTrue((boolean)((CaseExecutionImpl)caseInstance).getCaseExecutions().isEmpty());
    }

    @Test
    public void testCompleteActiveCaseInstanceWithEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        try {
            caseInstance.complete();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)caseInstance.isActive());
            Assert.assertNotNull((Object)caseInstance.findCaseExecution("A"));
        }
    }

    @Test
    public void testManualCompleteActiveCaseInstanceWithEnabledTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
    }

    @Test
    public void testCompleteActiveCaseInstanceWithActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isActive());
        try {
            caseInstance.complete();
            Assert.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)caseInstance.isActive());
            Assert.assertFalse((boolean)caseInstance.isCompleted());
        }
    }

    @Test
    public void testManualCompleteActiveCaseInstanceWithActiveTask() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        try {
            caseInstance.manualComplete();
            Assert.fail((String)"It should not be possible to complete a case instance containing an active task.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)caseInstance.isActive());
            Assert.assertFalse((boolean)caseInstance.isCompleted());
        }
    }

    @Test
    public void testCompleteAlreadyCompletedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        try {
            caseInstance.complete();
            Assert.fail((String)"It should not be possible to complete an already completed case instance.");
        }
        catch (CaseIllegalStateTransitionException e) {
            Assert.assertTrue((boolean)caseInstance.isCompleted());
        }
    }

    @Test
    public void testManualCompleteAlreadyCompletedCaseInstance() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        Assert.assertTrue((boolean)taskA.isEnabled());
        caseInstance.manualComplete();
        try {
            caseInstance.manualComplete();
            Assert.fail((String)"It should not be possible to complete an already completed case instance.");
        }
        catch (CaseIllegalStateTransitionException e) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)caseInstance.isCompleted()).describedAs("the case instance is still completed", new Object[0])).isTrue();
        }
    }

    @Test
    public void testCompleteOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)taskB.isActive());
        Assert.assertTrue((boolean)stageX.isActive());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Test
    public void testManualCompleteOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)taskB.isActive());
        Assert.assertTrue((boolean)stageX.isActive());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Test
    public void testDisableOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.disable();
        Assert.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        Assert.assertTrue((boolean)taskA.isDisabled());
        Assert.assertTrue((boolean)taskB.isActive());
        Assert.assertTrue((boolean)stageX.isActive());
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertEquals((long)2L, (long)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Test
    public void testTerminateOnlyTaskA() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.terminate();
        Assert.assertTrue((boolean)stateTransitionCollector.stateTransitions.isEmpty());
        Assert.assertTrue((boolean)taskA.isTerminated());
        Assert.assertTrue((boolean)taskB.isActive());
        Assert.assertTrue((boolean)stageX.isActive());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNotNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertEquals((long)1L, (long)((CaseExecutionImpl)stageX).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isActive());
    }

    @Test
    public void testCompleteTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.complete();
        taskB.complete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(B)--> completed");
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)taskB.isCompleted());
        Assert.assertTrue((boolean)stageX.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)0L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Test
    public void testManualCompleteTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.manualComplete();
        taskB.manualComplete();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(A)--> completed");
        expectedStateTransitions.add("active --complete(B)--> completed");
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isCompleted());
        Assert.assertTrue((boolean)taskB.isCompleted());
        Assert.assertTrue((boolean)stageX.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)0L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Test
    public void testDisableTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.disable();
        taskB.disable();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isDisabled());
        Assert.assertTrue((boolean)taskB.isDisabled());
        Assert.assertTrue((boolean)stageX.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)0L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Test
    public void testTerminateTaskAAndTaskB() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new StageActivityBehavior()).createActivity("A").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().createActivity("B").listener("complete", (CaseExecutionListener)stateTransitionCollector).behavior((CmmnActivityBehavior)new TaskWaitState()).endActivity().endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        CmmnActivityExecution taskA = caseInstance.findCaseExecution("A");
        CmmnActivityExecution taskB = caseInstance.findCaseExecution("B");
        taskA.terminate();
        taskB.terminate();
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
        expectedStateTransitions.clear();
        stateTransitionCollector.stateTransitions.clear();
        Assert.assertTrue((boolean)taskA.isTerminated());
        Assert.assertTrue((boolean)taskB.isTerminated());
        Assert.assertTrue((boolean)stageX.isCompleted());
        Assert.assertNull((Object)caseInstance.findCaseExecution("A"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("B"));
        Assert.assertNull((Object)caseInstance.findCaseExecution("X"));
        Assert.assertEquals((long)0L, (long)((CaseExecutionImpl)caseInstance).getCaseExecutions().size());
        Assert.assertTrue((boolean)caseInstance.isCompleted());
    }

    @Test
    public void testAutoCompletionCaseInstanceWithoutChildren() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
    }

    @Test
    public void testAutoCompletionStageWithoutChildren() {
        CaseExecutionStateTransitionCollector stateTransitionCollector = new CaseExecutionStateTransitionCollector();
        CmmnCaseDefinition caseDefinition = new CaseDefinitionBuilder("Case1").listener("complete", (CaseExecutionListener)stateTransitionCollector).createActivity("X").listener("complete", (CaseExecutionListener)stateTransitionCollector).property("manualActivationRule", TestHelper.defaultManualActivation()).behavior((CmmnActivityBehavior)new StageActivityBehavior()).endActivity().buildCaseDefinition();
        CmmnCaseInstance caseInstance = caseDefinition.createCaseInstance();
        caseInstance.create();
        CmmnActivityExecution stageX = caseInstance.findCaseExecution("X");
        stageX.manualStart();
        Assert.assertTrue((boolean)caseInstance.isCompleted());
        Assert.assertTrue((boolean)stageX.isCompleted());
        ArrayList<String> expectedStateTransitions = new ArrayList<String>();
        expectedStateTransitions.add("active --complete(X)--> completed");
        expectedStateTransitions.add("active --complete(Case1)--> completed");
        Assert.assertEquals(expectedStateTransitions, stateTransitionCollector.stateTransitions);
    }
}

