/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.history.useroperationlog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.camunda.bpm.dmn.engine.impl.DefaultDmnEngineConfiguration;
import org.camunda.bpm.engine.history.HistoricDecisionInstance;
import org.camunda.bpm.engine.history.UserOperationLogEntry;
import org.camunda.bpm.engine.history.UserOperationLogQuery;
import org.camunda.bpm.engine.repository.DecisionDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.CaseExecution;
import org.camunda.bpm.engine.task.Task;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.history.useroperationlog.AbstractUserOperationLogTest;
import org.camunda.bpm.engine.test.util.ResetDmnConfigUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UserOperationLogDeletionTest
extends AbstractUserOperationLogTest {
    public static final String DECISION_SINGLE_OUTPUT_DMN = "org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml";
    public static final String DECISION_DEFINITION_KEY = "testDecision";
    protected static final String PROCESS_PATH = "org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml";
    protected static final String PROCESS_KEY = "oneTaskProcess";

    @Before
    public void setUp() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(true).init();
    }

    @After
    public void tearDown() throws Exception {
        DefaultDmnEngineConfiguration dmnEngineConfiguration = this.processEngineConfiguration.getDmnEngineConfiguration();
        ResetDmnConfigUtil.reset(dmnEngineConfiguration).enableFeelLegacyBehavior(false).init();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessTaskKeepTaskOperationLog() {
        this.runtimeService.startProcessInstanceByKey(PROCESS_KEY);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        Assert.assertEquals((long)2L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        Assert.assertEquals((long)4L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").taskId(taskId).property("nrOfInstances").singleResult();
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Test
    public void testDeleteStandaloneTaskKeepUserOperationLog() {
        String taskId = "my-task";
        Task task = this.taskService.newTask(taskId);
        this.taskService.saveTask(task);
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        Assert.assertEquals((long)3L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        Assert.assertEquals((long)5L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDeleteCaseTaskKeepUserOperationLog() {
        this.caseService.withCaseDefinitionByKey("oneTaskCase").create();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.setAssignee(taskId, "demo");
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().taskId(taskId);
        Assert.assertEquals((long)2L, (long)query.count());
        this.historyService.deleteHistoricTaskInstance(taskId);
        Assert.assertEquals((long)4L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessInstanceKeepUserOperationLog() {
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        this.runtimeService.activateProcessInstanceById(processInstanceId);
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processInstanceId(processInstanceId);
        Assert.assertEquals((long)4L, (long)query.count());
        this.historyService.deleteHistoricProcessInstance(processInstanceId);
        Assert.assertEquals((long)4L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").property("nrOfInstances").singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/cmmn/oneTaskCase.cmmn"})
    @Test
    public void testDeleteCaseInstanceKeepUserOperationLog() {
        String caseInstanceId = this.caseService.withCaseDefinitionByKey("oneTaskCase").create().getId();
        ((CaseExecution)this.caseService.createCaseExecutionQuery().activityId("PI_HumanTask_1").singleResult()).getId();
        String taskId = ((Task)this.taskService.createTaskQuery().singleResult()).getId();
        this.taskService.complete(taskId);
        this.caseService.closeCaseInstance(caseInstanceId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().caseInstanceId(caseInstanceId).entityType("Task");
        Assert.assertEquals((long)1L, (long)query.count());
        this.historyService.deleteHistoricCaseInstance(caseInstanceId);
        Assert.assertEquals((long)1L, (long)query.count());
        UserOperationLogEntry entry = (UserOperationLogEntry)this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").singleResult();
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteProcessDefinitionKeepUserOperationLog() {
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        String processInstanceId = this.runtimeService.startProcessInstanceByKey(PROCESS_KEY).getId();
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processInstanceId(processInstanceId);
        Assert.assertEquals((long)2L, (long)query.count());
        this.repositoryService.deleteProcessDefinition(processDefinitionId, true);
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Test
    public void testDeleteProcessDefinitionsByKey() {
        for (int i = 0; i < 3; ++i) {
            this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(PROCESS_PATH));
        }
        this.repositoryService.deleteProcessDefinitions().byKey(PROCESS_KEY).withoutTenantId().delete();
        this.assertUserOperationLogs();
    }

    @Test
    public void testDeleteProcessDefinitionsByKeyCascading() {
        for (int i = 0; i < 3; ++i) {
            this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(PROCESS_PATH));
        }
        this.repositoryService.deleteProcessDefinitions().byKey(PROCESS_KEY).withoutTenantId().cascade().delete();
        this.assertUserOperationLogs();
    }

    @Test
    public void testDeleteProcessDefinitionsByIds() {
        for (int i = 0; i < 3; ++i) {
            this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(PROCESS_PATH));
        }
        this.repositoryService.deleteProcessDefinitions().byIds(this.findProcessDefinitionIdsByKey(PROCESS_KEY)).delete();
        this.assertUserOperationLogs();
    }

    @Test
    public void testDeleteProcessDefinitionsByIdsCascading() {
        for (int i = 0; i < 3; ++i) {
            this.testRule.deploy(this.repositoryService.createDeployment().addClasspathResource(PROCESS_PATH));
        }
        this.repositoryService.deleteProcessDefinitions().byIds(this.findProcessDefinitionIdsByKey(PROCESS_KEY)).cascade().delete();
        this.assertUserOperationLogs();
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/api/oneTaskProcess.bpmn20.xml"})
    @Test
    public void testDeleteDeploymentKeepUserOperationLog() {
        String deploymentId = ((org.camunda.bpm.engine.repository.Deployment)this.repositoryService.createDeploymentQuery().singleResult()).getId();
        String processDefinitionId = ((ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().singleResult()).getId();
        this.repositoryService.suspendProcessDefinitionById(processDefinitionId);
        UserOperationLogQuery query = this.historyService.createUserOperationLogQuery().processDefinitionId(processDefinitionId);
        Assert.assertEquals((long)2L, (long)query.count());
        this.repositoryService.deleteDeployment(deploymentId, true);
        Assert.assertEquals((long)2L, (long)query.count());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteDecisionInstanceByDecisionDefinition() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input1", "test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, variables);
        String decisionDefinitionId = ((DecisionDefinition)this.repositoryService.createDecisionDefinitionQuery().decisionDefinitionKey(DECISION_DEFINITION_KEY).singleResult()).getId();
        this.historyService.deleteHistoricDecisionInstanceByDefinitionId(decisionDefinitionId);
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").property("nrOfInstances").list();
        Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
        Assert.assertEquals((Object)"1", (Object)entry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    @Deployment(resources={"org/camunda/bpm/engine/test/history/HistoricDecisionInstanceTest.decisionSingleOutput.dmn11.xml"})
    @Test
    public void testDeleteDecisionInstanceById() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("input1", "test");
        this.decisionService.evaluateDecisionTableByKey(DECISION_DEFINITION_KEY, variables);
        HistoricDecisionInstance historicDecisionInstance = (HistoricDecisionInstance)this.historyService.createHistoricDecisionInstanceQuery().singleResult();
        this.historyService.deleteHistoricDecisionInstanceByInstanceId(historicDecisionInstance.getId());
        List userOperationLogEntries = this.historyService.createUserOperationLogQuery().operationType("DeleteHistory").property("nrOfInstances").list();
        Assert.assertEquals((long)1L, (long)userOperationLogEntries.size());
        UserOperationLogEntry entry = (UserOperationLogEntry)userOperationLogEntries.get(0);
        Assert.assertEquals((Object)"1", (Object)entry.getNewValue());
        Assert.assertEquals((Object)"Operator", (Object)entry.getCategory());
    }

    public void assertUserOperationLogs() {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().list();
        UserOperationLogQuery userOperationLogQuery = this.historyService.createUserOperationLogQuery().operationType("Delete");
        List userOperationLogs = userOperationLogQuery.list();
        Assert.assertEquals((long)3L, (long)userOperationLogs.size());
        for (ProcessDefinition processDefinition : processDefinitions) {
            UserOperationLogEntry userOperationLogEntry = (UserOperationLogEntry)userOperationLogQuery.deploymentId(processDefinition.getDeploymentId()).singleResult();
            Assert.assertEquals((Object)"ProcessDefinition", (Object)userOperationLogEntry.getEntityType());
            Assert.assertEquals((Object)processDefinition.getId(), (Object)userOperationLogEntry.getProcessDefinitionId());
            Assert.assertEquals((Object)processDefinition.getKey(), (Object)userOperationLogEntry.getProcessDefinitionKey());
            Assert.assertEquals((Object)processDefinition.getDeploymentId(), (Object)userOperationLogEntry.getDeploymentId());
            Assert.assertEquals((Object)"Delete", (Object)userOperationLogEntry.getOperationType());
            Assert.assertEquals((Object)"cascade", (Object)userOperationLogEntry.getProperty());
            Assert.assertFalse((boolean)Boolean.parseBoolean(userOperationLogEntry.getOrgValue()));
            Assert.assertTrue((boolean)Boolean.parseBoolean(userOperationLogEntry.getNewValue()));
            Assert.assertEquals((Object)"demo", (Object)userOperationLogEntry.getUserId());
            Assert.assertEquals((Object)"TaskWorker", (Object)userOperationLogEntry.getCategory());
            Assert.assertNull((Object)userOperationLogEntry.getJobDefinitionId());
            Assert.assertNull((Object)userOperationLogEntry.getProcessInstanceId());
            Assert.assertNull((Object)userOperationLogEntry.getCaseInstanceId());
            Assert.assertNull((Object)userOperationLogEntry.getCaseDefinitionId());
        }
        Assert.assertEquals((long)6L, (long)this.historyService.createUserOperationLogQuery().count());
    }

    private String[] findProcessDefinitionIdsByKey(String processDefinitionKey) {
        List processDefinitions = this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).list();
        ArrayList<String> processDefinitionIds = new ArrayList<String>();
        for (ProcessDefinition processDefinition : processDefinitions) {
            processDefinitionIds.add(processDefinition.getId());
        }
        return processDefinitionIds.toArray(new String[0]);
    }
}

