/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.util;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.camunda.bpm.engine.migration.MigrationInstructionValidationReport;
import org.camunda.bpm.engine.migration.MigrationPlanValidationReport;
import org.camunda.bpm.engine.migration.MigrationVariableValidationReport;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MigrationPlanValidationReportAssert {
    protected MigrationPlanValidationReport actual;

    public MigrationPlanValidationReportAssert(MigrationPlanValidationReport report) {
        this.actual = report;
    }

    public MigrationPlanValidationReportAssert isNotNull() {
        Assert.assertNotNull((String)"Expected report to be not null", (Object)this.actual);
        return this;
    }

    public MigrationPlanValidationReportAssert hasVariableFailures(String name, String ... expectedFailures) {
        this.isNotNull();
        ArrayList failuresFound = new ArrayList();
        this.actual.getVariableReports().entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(name)).findFirst().ifPresent(entry -> failuresFound.addAll(((MigrationVariableValidationReport)entry.getValue()).getFailures()));
        ((ListAssert)Assertions.assertThat(failuresFound).as("Expected failures for variable name '%s':\n%sBut found failures:\n%s", new Object[]{name, this.joinFailures(expectedFailures), this.joinFailures(failuresFound.toArray())})).containsExactlyInAnyOrder((Object[])expectedFailures);
        return this;
    }

    public MigrationPlanValidationReportAssert hasInstructionFailures(String activityId, String ... expectedFailures) {
        this.isNotNull();
        ArrayList failuresFound = new ArrayList();
        for (MigrationInstructionValidationReport instructionReport : this.actual.getInstructionReports()) {
            String sourceActivityId = instructionReport.getMigrationInstruction().getSourceActivityId();
            if ((activityId != null || sourceActivityId != null) && (activityId == null || !activityId.equals(sourceActivityId))) continue;
            failuresFound.addAll(instructionReport.getFailures());
        }
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        for (String expectedFailure : expectedFailures) {
            matchers.add(Matchers.containsString((String)expectedFailure));
        }
        Assert.assertThat((String)("Expected failures for activity id '" + activityId + "':\n" + this.joinFailures(expectedFailures) + "But found failures:\n" + this.joinFailures(failuresFound.toArray())), failuresFound, (Matcher)Matchers.containsInAnyOrder(matchers));
        return this;
    }

    public static MigrationPlanValidationReportAssert assertThat(MigrationPlanValidationReport report) {
        return new MigrationPlanValidationReportAssert(report);
    }

    public String joinFailures(Object[] failures) {
        StringBuilder builder = new StringBuilder();
        for (Object failure : failures) {
            builder.append("\t\t").append(failure).append("\n");
        }
        return builder.toString();
    }
}

