/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.authorization.Authorization;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.impl.TaskQueryImpl;
import org.camunda.bpm.engine.impl.db.AuthorizationCheck;
import org.camunda.bpm.engine.impl.db.entitymanager.DbEntityManager;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.persistence.entity.AuthorizationManager;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.hamcrest.MockitoHamcrest;
import org.mockito.verification.VerificationMode;

public class GroupAuthorizationTest
extends AuthorizationTest {
    public static final String testUserId = "testUser";
    public static final List<String> testGroupIds = Arrays.asList("testGroup1", "testGroup2", "testGroup3");

    @Override
    @Before
    public void setUp() throws Exception {
        this.createUser(testUserId);
        for (String testGroupId : testGroupIds) {
            this.createGroupAndAddUser(testGroupId, testUserId);
        }
        this.identityService.setAuthentication(testUserId, testGroupIds);
        this.processEngineConfiguration.setAuthorizationEnabled(true);
    }

    @Test
    public void testTaskQueryWithoutGroupAuthorizations() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                AuthorizationCheck authCheck = (AuthorizationCheck)Mockito.spy((Object)new AuthorizationCheck());
                Mockito.when((Object)taskQuery.getAuthCheck()).thenReturn((Object)authCheck);
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ((AuthorizationCheck)Mockito.verify((Object)authCheck)).setAuthGroupIds((List)Mockito.eq(Collections.emptyList()));
                return null;
            }
        });
    }

    @Test
    public void testTaskQueryWithOneGroupAuthorization() {
        this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupIds.get(0), new Permission[0]);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                AuthorizationCheck authCheck = (AuthorizationCheck)Mockito.spy((Object)new AuthorizationCheck());
                Mockito.when((Object)taskQuery.getAuthCheck()).thenReturn((Object)authCheck);
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ((AuthorizationCheck)Mockito.verify((Object)authCheck)).setAuthGroupIds((List)Mockito.eq(testGroupIds.subList(0, 1)));
                return null;
            }
        });
    }

    @Test
    public void testTaskQueryWithGroupAuthorization() {
        for (String testGroupId : testGroupIds) {
            this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupId, new Permission[0]);
        }
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                AuthorizationCheck authCheck = (AuthorizationCheck)Mockito.spy((Object)new AuthorizationCheck());
                Mockito.when((Object)taskQuery.getAuthCheck()).thenReturn((Object)authCheck);
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ((AuthorizationCheck)Mockito.verify((Object)authCheck, (VerificationMode)Mockito.atLeastOnce())).setAuthGroupIds((List)MockitoHamcrest.argThat((Matcher)Matchers.containsInAnyOrder((Object[])testGroupIds.toArray())));
                return null;
            }
        });
    }

    @Test
    public void testTaskQueryWithUserWithoutGroups() {
        this.identityService.setAuthentication(testUserId, null);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                TaskQueryImpl taskQuery = (TaskQueryImpl)Mockito.spy((Object)GroupAuthorizationTest.this.processEngine.getTaskService().createTaskQuery());
                AuthorizationCheck authCheck = (AuthorizationCheck)Mockito.spy((Object)new AuthorizationCheck());
                Mockito.when((Object)taskQuery.getAuthCheck()).thenReturn((Object)authCheck);
                taskQuery.list();
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq((Object)null));
                ((AuthorizationCheck)Mockito.verify((Object)authCheck)).setAuthGroupIds((List)Mockito.eq(Collections.emptyList()));
                return null;
            }
        });
    }

    @Test
    public void testCheckAuthorizationWithoutGroupAuthorizations() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)Mockito.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                Assert.assertTrue((boolean)authorizationCheck.getAuthGroupIds().isEmpty());
                return null;
            }
        });
    }

    @Test
    public void testCheckAuthorizationWithOneGroupAuthorizations() {
        this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupIds.get(0), new Permission[0]);
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)Mockito.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                Assert.assertEquals(testGroupIds.subList(0, 1), (Object)authorizationCheck.getAuthGroupIds());
                return null;
            }
        });
    }

    @Test
    public void testCheckAuthorizationWithGroupAuthorizations() {
        for (String testGroupId : testGroupIds) {
            this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupId, new Permission[0]);
        }
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, testGroupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq(testGroupIds));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)Mockito.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                Assertions.assertThat((List)authorizationCheck.getAuthGroupIds()).containsExactlyInAnyOrderElementsOf(testGroupIds);
                return null;
            }
        });
    }

    @Test
    public void testCheckAuthorizationWithUserWithoutGroups() {
        this.processEngineConfiguration.getCommandExecutorTxRequired().execute((Command)new Command<Void>(){

            public Void execute(CommandContext commandContext) {
                AuthorizationManager authorizationManager = GroupAuthorizationTest.this.spyOnSession(commandContext, AuthorizationManager.class);
                DbEntityManager dbEntityManager = GroupAuthorizationTest.this.spyOnSession(commandContext, DbEntityManager.class);
                GroupAuthorizationTest.this.authorizationService.isUserAuthorized(GroupAuthorizationTest.testUserId, null, (Permission)Permissions.READ, (Resource)Resources.TASK);
                ((AuthorizationManager)Mockito.verify((Object)authorizationManager, (VerificationMode)Mockito.atLeastOnce())).filterAuthenticatedGroupIds((List)Mockito.eq((Object)null));
                ArgumentCaptor authorizationCheckArgument = ArgumentCaptor.forClass(AuthorizationCheck.class);
                ((DbEntityManager)Mockito.verify((Object)dbEntityManager)).selectBoolean((String)Mockito.eq((Object)"isUserAuthorizedForResource"), authorizationCheckArgument.capture());
                AuthorizationCheck authorizationCheck = (AuthorizationCheck)authorizationCheckArgument.getValue();
                Assert.assertTrue((boolean)authorizationCheck.getAuthGroupIds().isEmpty());
                return null;
            }
        });
    }

    @Test
    public void testCheckAuthorizationForNullHostileListOfGroups() {
        this.identityService.clearAuthentication();
        BpmnModelInstance process = Bpmn.createExecutableProcess((String)"process").startEvent().userTask("foo").endEvent().done();
        this.testRule.deploy(process);
        this.runtimeService.startProcessInstanceByKey("process");
        this.createGroupGrantAuthorization((Resource)Resources.TASK, "*", testGroupIds.get(0), new Permission[0]);
        this.createGrantAuthorization((Resource)Resources.TASK, "*", testUserId, new Permission[]{Permissions.READ});
        NullHostileList<String> groupIds = new NullHostileList<String>(testGroupIds);
        boolean isAuthorized = this.authorizationService.isUserAuthorized(testUserId, groupIds, (Permission)Permissions.READ, (Resource)Resources.TASK);
        Assertions.assertThat((boolean)isAuthorized).isTrue();
    }

    protected void createGroupGrantAuthorization(Resource resource, String resourceId, String groupId, Permission ... permissions) {
        Authorization authorization = this.createGrantAuthorization(resource, resourceId);
        authorization.setGroupId(groupId);
        for (Permission permission : permissions) {
            authorization.addPermission(permission);
        }
        this.saveAuthorization(authorization);
    }

    protected void createGroupAndAddUser(String groupId, String userId) {
        this.createGroup(groupId);
        this.identityService.createMembership(userId, groupId);
    }

    protected <T extends Session> T spyOnSession(CommandContext commandContext, Class<T> sessionClass) {
        Session manager = (Session)commandContext.getSession(sessionClass);
        Session spy = (Session)Mockito.spy((Object)manager);
        commandContext.getSessions().put(sessionClass, spy);
        return (T)spy;
    }

    protected class NullHostileList<E>
    extends ArrayList<E> {
        public NullHostileList(Collection<E> other) {
            super(other);
        }

        @Override
        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            return super.contains(o);
        }
    }
}

