/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.authorization.externaltask;

import java.util.List;
import org.camunda.bpm.engine.authorization.Permission;
import org.camunda.bpm.engine.authorization.Permissions;
import org.camunda.bpm.engine.authorization.Resource;
import org.camunda.bpm.engine.authorization.Resources;
import org.camunda.bpm.engine.externaltask.LockedExternalTask;
import org.camunda.bpm.engine.test.api.authorization.AuthorizationTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FetchExternalTaskAuthorizationTest
extends AuthorizationTest {
    public static final String WORKER_ID = "workerId";
    public static final long LOCK_TIME = 10000L;
    protected String instance1Id;
    protected String instance2Id;

    @Override
    @Before
    public void setUp() throws Exception {
        this.testRule.deploy("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml", "org/camunda/bpm/engine/test/api/externaltask/twoExternalTaskProcess.bpmn20.xml");
        this.instance1Id = this.startProcessInstanceByKey("oneExternalTaskProcess").getId();
        this.instance2Id = this.startProcessInstanceByKey("twoExternalTaskProcess").getId();
        super.setUp();
    }

    @Test
    public void testFetchWithoutAuthorization() {
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testFetchWithReadOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testFetchWithUpdateOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testFetchWithReadAndUpdateOnProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)this.instance1Id, (Object)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    @Test
    public void testFetchWithReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testFetchWithUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)0L, (long)tasks.size());
    }

    @Test
    public void testFetchWithReadAndUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)this.instance1Id, (Object)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    @Test
    public void testFetchWithReadOnProcessInstanceAndUpdateInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)this.instance1Id, (Object)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    @Test
    public void testFetchWithUpdateOnProcessInstanceAndReadInstanceOnProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.READ_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)this.instance1Id, (Object)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    @Test
    public void testFetchWithReadAndUpdateOnAnyProcessInstance() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testFetchWithMultipleMatchingAuthorizations() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, "*", this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ, Permissions.UPDATE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testQueryWithReadAndUpdateInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)2L, (long)tasks.size());
    }

    @Test
    public void testQueryWithReadProcessInstanceAndUpdateInstanceOnAnyProcessDefinition() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        this.createGrantAuthorization((Resource)Resources.PROCESS_INSTANCE, this.instance1Id, this.userId, new Permission[]{Permissions.READ});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
        Assert.assertEquals((Object)this.instance1Id, (Object)((LockedExternalTask)tasks.get(0)).getProcessInstanceId());
    }

    @Test
    public void shouldLockNoTaskForProcessDefinitionWithRevokedUpdateInstancePermission() {
        this.createGrantAuthorization((Resource)Resources.PROCESS_DEFINITION, "*", this.userId, new Permission[]{Permissions.READ_INSTANCE, Permissions.UPDATE_INSTANCE});
        this.createRevokeAuthorization((Resource)Resources.PROCESS_DEFINITION, "oneExternalTaskProcess", this.userId, new Permission[]{Permissions.UPDATE_INSTANCE});
        List tasks = this.externalTaskService.fetchAndLock(5, WORKER_ID).topic("externalTaskTopic", 10000L).execute();
        Assert.assertEquals((long)1L, (long)tasks.size());
    }
}

