/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.externaltask;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.ExternalTaskService;
import org.camunda.bpm.engine.ManagementService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.batch.Batch;
import org.camunda.bpm.engine.exception.NotFoundException;
import org.camunda.bpm.engine.externaltask.ExternalTask;
import org.camunda.bpm.engine.externaltask.ExternalTaskQuery;
import org.camunda.bpm.engine.history.HistoricProcessInstanceQuery;
import org.camunda.bpm.engine.impl.test.RequiredDatabase;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.camunda.bpm.engine.runtime.Job;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.RequiredHistoryLevel;
import org.camunda.bpm.engine.test.api.AbstractAsyncOperationsTest;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class SetExternalTasksRetriesTest
extends AbstractAsyncOperationsTest {
    protected static final int RETRIES = 5;
    protected ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    private static String PROCESS_DEFINITION_KEY = "oneExternalTaskProcess";
    private static String PROCESS_DEFINITION_KEY_2 = "twoExternalTaskWithPriorityProcess";
    protected ExternalTaskService externalTaskService;
    protected List<String> processInstanceIds;

    @Before
    public void setup() {
        this.initDefaults(this.engineRule);
        this.externalTaskService = this.engineRule.getExternalTaskService();
        this.deployTestProcesses();
    }

    protected void deployTestProcesses() {
        Deployment deployment = this.engineRule.getRepositoryService().createDeployment().addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/oneExternalTaskProcess.bpmn20.xml").addClasspathResource("org/camunda/bpm/engine/test/api/externaltask/externalTaskPriorityExpression.bpmn20.xml").deploy();
        this.engineRule.manageDeployment(deployment);
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        if (this.processInstanceIds == null) {
            this.processInstanceIds = new ArrayList<String>();
        }
        for (int i = 0; i < 4; ++i) {
            this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, "" + i).getId());
        }
        this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY_2).getId());
    }

    @After
    public void tearDown() {
        this.processInstanceIds = null;
    }

    @Test
    public void shouldSetExternalTaskRetriesSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        this.externalTaskService.setRetries(externalTaskIds, 10);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)10L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldFailForNonExistingExternalTaskIdSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add("nonExistingExternalTaskId");
        try {
            this.externalTaskService.setRetries(externalTaskIds, 10);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot find external task with id nonExistingExternalTaskId"});
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdSync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add(null);
        try {
            this.externalTaskService.setRetries(externalTaskIds, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"External task id cannot be null"});
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdsSync() {
        try {
            this.externalTaskService.setRetries((List)null, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"externalTaskIds is empty"});
        }
    }

    @Test
    public void shouldFailForNonExistingExternalTaskIdAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add("nonExistingExternalTaskId");
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 10);
        try {
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (NotFoundException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"Cannot find external task with id nonExistingExternalTaskId"});
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        externalTaskIds.add(null);
        Batch batch = null;
        try {
            batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 10);
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"External task id cannot be null"});
        }
    }

    @Test
    public void shouldFailForNullExternalTaskIdsAsync() {
        try {
            this.externalTaskService.setRetriesAsync((List)null, null, 10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"externalTaskIds is empty"});
        }
    }

    @Test
    public void shouldFailForNegativeRetriesSync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId");
        try {
            this.externalTaskService.setRetries(externalTaskIds, -10);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"The number of retries cannot be negative"});
        }
    }

    @Test
    public void shouldFailForNegativeRetriesAsync() {
        List<String> externalTaskIds = Arrays.asList("externalTaskId");
        try {
            Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, -10);
            this.executeSeedAndBatchJobs(batch);
            Assert.fail((String)"exception expected");
        }
        catch (BadUserRequestException e) {
            Assertions.assertThat((String)e.getMessage()).contains(new CharSequence[]{"The number of retries cannot be negative"});
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithQueryAsync() {
        ExternalTaskQuery externalTaskQuery = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Batch batch = this.externalTaskService.setRetriesAsync(null, externalTaskQuery, 5);
        this.executeSeedAndBatchJobs(batch);
        for (ExternalTask task : externalTaskQuery.list()) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithListAsync() {
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 5);
        this.executeSeedAndBatchJobs(batch);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithListAsyncInDifferentDeployments() {
        this.deployTestProcesses();
        ProcessDefinitionQuery definitionQuery = this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey(PROCESS_DEFINITION_KEY);
        String firstDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(1)).singleResult()).getDeploymentId();
        String secondDeploymentId = ((ProcessDefinition)definitionQuery.processDefinitionVersion(Integer.valueOf(2)).singleResult()).getDeploymentId();
        List externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJob(6);
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, null, 5);
        this.executeSeedJobs(batch, 2);
        List batchJobs = this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list();
        Assertions.assertThat((List)batchJobs).hasSize(2);
        Assert.assertThat((Object)((Job)batchJobs.get(0)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        Assert.assertThat((Object)((Job)batchJobs.get(1)).getDeploymentId(), (Matcher)IsIn.isOneOf((Object[])new String[]{firstDeploymentId, secondDeploymentId}));
        Assertions.assertThat((String)((Job)batchJobs.get(0)).getDeploymentId()).isNotEqualTo((Object)((Job)batchJobs.get(1)).getDeploymentId());
        Assertions.assertThat((long)this.getTaskCountWithUnchangedRetries()).isEqualTo(12L);
        this.getJobIdsByDeployment(batchJobs, firstDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        Assertions.assertThat((long)this.getTaskCountWithUnchangedRetries()).isEqualTo(6L);
        this.getJobIdsByDeployment(batchJobs, secondDeploymentId).forEach(arg_0 -> ((ManagementService)this.managementService).executeJob(arg_0));
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithListAndQueryAsync() {
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery();
        List externalTasks = externalTaskQuery.list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task : externalTasks) {
            externalTaskIds.add(task.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, externalTaskQuery, 5);
        this.executeSeedAndBatchJobs(batch);
        externalTasks = this.externalTaskService.createExternalTaskQuery().list();
        for (ExternalTask task : externalTasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    @RequiredHistoryLevel(value="full")
    @RequiredDatabase(excludes={"cockroachdb"})
    public void shouldSetExternalTaskRetriesWithLargeList() {
        this.engineRule.getProcessEngineConfiguration().setBatchJobsPerSeed(1010);
        List<String> processIds = this.startProcessInstance(PROCESS_DEFINITION_KEY, 1100);
        HistoricProcessInstanceQuery processInstanceQuery = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.externalTaskService.updateRetries().historicProcessInstanceQuery(processInstanceQuery).setAsync(3);
        this.executeSeedJobs(batch, 2);
        this.executeBatchJobs(batch);
        this.assertHistoricBatchExists();
        if (!this.testHelper.isHistoryLevelNone()) {
            batch = this.historyService.deleteHistoricProcessInstancesAsync(processIds, null);
            this.executeSeedJobs(batch, 2);
            this.executeBatchJobs(batch);
        }
    }

    @Test
    public void shouldSetExternalTaskRetriesWithDifferentListAndQueryAsync() {
        ExternalTask task2;
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0));
        List externalTasks = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(this.processInstanceIds.size() - 1)).list();
        ArrayList<String> externalTaskIds = new ArrayList<String>();
        for (ExternalTask task2 : externalTasks) {
            externalTaskIds.add(task2.getId());
        }
        Batch batch = this.externalTaskService.setRetriesAsync(externalTaskIds, externalTaskQuery, 8);
        this.executeSeedAndBatchJobs(batch);
        task2 = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        Assert.assertEquals((long)8L, (long)task2.getRetries().intValue());
        List tasks = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(this.processInstanceIds.size() - 1)).list();
        for (ExternalTask t : tasks) {
            Assert.assertEquals((long)8L, (long)t.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByExternalTaskIds() {
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId(), ((ExternalTask)tasks.get(5)).getId());
        Batch batch = this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByExternalTaskIdArray() {
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        List<String> externalTaskIds = Arrays.asList(((ExternalTask)tasks.get(0)).getId(), ((ExternalTask)tasks.get(1)).getId(), ((ExternalTask)tasks.get(2)).getId(), ((ExternalTask)tasks.get(3)).getId(), ((ExternalTask)tasks.get(4)).getId(), ((ExternalTask)tasks.get(5)).getId());
        Batch batch = this.externalTaskService.updateRetries().externalTaskIds(externalTaskIds.toArray(new String[0])).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByProcessInstanceIds() {
        Batch batch = this.externalTaskService.updateRetries().processInstanceIds(this.processInstanceIds).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByProcessInstanceIdArray() {
        Batch batch = this.externalTaskService.updateRetries().processInstanceIds(this.processInstanceIds.toArray(new String[0])).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByExternalTaskQuery() {
        ExternalTaskQuery query = this.externalTaskService.createExternalTaskQuery();
        Batch batch = this.externalTaskService.updateRetries().externalTaskQuery(query).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = query.list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    public void shouldUpdateRetriesByProcessInstanceQuery() {
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery();
        Batch batch = this.externalTaskService.updateRetries().processInstanceQuery(processInstanceQuery).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void shouldUpdateRetriesByHistoricProcessInstanceQuery() {
        HistoricProcessInstanceQuery query = this.historyService.createHistoricProcessInstanceQuery();
        Batch batch = this.externalTaskService.updateRetries().historicProcessInstanceQuery(query).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((long)5L, (long)task.getRetries().intValue());
        }
    }

    @Test
    @RequiredHistoryLevel(value="audit")
    public void shouldUpdateRetriesByAllParameters() {
        ExternalTask externalTask = (ExternalTask)this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(0)).singleResult();
        ExternalTaskQuery externalTaskQuery = this.externalTaskService.createExternalTaskQuery().processInstanceId(this.processInstanceIds.get(1));
        ProcessInstanceQuery processInstanceQuery = this.runtimeService.createProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(2));
        HistoricProcessInstanceQuery historicProcessInstanceQuery = this.historyService.createHistoricProcessInstanceQuery().processInstanceId(this.processInstanceIds.get(3));
        Batch batch = this.externalTaskService.updateRetries().externalTaskIds(new String[]{externalTask.getId()}).externalTaskQuery(externalTaskQuery).processInstanceQuery(processInstanceQuery).historicProcessInstanceQuery(historicProcessInstanceQuery).processInstanceIds(new String[]{this.processInstanceIds.get(4)}).setAsync(5);
        this.executeSeedAndBatchJobs(batch);
        List tasks = this.externalTaskService.createExternalTaskQuery().list();
        Assert.assertEquals((long)6L, (long)tasks.size());
        for (ExternalTask task : tasks) {
            Assert.assertEquals((Object)5, (Object)task.getRetries());
        }
    }

    protected void executeSeedAndBatchJobs(Batch batch) {
        this.completeSeedJobs(batch);
        for (Job pending : this.managementService.createJobQuery().jobDefinitionId(batch.getBatchJobDefinitionId()).list()) {
            this.managementService.executeJob(pending.getId());
        }
    }

    protected void assertHistoricBatchExists() {
        if (this.testHelper.isHistoryLevelFull()) {
            Assert.assertEquals((long)1L, (long)this.historyService.createHistoricBatchQuery().count());
        }
    }

    protected void startTestProcesses() {
        RuntimeService runtimeService = this.engineRule.getRuntimeService();
        for (int i = 4; i < 1000; ++i) {
            this.processInstanceIds.add(runtimeService.startProcessInstanceByKey(PROCESS_DEFINITION_KEY, "" + i).getId());
        }
    }

    protected List<String> startProcessInstance(String key, int instances) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < instances; ++i) {
            ids.add(this.runtimeService.startProcessInstanceByKey(key, String.valueOf(i)).getId());
        }
        this.processInstanceIds.addAll(ids);
        return ids;
    }

    @Test
    public void shouldSetInvocationsPerBatchType() {
        this.engineRule.getProcessEngineConfiguration().getInvocationsPerBatchJobByBatchType().put("set-external-task-retries", 42);
        ExternalTaskQuery externalTaskQuery = this.engineRule.getExternalTaskService().createExternalTaskQuery();
        Batch batch = this.externalTaskService.setRetriesAsync(null, externalTaskQuery, 5);
        Assertions.assertThat((int)batch.getInvocationsPerBatchJob()).isEqualTo(42);
        this.engineRule.getProcessEngineConfiguration().setInvocationsPerBatchJobByBatchType(new HashMap());
    }

    protected long getTaskCountWithUnchangedRetries() {
        return this.externalTaskService.createExternalTaskQuery().list().stream().filter(et -> !Integer.valueOf(5).equals(et.getRetries())).count();
    }
}

