/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.variables.scope;

import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.ScriptEvaluationException;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.impl.persistence.entity.ProcessInstanceWithVariablesImpl;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.Deployment;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.api.runtime.migration.ModifiableBpmnModelInstance;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.engine.variable.VariableMap;
import org.camunda.bpm.engine.variable.Variables;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.CallActivityBuilder;
import org.camunda.bpm.model.bpmn.builder.EndEventBuilder;
import org.camunda.bpm.model.bpmn.builder.MultiInstanceLoopCharacteristicsBuilder;
import org.camunda.bpm.model.bpmn.builder.ServiceTaskBuilder;
import org.camunda.bpm.model.bpmn.builder.StartEventBuilder;
import org.camunda.bpm.model.bpmn.builder.UserTaskBuilder;
import org.camunda.bpm.model.bpmn.instance.BpmnModelElementInstance;
import org.camunda.bpm.model.bpmn.instance.SequenceFlow;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.junit.Rule;
import org.junit.Test;

public class TargetVariableScopeTest {
    @Rule
    public ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    @Rule
    public ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithDelegateProcess.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithDelegateProcess() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables);
        Assertions.assertThat((boolean)processInstance.isEnded()).isTrue();
        Assertions.assertThat((boolean)((ProcessInstanceWithVariablesImpl)processInstance).getVariables().containsKey((Object)"targetOrderId")).isFalse();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithScriptTargetScope.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithScriptTargetScope() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessInstance processInstance = this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables);
        Assertions.assertThat((boolean)processInstance.isEnded()).isTrue();
        Assertions.assertThat((boolean)((ProcessInstanceWithVariablesImpl)processInstance).getVariables().containsKey((Object)"targetOrderId")).isFalse();
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/TargetVariableScopeTest.testExecutionWithoutProperTargetScope.bpmn", "org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testExecutionWithoutProperTargetScope() {
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ProcessDefinition processDefinition = (ProcessDefinition)this.engineRule.getRepositoryService().createProcessDefinitionQuery().processDefinitionKey("Process_MultiInstanceCallAcitivity").singleResult();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().startProcessInstanceByKey("Process_MultiInstanceCallAcitivity", (Map)variables)).isInstanceOf(ScriptEvaluationException.class)).hasMessageContaining("Unable to evaluate script while executing activity 'CallActivity_1' in the process definition with id '" + processDefinition.getId() + "': org.camunda.bpm.engine.ProcessEngineException: ENGINE-20011 Scope with specified activity Id NOT_EXISTING and execution");
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testWithDelegateVariableMapping() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().subProcess("SubProcess_1").embeddedSubProcess().startEvent().callActivity().calledElement("Process_StuffDoer")).camundaVariableMappingClass("org.camunda.bpm.engine.test.api.variables.scope.SetVariableMappingDelegate")).serviceTask().camundaClass("org.camunda.bpm.engine.test.api.variables.scope.AssertVariableScopeDelegate")).endEvent().subProcessDone().endEvent().done();
        instance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(instance).activityBuilder("SubProcess_1").multiInstance().parallel()).camundaCollection("orderIds")).camundaElementVariable("orderId")).done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables);
    }

    @Test
    @Deployment(resources={"org/camunda/bpm/engine/test/api/variables/scope/doer.bpmn"})
    public void testWithDelegateVariableMappingAndChildScope() {
        BpmnModelInstance instance = ((ServiceTaskBuilder)((CallActivityBuilder)((CallActivityBuilder)Bpmn.createExecutableProcess((String)"process1").startEvent().parallelGateway().subProcess("SubProcess_1").embeddedSubProcess().startEvent().callActivity().calledElement("Process_StuffDoer")).camundaVariableMappingClass("org.camunda.bpm.engine.test.api.variables.scope.SetVariableToChildMappingDelegate")).serviceTask().camundaClass("org.camunda.bpm.engine.test.api.variables.scope.AssertVariableScopeDelegate")).endEvent().subProcessDone().moveToLastGateway().subProcess("SubProcess_2").embeddedSubProcess().startEvent().userTask("ut").endEvent().subProcessDone().endEvent().done();
        instance = ((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)((MultiInstanceLoopCharacteristicsBuilder)ModifiableBpmnModelInstance.modify(instance).activityBuilder("SubProcess_1").multiInstance().parallel()).camundaCollection("orderIds")).camundaElementVariable("orderId")).done();
        ProcessDefinition processDefinition = this.testHelper.deployAndGetDefinition(instance);
        VariableMap variables = Variables.createVariables().putValue("orderIds", Arrays.asList(new int[][]{{1, 2, 3}}));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.engineRule.getRuntimeService().startProcessInstanceById(processDefinition.getId(), (Map)variables)).isInstanceOf(ProcessEngineException.class)).hasMessageContaining("org.camunda.bpm.engine.ProcessEngineException: ENGINE-20011 Scope with specified activity Id SubProcess_2 and execution");
    }

    @Test
    public void testSetLocalScopeWithJavaDelegate() {
        this.testHelper.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().serviceTask().id("activityId")).camundaClass(JavaDelegate.class)).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeWithExecutionListenerStart() {
        this.testHelper.deploy(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().id("activityId")).camundaExecutionListenerClass("start", ExecutionListener.class)).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeWithExecutionListenerEnd() {
        this.testHelper.deploy(((EndEventBuilder)((EndEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().endEvent().id("activityId")).camundaExecutionListenerClass("end", ExecutionListener.class)).done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeWithExecutionListenerTake() {
        BpmnModelInstance modelInstance = ((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().id("activityId")).sequenceFlowId("sequenceFlow")).endEvent().done();
        CamundaExecutionListener listener = (CamundaExecutionListener)modelInstance.newInstance(CamundaExecutionListener.class);
        listener.setCamundaEvent("take");
        listener.setCamundaClass(ExecutionListener.class.getName());
        ((SequenceFlow)modelInstance.getModelElementById("sequenceFlow")).builder().addExtensionElement((BpmnModelElementInstance)listener);
        this.testHelper.deploy(modelInstance);
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeWithTaskListener() {
        this.testHelper.deploy(((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().userTask().id("activityId")).camundaTaskListenerClass("create", TaskListener.class)).endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeInSubprocessWithJavaDelegate() {
        this.testHelper.deploy(((ServiceTaskBuilder)((ServiceTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().serviceTask().id("activityId")).camundaClass(JavaDelegate.class)).endEvent().subProcessDone().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeInSubprocessWithStartExecutionListener() {
        this.testHelper.deploy(((StartEventBuilder)((StartEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().id("activityId")).camundaExecutionListenerClass("start", ExecutionListener.class)).endEvent().subProcessDone().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeInSubprocessWithEndExecutionListener() {
        this.testHelper.deploy(((EndEventBuilder)((EndEventBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().endEvent().id("activityId")).camundaExecutionListenerClass("end", ExecutionListener.class)).subProcessDone().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    @Test
    public void testSetLocalScopeInSubprocessWithTaskListener() {
        this.testHelper.deploy(((UserTaskBuilder)((UserTaskBuilder)Bpmn.createExecutableProcess((String)"process").startEvent().subProcess().embeddedSubProcess().startEvent().userTask().id("activityId")).camundaTaskListenerClass("create", TaskListener.class)).endEvent().subProcessDone().endEvent().done());
        this.engineRule.getRuntimeService().startProcessInstanceByKey("process");
    }

    public static class JavaDelegate
    implements org.camunda.bpm.engine.delegate.JavaDelegate {
        public void execute(DelegateExecution execution) {
            execution.setVariable("varName", (Object)"varValue", "activityId");
            Assertions.assertThat((Object)execution.getVariableLocal("varName")).isNotNull();
        }
    }

    public static class ExecutionListener
    implements org.camunda.bpm.engine.delegate.ExecutionListener {
        public void notify(DelegateExecution execution) {
            execution.setVariable("varName", (Object)"varValue", "activityId");
            Assertions.assertThat((Object)execution.getVariableLocal("varName")).isNotNull();
        }
    }

    public static class TaskListener
    implements org.camunda.bpm.engine.delegate.TaskListener {
        public void notify(DelegateTask delegateTask) {
            DelegateExecution execution = delegateTask.getExecution();
            execution.setVariable("varName", (Object)"varValue", "activityId");
            Assertions.assertThat((Object)execution.getVariableLocal("varName")).isNotNull();
        }
    }
}

