/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.cmmn.handler.specification;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.camunda.bpm.engine.delegate.BaseDelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.cmmn.model.CmmnActivity;
import org.camunda.bpm.engine.test.cmmn.handler.specification.FieldSpec;
import org.camunda.bpm.engine.test.cmmn.handler.specification.SpecUtil;
import org.camunda.bpm.model.cmmn.CmmnModelInstance;
import org.camunda.bpm.model.cmmn.instance.CmmnModelElementInstance;
import org.camunda.bpm.model.cmmn.instance.ExtensionElements;
import org.camunda.bpm.model.cmmn.instance.camunda.CamundaCaseExecutionListener;
import org.junit.Assert;

public abstract class AbstractExecutionListenerSpec {
    public static final String ANY_EVENT = "any";
    protected String eventNameToRegisterOn;
    protected Set<String> expectedRegisteredEvents;
    protected List<FieldSpec> fieldSpecs;

    public AbstractExecutionListenerSpec(String eventName) {
        this.eventNameToRegisterOn = eventName;
        this.expectedRegisteredEvents = new HashSet<String>();
        this.expectedRegisteredEvents.add(eventName);
        this.fieldSpecs = new ArrayList<FieldSpec>();
    }

    public void addListenerToElement(CmmnModelInstance modelInstance, CmmnModelElementInstance modelElement) {
        ExtensionElements extensionElements = SpecUtil.createElement(modelInstance, modelElement, null, ExtensionElements.class);
        CamundaCaseExecutionListener caseExecutionListener = SpecUtil.createElement(modelInstance, (CmmnModelElementInstance)extensionElements, null, CamundaCaseExecutionListener.class);
        if (!ANY_EVENT.equals(this.eventNameToRegisterOn)) {
            caseExecutionListener.setCamundaEvent(this.eventNameToRegisterOn);
        }
        this.configureCaseExecutionListener(modelInstance, caseExecutionListener);
        for (FieldSpec fieldSpec : this.fieldSpecs) {
            fieldSpec.addFieldToListenerElement(modelInstance, caseExecutionListener);
        }
    }

    protected abstract void configureCaseExecutionListener(CmmnModelInstance var1, CamundaCaseExecutionListener var2);

    public void verify(CmmnActivity activity) {
        Assert.assertEquals((long)this.expectedRegisteredEvents.size(), (long)activity.getListeners().size());
        for (String expectedRegisteredEvent : this.expectedRegisteredEvents) {
            List listeners = activity.getListeners(expectedRegisteredEvent);
            Assert.assertEquals((long)1L, (long)listeners.size());
            this.verifyListener((DelegateListener<? extends BaseDelegateExecution>)((DelegateListener)listeners.get(0)));
        }
    }

    protected abstract void verifyListener(DelegateListener<? extends BaseDelegateExecution> var1);

    public AbstractExecutionListenerSpec expectRegistrationFor(List<String> events) {
        this.expectedRegisteredEvents = new HashSet<String>(events);
        return this;
    }

    public AbstractExecutionListenerSpec withFieldExpression(String fieldName, String expression) {
        this.fieldSpecs.add(new FieldSpec(fieldName, expression, null, null, null));
        return this;
    }

    public AbstractExecutionListenerSpec withFieldChildExpression(String fieldName, String expression) {
        this.fieldSpecs.add(new FieldSpec(fieldName, null, expression, null, null));
        return this;
    }

    public AbstractExecutionListenerSpec withFieldStringValue(String fieldName, String value) {
        this.fieldSpecs.add(new FieldSpec(fieldName, null, null, value, null));
        return this;
    }

    public AbstractExecutionListenerSpec withFieldChildStringValue(String fieldName, String value) {
        this.fieldSpecs.add(new FieldSpec(fieldName, null, null, null, value));
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{type=");
        sb.append(this.getClass().getSimpleName());
        sb.append(", event=");
        sb.append(this.eventNameToRegisterOn);
        sb.append("}");
        return sb.toString();
    }
}

