/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.engine.test.api.context;

import java.util.concurrent.Callable;
import org.assertj.core.api.Assertions;
import org.camunda.bpm.engine.context.ProcessEngineContext;
import org.camunda.bpm.engine.impl.interceptor.Command;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.engine.runtime.ProcessInstance;
import org.camunda.bpm.engine.test.ProcessEngineRule;
import org.camunda.bpm.engine.test.util.ProcessEngineTestRule;
import org.camunda.bpm.engine.test.util.ProvidedProcessEngineRule;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.builder.ProcessBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class ProcessEngineContextTest {
    protected final ProcessEngineRule engineRule = new ProvidedProcessEngineRule();
    protected final ProcessEngineTestRule testHelper = new ProcessEngineTestRule(this.engineRule);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.engineRule).around((TestRule)this.testHelper);
    protected static final String SIMPLE_PROCESS_KEY = "simple_process";
    protected static final BpmnModelInstance SIMPLE_PROCESS = ((ProcessBuilder)Bpmn.createExecutableProcess((String)"simple_process").camundaHistoryTimeToLive(Integer.valueOf(180))).startEvent().userTask("simpleUserTask").endEvent().done();

    @Before
    public void setUp() {
        this.testHelper.deploy(SIMPLE_PROCESS);
        this.engineRule.getRuntimeService().startProcessInstanceByKey(SIMPLE_PROCESS_KEY);
    }

    @Test
    public void shouldUseFreshCacheOnNewCommandContext() throws Exception {
        this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute(new OuterCommand<Void>(new NestedCommand<Void>(){

            @Override
            public Void call() {
                Assertions.assertThat((Object)this.getOuterCommandContext()).isNotEqualTo((Object)this.commandContext);
                Assertions.assertThat((Object)this.getNestedPiObject()).isNotEqualTo((Object)this.getOuterCommand().getOuterPiObject());
                return null;
            }
        }, true));
    }

    @Test
    public void shouldUseSameCommandContextOnTxRequired() throws Exception {
        ProcessEngineContext.withNewProcessEngineContext((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                return (Void)ProcessEngineContextTest.this.engineRule.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute(new OuterCommand<Void>(new NestedCommand<Void>(){

                    @Override
                    public Void call() {
                        Assertions.assertThat((Object)this.getOuterCommandContext()).isEqualTo((Object)this.getCommandContext());
                        Assertions.assertThat((Object)this.getNestedPiObject()).isEqualTo((Object)this.getOuterCommand().getOuterPiObject());
                        return null;
                    }
                }, false));
            }
        });
    }

    protected class OuterCommand<T>
    implements Command<T> {
        protected CommandContext commandContext;
        protected NestedCommand<T> nestedCommand;
        protected Boolean requiresNew;
        protected ProcessInstance outerPiObject;

        public OuterCommand(NestedCommand<T> nestedCommand, Boolean requiresNew) {
            this.nestedCommand = nestedCommand;
            this.nestedCommand.setOuterCommand(this);
            this.requiresNew = requiresNew;
        }

        public T execute(CommandContext commandContext) {
            this.commandContext = commandContext;
            this.outerPiObject = (ProcessInstance)ProcessEngineContextTest.this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey(ProcessEngineContextTest.SIMPLE_PROCESS_KEY).singleResult();
            if (this.requiresNew.booleanValue()) {
                try {
                    ProcessEngineContext.withNewProcessEngineContext((Callable)new Callable<T>(){

                        @Override
                        public T call() {
                            return OuterCommand.this.executeNestedCommand();
                        }
                    });
                }
                catch (Exception e) {
                    Assertions.fail((String)("Test failed with exception: " + e.getMessage()));
                }
            } else {
                return this.executeNestedCommand();
            }
            return null;
        }

        protected T executeNestedCommand() {
            return (T)this.commandContext.getProcessEngineConfiguration().getCommandExecutorTxRequired().execute(this.nestedCommand);
        }

        public ProcessInstance getOuterPiObject() {
            return this.outerPiObject;
        }

        public CommandContext getCommandContext() {
            return this.commandContext;
        }
    }

    protected abstract class NestedCommand<T>
    implements Command<T>,
    Callable<T> {
        CommandContext commandContext;
        OuterCommand outerCommand;
        protected ProcessInstance nestedPiObject;

        protected NestedCommand() {
        }

        @Override
        public abstract T call();

        public T execute(CommandContext commandContext) {
            this.commandContext = commandContext;
            this.nestedPiObject = (ProcessInstance)ProcessEngineContextTest.this.engineRule.getRuntimeService().createProcessInstanceQuery().processDefinitionKey(ProcessEngineContextTest.SIMPLE_PROCESS_KEY).singleResult();
            try {
                return this.call();
            }
            catch (Exception e) {
                Assertions.fail((String)("Test failed with exception: " + e.getMessage()));
                return null;
            }
        }

        public OuterCommand getOuterCommand() {
            return this.outerCommand;
        }

        public void setOuterCommand(OuterCommand outerCommand) {
            this.outerCommand = outerCommand;
        }

        public CommandContext getOuterCommandContext() {
            return this.getOuterCommand().getCommandContext();
        }

        public CommandContext getCommandContext() {
            return this.commandContext;
        }

        public ProcessInstance getNestedPiObject() {
            return this.nestedPiObject;
        }
    }
}

